/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.LogicalPlanStats;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.PruneFileSourcePartitionsSuite$Optimize$;
import org.apache.spark.sql.execution.datasources.PrunePartitionSuiteBase;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.FileScan;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.enablers.Size$;
import org.scalatest.matchers.should.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0006\r\u0001eAQ\u0001\n\u0001\u0005\u0002\u0015BQa\n\u0001\u0005B!BQa\f\u0001\u0005BA:Q\u0001\u0010\u0001\t\u0002u2Qa\u0010\u0001\t\u0002\u0001CQ\u0001J\u0003\u0005\u0002ECqAU\u0003C\u0002\u0013\u00051\u000b\u0003\u0004a\u000b\u0001\u0006I\u0001\u0016\u0005\u0006C\u0002!\tB\u0019\u0005\u0006s\u0002!\tE\u001f\u0002\u001f!J,h.\u001a$jY\u0016\u001cv.\u001e:dKB\u000b'\u000f^5uS>t7oU;ji\u0016T!!\u0004\b\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u001fA\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Qb\u0004\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\t9\u0002K];oKB\u000b'\u000f^5uS>t7+^5uK\n\u000b7/\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0003CA\tA\u0001^3ti&\u00111\u0005\t\u0002\u0013'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002MA\u00111\u0004A\u0001\u000bE\u00164wN]3FC\u000eDG#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e^\u0001\u0007M>\u0014X.\u0019;\u0016\u0003E\u0002\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b,\u001b\u0005)$B\u0001\u001c\u0019\u0003\u0019a$o\\8u}%\u0011\u0001hK\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029W\u0005Aq\n\u001d;j[&TX\r\u0005\u0002?\u000b5\t\u0001A\u0001\u0005PaRLW.\u001b>f'\t)\u0011\tE\u0002C\u000f&k\u0011a\u0011\u0006\u0003\t\u0016\u000bQA];mKNT!A\u0012\t\u0002\u0011\r\fG/\u00197zgRL!\u0001S\"\u0003\u0019I+H.Z#yK\u000e,Ho\u001c:\u0011\u0005){U\"A&\u000b\u00051k\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u001d\u0016\u000bQ\u0001\u001d7b]NL!\u0001U&\u0003\u00171{w-[2bYBc\u0017M\u001c\u000b\u0002{\u00059!-\u0019;dQ\u0016\u001cX#\u0001+\u0011\u0007USF,D\u0001W\u0015\t9\u0006,A\u0005j[6,H/\u00192mK*\u0011\u0011lK\u0001\u000bG>dG.Z2uS>t\u0017BA.W\u0005\u0011a\u0015n\u001d;\u0011\u0005usV\"A\u0003\n\u0005};%!\u0002\"bi\u000eD\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u00023\r|G\u000e\\3diB\u000b'\u000f^5uS>tg)\u001b7uKJ\u001chI\u001c\u000b\u0002GB!!\u0006\u001a4k\u0013\t)7FA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\t9\u0007.D\u0001\u000f\u0013\tIgBA\u0005Ta\u0006\u00148\u000e\u00157b]B\u00191\u000e]:\u000f\u00051tgB\u0001\u001bn\u0013\u0005a\u0013BA8,\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001d:\u0003\u0007M+\u0017O\u0003\u0002pWA\u0011Ao^\u0007\u0002k*\u0011a/R\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002yk\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u00021\u001d,GoU2b]\u0016CXm\u0019)beRLG/[8o'&TX\r\u0006\u0002|}B\u0011!\u0006`\u0005\u0003{.\u0012A\u0001T8oO\")qP\u0003a\u0001M\u0006!\u0001\u000f\\1o\u0001")
public class PruneFileSourcePartitionsSuite
extends PrunePartitionSuiteBase
implements SharedSparkSession {
    private volatile PruneFileSourcePartitionsSuite$Optimize$ Optimize$module;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    public PruneFileSourcePartitionsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
        System.gc();
    }

    @Override
    public String format() {
        return "parquet";
    }

    @Override
    public PartialFunction<SparkPlan, Seq<Expression>> collectPartitionFiltersFn() {
        return new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof FileSourceScanExec) {
                    FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)A1;
                    return (B1)fileSourceScanExec.partitionFilters();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                return sparkPlan2 instanceof FileSourceScanExec;
            }
        };
    }

    @Override
    public long getScanExecPartitionSize(SparkPlan plan) {
        return BoxesRunTime.unboxToInt((Object)plan.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BatchScanExec batchScanExec;
                Scan scan;
                A1 A1 = x1;
                if (A1 instanceof FileSourceScanExec) {
                    FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)A1;
                    return (B1)BoxesRunTime.boxToInteger((int)fileSourceScanExec.selectedPartitions().length);
                }
                if (A1 instanceof BatchScanExec && (scan = (batchScanExec = (BatchScanExec)A1).scan()) instanceof FileScan) {
                    FileScan fileScan = (FileScan)scan;
                    return (B1)BoxesRunTime.boxToInteger((int)fileScan.fileIndex().listFiles(fileScan.partitionFilters(), fileScan.dataFilters()).length());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                BatchScanExec batchScanExec;
                Scan scan;
                SparkPlan sparkPlan2 = x1;
                if (sparkPlan2 instanceof FileSourceScanExec) {
                    return true;
                }
                return sparkPlan2 instanceof BatchScanExec && (scan = (batchScanExec = (BatchScanExec)sparkPlan2).scan()) instanceof FileScan;
            }
        }).get());
    }

    private final void Optimize$lzycompute$1() {
        PruneFileSourcePartitionsSuite pruneFileSourcePartitionsSuite = this;
        synchronized (pruneFileSourcePartitionsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new PruneFileSourcePartitionsSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$3(CatalogTable tableMeta$1, StructField f) {
        return tableMeta$1.partitionColumnNames().contains((Object)f.name());
    }

    public static final /* synthetic */ void $anonfun$new$12(PruneFileSourcePartitionsSuite $this, File dir) {
        $this.spark().range(10L).coalesce(1).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).parquet(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().parquet(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            $this.assertPrunedPartitions("SELECT COUNT(*) FROM tmp WHERE p = 0", 1L, "(tmp.p = 0)");
            $this.assertPrunedPartitions("SELECT input_file_name() FROM tmp WHERE p = 0", 1L, "(tmp.p = 0)");
        });
    }

    public static final /* synthetic */ void $anonfun$new$16(PruneFileSourcePartitionsSuite $this, File dir) {
        $this.spark().range(10L).coalesce(1).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).parquet(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().parquet(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            $this.assertPrunedPartitions("SELECT * FROM tmp WHERE (p = 0 AND id > 0) OR (p = 1 AND id = 2)", 2L, "((tmp.p = 0) || (tmp.p = 1))");
            $this.assertPrunedPartitions("SELECT * FROM tmp WHERE p = 0 AND id > 0", 1L, "(tmp.p = 0)");
            $this.assertPrunedPartitions("SELECT * FROM tmp WHERE p = 0", 1L, "(tmp.p = 0)");
        });
    }

    public static final /* synthetic */ void $anonfun$new$20(PruneFileSourcePartitionsSuite $this, File dir) {
        $this.spark().range(10L).coalesce(1).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).parquet(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().parquet(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            $this.assertPrunedPartitions("SELECT * FROM tmp WHERE rand() > 0.5", 3L, "");
            $this.assertPrunedPartitions("SELECT * FROM tmp WHERE p > rand()", 3L, "");
            $this.assertPrunedPartitions("SELECT * FROM tmp WHERE p = 0 AND rand() > 0.5", 1L, "(tmp.p = 0)");
        });
    }

    public PruneFileSourcePartitionsSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("PruneFileSourcePartitions should not change the output of LogicalRelation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("test");
            CatalogTable tableMeta = this.spark().sharedState().externalCatalog().getTable("default", "test");
            CatalogFileIndex catalogFileIndex = new CatalogFileIndex(this.spark(), tableMeta, 0L);
            StructType dataSchema = StructType$.MODULE$.apply((Seq)tableMeta.schema().filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PruneFileSourcePartitionsSuite.$anonfun$new$3(tableMeta, f))));
            HadoopFsRelation relation = new HadoopFsRelation((FileIndex)catalogFileIndex, tableMeta.partitionSchema(), dataSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), Predef$.MODULE$.Map().empty(), this.spark());
            LogicalRelation logicalRelation = LogicalRelation$.MODULE$.apply((BaseRelation)relation, tableMeta);
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)logicalRelation))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)query);
            AttributeSet $org_scalatest_assert_macro_left = optimized.missingInput();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("SPARK-20986 Reset table's statistics after PruneFileSourcePartitions rule", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            BigInt size2;
            Bool bool;
            this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("tbl");
            this.sql().apply((Object)"ANALYZE TABLE tbl COMPUTE STATISTICS");
            Option tableStats = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl")).stats();
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(tableStats.isDefined(), "tableStats.isDefined", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)tableStats.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"tableStats is lost", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM tbl WHERE p = 1");
            Seq sizes1 = df.queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)A1;
                        return (B1)((CatalogStatistics)((CatalogTable)logicalRelation.catalogTable().get()).stats().get()).sizeInBytes();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof LogicalRelation;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes1.size()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("Size wrong for:\n " + df.queryExecution()), Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            BigInt $org_scalatest_assert_macro_left4 = (BigInt)sizes1.apply(0);
            BigInt $org_scalatest_assert_macro_right3 = ((CatalogStatistics)tableStats.get()).sizeInBytes();
            BigInt bigInt = $org_scalatest_assert_macro_left4;
            BigInt bigInt2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Seq relations = df.queryExecution().optimizedPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)A1;
                        return (B1)logicalRelation;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    return logicalPlan instanceof LogicalRelation;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)relations.size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)("Size wrong for:\n " + df.queryExecution()), Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            BigInt $org_scalatest_assert_macro_left6 = size2 = ((LogicalPlanStats)relations.apply(0)).stats().sizeInBytes();
            BigInt $org_scalatest_assert_macro_right5 = ((CatalogStatistics)((CatalogTable)((LogicalRelation)relations.apply(0)).catalogTable().get()).stats().get()).sizeInBytes();
            BigInt bigInt3 = $org_scalatest_assert_macro_left6;
            BigInt bigInt4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(bigInt3 != null ? !bigInt3.equals(bigInt4) : bigInt4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            BigInt $org_scalatest_assert_macro_left7 = size2;
            BigInt $org_scalatest_assert_macro_right6 = ((CatalogStatistics)tableStats.get()).sizeInBytes();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "<", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$less((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("SPARK-26576 Broadcast hint not applied to partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("tbl");
            Dataset df = this.spark().table("tbl");
            QueryExecution qe = df.join(functions$.MODULE$.broadcast(df), "p").queryExecution();
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)qe.sparkPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof BroadcastHashJoinExec) {
                        BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                        return (B1)broadcastHashJoinExec;
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(SparkPlan x3) {
                    SparkPlan sparkPlan2 = x3;
                    return sparkPlan2 instanceof BroadcastHashJoinExec;
                }
            }), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
        })), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("SPARK-35985 push filters for empty read schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.USE_V1_SOURCE_LIST().key(), (Object)"")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            PruneFileSourcePartitionsSuite.$anonfun$new$12(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("SPARK-38357: data + partition filters with OR", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.USE_V1_SOURCE_LIST().key(), (Object)"")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            PruneFileSourcePartitionsSuite.$anonfun$new$16(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("SPARK-40565: don't push down non-deterministic filters for V2 file sources", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.USE_V1_SOURCE_LIST().key(), (Object)"")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            PruneFileSourcePartitionsSuite.$anonfun$new$20(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        Statics.releaseFence();
    }
}

