/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command.v1;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.FakeLocalFsFileSystem;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000552qa\u0001\u0003\u0011\u0002\u0007\u00051\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0004$\u0001\t\u0007I\u0011\t\u0013\u0003-Q\u0013XO\\2bi\u0016$\u0016M\u00197f'VLG/\u001a\"bg\u0016T!!\u0002\u0004\u0002\u0005Y\f$BA\u0004\t\u0003\u001d\u0019w.\\7b]\u0012T!!\u0003\u0006\u0002\u0013\u0015DXmY;uS>t'BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00151A\u0011QCF\u0007\u0002\u0015%\u0011qC\u0003\u0002\n#V,'/\u001f+fgR\u0004\"!\u0007\u000e\u000e\u0003\u0019I!a\u0001\u0004\u0002\r\u0011Jg.\u001b;%)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSR\fa#\u001b8wC2LG\rU1si\u000e{G.^7o\u000bJ\u0014xN]\u000b\u0002KA\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005Y\u0006twMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#AB*ue&tw\r")
public interface TruncateTableSuiteBase
extends org.apache.spark.sql.execution.command.TruncateTableSuiteBase {
    public void org$apache$spark$sql$execution$command$v1$TruncateTableSuiteBase$_setter_$invalidPartColumnError_$eq(String var1);

    @Override
    public String invalidPartColumnError();

    public static /* synthetic */ void $anonfun$$init$$4(TruncateTableSuiteBase $this, boolean ignore$1, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (col INT) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + t + " SELECT 1"));
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(t), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        Path tablePath = new Path((URI)$this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"ns"))).storage().locationUri().get());
        Configuration hadoopConf = $this.spark().sessionState().newHadoopConf();
        FileSystem fs = tablePath.getFileSystem(hadoopConf);
        FileStatus fileStatus = fs.getFileStatus(tablePath);
        fs.setPermission(tablePath, new FsPermission("777"));
        String $org_scalatest_assert_macro_left = fileStatus.getPermission().toString();
        String $org_scalatest_assert_macro_right = "rwxrwxrwx";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        ArrayList<AclEntry> customAcl = new ArrayList<AclEntry>();
        customAcl.add(new AclEntry.Builder().setName("test").setType(AclEntryType.USER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.READ).build());
        fs.setAcl(tablePath, customAcl);
        AclEntry $org_scalatest_assert_macro_left2 = (AclEntry)fs.getAclStatus(tablePath).getEntries().get(0);
        AclEntry $org_scalatest_assert_macro_right2 = (AclEntry)customAcl.get(0);
        AclEntry aclEntry = $org_scalatest_assert_macro_left2;
        AclEntry aclEntry2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(aclEntry != null ? !aclEntry.equals(aclEntry2) : aclEntry2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        $this.sql().apply((Object)("TRUNCATE TABLE " + t));
        Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table(t).collect());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        FileStatus fileStatus2 = fs.getFileStatus(tablePath);
        if (ignore$1) {
            String $org_scalatest_assert_macro_left4 = fileStatus2.getPermission().toString();
            String $org_scalatest_assert_macro_right3 = "rwxrwxrwx";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right3, string3 == null ? string4 != null : !string3.equals(string4), Prettifier$.MODULE$.default());
            v3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        } else {
            String $org_scalatest_assert_macro_left5 = fileStatus2.getPermission().toString();
            String $org_scalatest_assert_macro_right4 = "rwxrwxrwx";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            v3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        }
        List aclEntries = fs.getAclStatus(tablePath).getEntries();
        if (ignore$1) {
            List $org_scalatest_assert_macro_left6 = aclEntries;
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            return;
        }
        List $org_scalatest_assert_macro_left7 = aclEntries;
        int $org_scalatest_assert_macro_right6 = 4;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        AclEntry $org_scalatest_assert_macro_left8 = (AclEntry)aclEntries.get(0);
        AclEntry $org_scalatest_assert_macro_right7 = (AclEntry)customAcl.get(0);
        AclEntry aclEntry3 = $org_scalatest_assert_macro_left8;
        AclEntry aclEntry4 = $org_scalatest_assert_macro_right7;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right7, !(aclEntry3 != null ? !aclEntry3.equals(aclEntry4) : aclEntry4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        AclEntry user = new AclEntry.Builder().setType(AclEntryType.USER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        AclEntry group = new AclEntry.Builder().setType(AclEntryType.GROUP).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        AclEntry other = new AclEntry.Builder().setType(AclEntryType.OTHER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        AclEntry $org_scalatest_assert_macro_left9 = (AclEntry)aclEntries.get(1);
        AclEntry $org_scalatest_assert_macro_right8 = user;
        AclEntry aclEntry5 = $org_scalatest_assert_macro_left9;
        AclEntry aclEntry6 = $org_scalatest_assert_macro_right8;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right8, !(aclEntry5 != null ? !aclEntry5.equals(aclEntry6) : aclEntry6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        AclEntry $org_scalatest_assert_macro_left10 = (AclEntry)aclEntries.get(2);
        AclEntry $org_scalatest_assert_macro_right9 = group;
        AclEntry aclEntry7 = $org_scalatest_assert_macro_left10;
        AclEntry aclEntry8 = $org_scalatest_assert_macro_right9;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right9, !(aclEntry7 != null ? !aclEntry7.equals(aclEntry8) : aclEntry8 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        AclEntry $org_scalatest_assert_macro_left11 = (AclEntry)aclEntries.get(3);
        AclEntry $org_scalatest_assert_macro_right10 = other;
        AclEntry aclEntry9 = $org_scalatest_assert_macro_left11;
        AclEntry aclEntry10 = $org_scalatest_assert_macro_right10;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right10, !(aclEntry9 != null ? !aclEntry9.equals(aclEntry10) : aclEntry10 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    public static /* synthetic */ void $anonfun$$init$$8(TruncateTableSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (col1 STRING, col2 INT) " + $this.defaultUsing() + " PARTITIONED BY (col2)"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (col2 = 1) SELECT 'one'"));
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(t), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"one", BoxesRunTime.boxToInteger((int)1)})));
        SessionCatalog qual$1 = $this.spark().sessionState().catalog();
        TableIdentifier x$1 = TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"ns"));
        Option x$2 = qual$1.listPartitions$default$2();
        CatalogTablePartition part = (CatalogTablePartition)qual$1.listPartitions(x$1, x$2).head();
        File path = new File(part.location().getPath());
        $this.sql().apply((Object)("TRUNCATE TABLE " + t));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(path.exists(), "path.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        path.delete();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(path.exists(), "path.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        $this.sql().apply((Object)("TRUNCATE TABLE " + t));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(path.exists(), "path.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    public static /* synthetic */ void $anonfun$$init$$13(TruncateTableSuiteBase $this, String t) {
        $this.spark().range(100L).write().saveAsTable(t);
        $this.sql().apply((Object)("ANALYZE TABLE " + t + " COMPUTE STATISTICS"));
        $this.spark().table(t);
        $this.sql().apply((Object)("TRUNCATE TABLE " + t));
        $this.spark().table(t);
        SessionCatalog catalog = $this.spark().sessionState().catalog();
        QualifiedTableName qualifiedTableName = new QualifiedTableName("ns", "tbl");
        LogicalPlan cachedPlan = catalog.getCachedTable(qualifiedTableName);
        BigInt $org_scalatest_assert_macro_left = cachedPlan.stats().sizeInBytes();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
    }

    public static /* synthetic */ void $anonfun$$init$$15(TruncateTableSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id INT, value INT) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + t + " SELECT 0, 100"));
        $this.sql().apply((Object)("ANALYZE TABLE " + t + " COMPUTE STATISTICS FOR COLUMNS id, value"));
        int $org_scalatest_assert_macro_left = $this.getTableSize(t);
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("TRUNCATE TABLE " + t));
            int $org_scalatest_assert_macro_left = $this.getTableSize(t);
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        });
    }

    public static /* synthetic */ void $anonfun$$init$$19(TruncateTableSuiteBase $this, String t) {
        Bool bool;
        int sizeOfTwoParts;
        $this.sql().apply((Object)("CREATE TABLE " + t + " (c0 int, part int) " + $this.defaultUsing() + " PARTITIONED BY (part)"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=0) SELECT 0"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=1) SELECT 1"));
        int $org_scalatest_assert_macro_left = sizeOfTwoParts = $this.getTableSize(t);
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        $this.sql().apply((Object)("TRUNCATE TABLE " + t + " PARTITION (part=1)"));
        int sizeOfOnePart = $this.getTableSize(t);
        int $org_scalatest_assert_macro_left2 = 0;
        int $org_scalatest_assert_macro_right2 = sizeOfOnePart;
        Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left3.value()) {
            int $org_scalatest_assert_macro_left4 = sizeOfOnePart;
            int $org_scalatest_assert_macro_right3 = sizeOfTwoParts;
            bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        } else {
            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right4 = bool;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }

    public static void $init$(TruncateTableSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$v1$TruncateTableSuiteBase$_setter_$invalidPartColumnError_$eq("TRUNCATE TABLE ... PARTITION is not supported for tables that are not partitioned");
        $this.test("SPARK-30312: truncate table - keep acl/permission", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)ignore -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.file.impl"), (Object)FakeLocalFsFileSystem.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.file.impl.disable.cache"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TRUNCATE_TABLE_IGNORE_PERMISSION_ACL().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)ignore)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
                TruncateTableSuiteBase.$anonfun$$init$$4($this, ignore, t);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        $this.test("SPARK-31163: acl/permission should handle non-existed path when truncating table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TRUNCATE_TABLE_IGNORE_PERMISSION_ACL().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            TruncateTableSuiteBase.$anonfun$$init$$8($this, t);
            return BoxedUnit.UNIT;
        })), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        $this.test("invalidation of tableRelationCache after table truncation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
                TruncateTableSuiteBase.$anonfun$$init$$13($this, t);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        $this.test("change stats after truncate command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            TruncateTableSuiteBase.$anonfun$$init$$15($this, t);
            return BoxedUnit.UNIT;
        }), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        $this.test("SPARK-34251: stats in truncated non-empty table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            TruncateTableSuiteBase.$anonfun$$init$$19($this, t);
            return BoxedUnit.UNIT;
        })), new Position("TruncateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }
}

