/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command.v1;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t2qAA\u0002\u0011\u0002\u0007\u0005!\u0003C\u0003\u001b\u0001\u0011\u00051DA\fTQ><\b+\u0019:uSRLwN\\:Tk&$XMQ1tK*\u0011A!B\u0001\u0003mFR!AB\u0004\u0002\u000f\r|W.\\1oI*\u0011\u0001\"C\u0001\nKb,7-\u001e;j_:T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u00192\u0001A\n\u0018!\t!R#D\u0001\n\u0013\t1\u0012BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011\u0001$G\u0007\u0002\u000b%\u0011!!B\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\u0002")
public interface ShowPartitionsSuiteBase
extends org.apache.spark.sql.execution.command.ShowPartitionsSuiteBase {
    public static void $init$(ShowPartitionsSuiteBase $this) {
        $this.test("show everything in the default database", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "dateTable";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createDateTable(table);
                Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=1"}));
                Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=2"}));
                Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=2"}));
                Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=3"}));
                $this.runShowPartitionsSql("show partitions default." + table, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        $this.test("show partitions of a view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "dateTable";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createDateTable(table);
                String view = "view1";
                $this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)("CREATE VIEW " + view + " as select * from " + table));
                    ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SHOW PARTITIONS " + view)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)"`spark_catalog`.`default`.`view1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"SHOW PARTITIONS")})), ((SparkFunSuite)$this).ExpectedContext().apply(view, 16, 20));
                });
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        $this.test("show partitions of a temporary view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "test_view";
            $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.spark().range(10L).createTempView(viewName);
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SHOW PARTITIONS " + viewName)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)"`test_view`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"SHOW PARTITIONS")})), ((SparkFunSuite)$this).ExpectedContext().apply(viewName, 16, 24));
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        $this.test("SPARK-33591: null as a partition value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "part_table";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (col1 INT, p1 STRING) " + $this.defaultUsing() + " PARTITIONED BY (p1)"));
                $this.sql().apply((Object)("INSERT INTO TABLE " + t + " PARTITION (p1 = null) SELECT 0"));
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SHOW PARTITIONS " + t)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"p1=__HIVE_DEFAULT_PARTITION__"})));
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SHOW PARTITIONS " + t + " PARTITION (p1 = null)")), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"p1=__HIVE_DEFAULT_PARTITION__"})));
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }
}

