/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils;
import org.apache.spark.sql.execution.command.DropTableSuiteBase$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i2q\u0001B\u0003\u0011\u0002\u0007\u0005!\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0004\u0007\u0001\t\u0007I\u0011I\u0012\t\u000b1\u0002A\u0011C\u0017\u0003%\u0011\u0013x\u000e\u001d+bE2,7+^5uK\n\u000b7/\u001a\u0006\u0003\r\u001d\tqaY8n[\u0006tGM\u0003\u0002\t\u0013\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005I\u0011B\u0001\f\n\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001935\tQ!\u0003\u0002\u001b\u000b\t\u0019B\t\u0012'D_6l\u0017M\u001c3UKN$X\u000b^5mg\u00061A%\u001b8ji\u0012\"\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0005+:LG/F\u0001%!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u0015;sS:<\u0017aC2sK\u0006$X\rV1cY\u0016$\"!\b\u0018\t\u000b=\u001a\u0001\u0019\u0001\u0019\u0002\u0013Q\f'\r\\3OC6,\u0007CA\u00199\u001d\t\u0011d\u0007\u0005\u00024?5\tAG\u0003\u00026#\u00051AH]8pizJ!aN\u0010\u0002\rA\u0013X\rZ3g\u0013\tY\u0013H\u0003\u00028?\u0001")
public interface DropTableSuiteBase
extends DDLCommandTestUtils {
    public void org$apache$spark$sql$execution$command$DropTableSuiteBase$_setter_$command_$eq(String var1);

    @Override
    public String command();

    public static /* synthetic */ void createTable$(DropTableSuiteBase $this, String tableName) {
        $this.createTable(tableName);
    }

    default public void createTable(String tableName) {
        this.sql().apply((Object)("CREATE TABLE " + tableName + " (c int) " + this.defaultUsing()));
        this.sql().apply((Object)("INSERT INTO " + tableName + " SELECT 0"));
    }

    public static void $init$(DropTableSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$DropTableSuiteBase$_setter_$command_$eq("DROP TABLE");
        $this.test("basic", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.catalog() + ".ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE NAMESPACE " + $this.catalog() + ".ns"));
            $this.createTable($this.catalog() + ".ns.tbl");
            $this.checkTables("ns", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}));
            $this.sql().apply((Object)("DROP TABLE " + $this.catalog() + ".ns.tbl"));
            $this.checkTables("ns", (Seq<String>)Nil$.MODULE$);
        }), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        $this.test("try to drop a nonexistent table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.catalog() + ".ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE NAMESPACE " + $this.catalog() + ".ns"));
            $this.checkTables("ns", (Seq<String>)Nil$.MODULE$);
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("DROP TABLE " + $this.catalog() + ".ns.tbl")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            ((SparkFunSuite)$this).checkErrorTableNotFound((SparkThrowable)e, "`" + $this.catalog() + "`.`ns`.`tbl`");
        }), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        $this.test("with IF EXISTS", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.catalog() + ".ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE NAMESPACE " + $this.catalog() + ".ns"));
            $this.createTable($this.catalog() + ".ns.tbl");
            $this.checkTables("ns", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}));
            $this.sql().apply((Object)("DROP TABLE IF EXISTS " + $this.catalog() + ".ns.tbl"));
            $this.checkTables("ns", (Seq<String>)Nil$.MODULE$);
            $this.sql().apply((Object)("DROP TABLE IF EXISTS " + $this.catalog() + ".ns.tbl"));
            $this.checkTables("ns", (Seq<String>)Nil$.MODULE$);
        }), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        $this.test("SPARK-33174: DROP TABLE should resolve to a temporary view first", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "t", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint) " + $this.defaultUsing()));
                $this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2");
                $this.sql().apply((Object)("USE " + $this.catalog() + ".ns"));
                try {
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SHOW TABLES FROM spark_catalog.default LIKE 't'")).select("tableName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"isTemporary"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"t", BoxesRunTime.boxToBoolean((boolean)true)})));
                    $this.sql().apply((Object)"DROP TABLE t");
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SHOW TABLES FROM spark_catalog.default LIKE 't'")).select("tableName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"isTemporary"})), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().empty()));
                }
                finally {
                    $this.sql().apply((Object)"USE spark_catalog");
                }
            });
            return BoxedUnit.UNIT;
        }), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        $this.test("SPARK-33305: DROP TABLE should also invalidate cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.catalog() + ".ns.tbl";
            String view = "view";
            $this.withNamespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.catalog() + ".ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE NAMESPACE " + $this.catalog() + ".ns"));
                $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view, "source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DropTableSuiteBase.class.getClassLoader());
                    public final class Org_apache_spark_sql_execution_command_DropTableSuiteBase$$typecreator1$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public Org_apache_spark_sql_execution_command_DropTableSuiteBase$$typecreator1$1(DropTableSuiteBase $outer) {
                        }
                    }
                    Dataset df = $this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_command_DropTableSuiteBase$$typecreator1$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                    df.createOrReplaceTempView("source");
                    $this.sql().apply((Object)("CREATE TABLE " + t + " " + $this.defaultUsing() + " AS SELECT id, data FROM source"));
                    $this.sql().apply((Object)("CACHE TABLE " + view + " AS SELECT id FROM " + t));
                    ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + t)), (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq($this.spark().table("source").collect()));
                    ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + view)), (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq($this.spark().table("source").select("id", (Seq)Nil$.MODULE$).collect()));
                    Dataset oldTable = $this.spark().table(view);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().sharedState().cacheManager().lookupCachedData(oldTable).isDefined(), "DropTableSuiteBase.this.spark.sharedState.cacheManager.lookupCachedData(oldTable).isDefined", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
                    $this.sql().apply((Object)("DROP TABLE " + t));
                    Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData(oldTable);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                });
            });
        }, new Position("DropTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }
}

