/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-2qa\u0001\u0003\u0011\u0002\u0007\u0005\u0011\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0004\u0006\u0001\t\u0007I\u0011\t\u0012\u00033\u0005cG/\u001a:UC\ndWMU3oC6,7+^5uK\n\u000b7/\u001a\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005A\u0011BA\u000b\t\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001815\tA!\u0003\u0002\u001a\t\t\u0019B\t\u0012'D_6l\u0017M\u001c3UKN$X\u000b^5mg\u00061A%\u001b8ji\u0012\"\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0005+:LG/F\u0001$!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003mC:<'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012aa\u0015;sS:<\u0007")
public interface AlterTableRenameSuiteBase
extends DDLCommandTestUtils {
    public void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$_setter_$command_$eq(String var1);

    @Override
    public String command();

    public static /* synthetic */ void $anonfun$$init$$2(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)("CREATE TABLE " + src + " (c0 INT) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + src + " SELECT 0"));
        $this.sql().apply((Object)("ALTER TABLE " + src + " RENAME TO ns.dst_tbl"));
        $this.checkTables("ns", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT c0 FROM " + dst))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$6(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)("CREATE TABLE " + src + " (c0 INT) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + src + " SELECT 0"));
        $this.sql().apply((Object)("ALTER TABLE " + src + " RENAME TO dst_tbl"));
        $this.checkTables("ns", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT c0 FROM " + dst))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    private StorageLevel getStorageLevel$1(String tableName) {
        Dataset table = this.spark().table(tableName);
        CachedData cachedData = (CachedData)this.spark().sharedState().cacheManager().lookupCachedData(table).get();
        return cachedData.cachedRepresentation().cacheBuilder().storageLevel();
    }

    public static /* synthetic */ void $anonfun$$init$$8(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)("CREATE TABLE " + src + " (c0 INT) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + src + " SELECT 0"));
        $this.sql().apply((Object)("CACHE TABLE " + src + " OPTIONS('storageLevel' 'MEMORY_ONLY')"));
        StorageLevel oldStorageLevel = $this.getStorageLevel$1(src);
        $this.sql().apply((Object)("ALTER TABLE " + src + " RENAME TO ns.dst_tbl"));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT c0 FROM " + dst))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$), QueryTest$.MODULE$.checkAnswer$default$3());
        StorageLevel newStorageLevel = $this.getStorageLevel$1(dst);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)oldStorageLevel);
        StorageLevel $org_scalatest_assert_macro_right = newStorageLevel;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public static /* synthetic */ void $anonfun$$init$$11(AlterTableRenameSuiteBase $this, String students$1, String teachers$1, Seq expected$1) {
        $this.sql().apply((Object)("ALTER TABLE " + students$1 + " RENAME TO ns.teachers"));
        $this.sql().apply((Object)("CREATE TABLE " + students$1 + " (age INT, name STRING) " + $this.defaultUsing()));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(students$1), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(students)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(teachers$1), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(teachers)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table(students$1).collect());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)$this.spark().table(teachers$1), (Seq<Row>)expected$1, QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$10(AlterTableRenameSuiteBase $this, String students) {
        $this.sql().apply((Object)("CREATE TABLE " + students + " (age INT, name STRING) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + students + " SELECT 19, 'Ana'"));
        $this.spark().catalog().cacheTable(students);
        .colon.colon expected = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), "Ana"})), (List)Nil$.MODULE$);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)$this.spark().table(students), (Seq<Row>)expected, QueryTest$.MODULE$.checkAnswer$default$3());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(students), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(students)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"bad test: table was not cached in the first place", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        String teachers = $this.catalog() + ".ns.teachers";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{teachers}), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> AlterTableRenameSuiteBase.$anonfun$$init$$11($this, students, teachers, (Seq)expected)));
    }

    public static /* synthetic */ void $anonfun$$init$$13(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)("CREATE TABLE " + src + " (c0 INT) " + $this.defaultUsing()));
        $this.sql().apply((Object)("INSERT INTO " + src + " SELECT 0"));
        $this.sql().apply((Object)("USE " + $this.catalog() + ".ns"));
        $this.sql().apply((Object)"ALTER TABLE src_tbl RENAME TO dst_tbl");
        $this.checkTables("ns", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT c0 FROM " + dst)), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void $anonfun$$init$$16(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)("CREATE TABLE " + src + " (i int, j int) " + $this.defaultUsing() + " partitioned by (j)"));
        $this.sql().apply((Object)("insert into table " + src + " partition(j=2) values (1)"));
        $this.sql().apply((Object)("ALTER TABLE " + src + " RENAME TO ns.dst_tbl"));
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(dst), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
    }

    public static /* synthetic */ void $anonfun$$init$$19(AlterTableRenameSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + "_Old (i int) " + $this.defaultUsing()));
        $this.sql().apply((Object)("ALTER TABLE " + t + "_Old RENAME TO CaseUpperCaseLower.CaseUpperCaseLower"));
        Dataset $org_scalatest_assert_macro_left = $this.spark().table(t);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
    }

    public static void $init$(AlterTableRenameSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$_setter_$command_$eq("ALTER TABLE .. RENAME");
        $this.test("rename a table in a database/namespace", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$2($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        $this.test("table to rename does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + $this.catalog() + ".dbx.does_not_exist RENAME TO dbx.tab2")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            ((SparkFunSuite)$this).checkErrorTableNotFound((SparkThrowable)e, "`" + $this.catalog() + "`.`dbx`.`does_not_exist`", ((SparkFunSuite)$this).ExpectedContext().apply($this.catalog() + ".dbx.does_not_exist", 12, 11 + ($this.catalog() + ".dbx.does_not_exist").length()));
        }, new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        $this.test("omit namespace in the destination table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$6($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.test("SPARK-33786: Cache's storage level should be respected when a table name is altered", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$8($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        $this.test("rename cached table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "students", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)students -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$10($this, students);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        $this.test("rename without explicitly specifying database", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            try {
                $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)dst -> {
                    AlterTableRenameSuiteBase.$anonfun$$init$$13($this, dst);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                $this.spark().sessionState().catalogManager().reset();
            }
            return boxedUnit;
        }, new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        $this.test("SPARK-37963: preserve partition info", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$16($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        $this.test("SPARK-38587: use formatted names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("CaseUpperCaseLower", "CaseUpperCaseLower", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$19($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }
}

