/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000513qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0004\t\u0001\t\u0007I\u0011I\u0013\t\u000b9\u0002a\u0011C\u0018\t\u000bi\u0002a\u0011C\u0018\t\u000bm\u0002A\u0011\u0003\u001f\u0003A\u0005cG/\u001a:UC\ndW\r\u0012:paB\u000b'\u000f^5uS>t7+^5uK\n\u000b7/\u001a\u0006\u0003\u0011%\tqaY8n[\u0006tGM\u0003\u0002\u000b\u0017\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005Y\u0011B\u0001\r\f\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001b75\tq!\u0003\u0002\u001d\u000f\t\u0019B\t\u0012'D_6l\u0017M\u001c3UKN$X\u000b^5mg\u00061A%\u001b8ji\u0012\"\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG/F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u0015;sS:<\u0017a\u00068pi\u001a+H\u000e\u001c)beRLG/[8o'B,7-\u0012:s+\u0005\u0001\u0004CA\u00199\u001d\t\u0011d\u0007\u0005\u00024C5\tAG\u0003\u00026'\u00051AH]8pizJ!aN\u0011\u0002\rA\u0013X\rZ3g\u0013\ti\u0013H\u0003\u00028C\u0005\u0011b.\u001e7m!\u0006\u0014H/\u001b;j_:4\u0016\r\\;f\u0003I\u0019\u0007.Z2l\tJ|\u0007\u000fU1si&$\u0018n\u001c8\u0015\t}it(\u0011\u0005\u0006}\u0015\u0001\r\u0001M\u0001\u0002i\")\u0001)\u0002a\u0001a\u0005A\u0011NZ#ySN$8\u000fC\u0003C\u000b\u0001\u00071)A\u0003ta\u0016\u001c7\u000fE\u0002!\t\u001aK!!R\u0011\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u00032\u000fBJ\u0015B\u0001%:\u0005\ri\u0015\r\u001d\t\u0003A)K!aS\u0011\u0003\u0007\u0005s\u0017\u0010")
public interface AlterTableDropPartitionSuiteBase
extends DDLCommandTestUtils {
    public void org$apache$spark$sql$execution$command$AlterTableDropPartitionSuiteBase$_setter_$command_$eq(String var1);

    @Override
    public String command();

    public String notFullPartitionSpecErr();

    public String nullPartitionValue();

    public static /* synthetic */ void checkDropPartition$(AlterTableDropPartitionSuiteBase $this, String t, String ifExists, Seq specs) {
        $this.checkDropPartition(t, ifExists, (Seq<Map<String, Object>>)specs);
    }

    default public void checkDropPartition(String t, String ifExists, Seq<Map<String, Object>> specs) {
        this.checkPartitions(t, (Seq<Map<String, String>>)((Seq)specs.map((Function1 & Serializable)x$1 -> x$1.view().mapValues((Function1 & Serializable)x$2 -> x$2.toString()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        String specStr = ((IterableOnceOps)specs.map((Function1 & Serializable)spec -> this.partSpecToString((Map<String, Object>)spec))).mkString(", ");
        this.sql().apply((Object)("ALTER TABLE " + t + " DROP " + ifExists + " " + specStr));
        this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$3(AlterTableDropPartitionSuiteBase $this, String t$1, String ifExists) {
        $this.sql().apply((Object)("ALTER TABLE " + t$1 + " ADD PARTITION (id=1) LOCATION 'loc'"));
        $this.checkDropPartition(t$1, ifExists, (Seq<Map<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))}));
    }

    public static /* synthetic */ void $anonfun$$init$$2(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string) " + $this.defaultUsing() + " PARTITIONED BY (id)"));
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"IF EXISTS", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ifExists -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$3($this, t, ifExists);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$$init$$6(AlterTableDropPartitionSuiteBase $this, String t$2, String ifExists) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |ALTER TABLE " + t$2 + " ADD\n          |PARTITION (id=1) LOCATION 'loc'\n          |PARTITION (id=2) LOCATION 'loc1'")));
        $this.checkDropPartition(t$2, ifExists, (Seq<Map<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))}))}));
    }

    public static /* synthetic */ void $anonfun$$init$$5(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string) " + $this.defaultUsing() + " PARTITIONED BY (id)"));
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"IF EXISTS", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ifExists -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$6($this, t, ifExists);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$$init$$9(AlterTableDropPartitionSuiteBase $this, String t$3, String ifExists) {
        $this.sql().apply((Object)("ALTER TABLE " + t$3 + " ADD PARTITION (a = 2, b = 'abc')"));
        $this.checkDropPartition(t$3, ifExists, (Seq<Map<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"abc")}))}));
    }

    public static /* synthetic */ void $anonfun$$init$$8(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, a int, b string) " + $this.defaultUsing() + " PARTITIONED BY (a, b)"));
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"IF EXISTS", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ifExists -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$9($this, t, ifExists);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$$init$$11(AlterTableDropPartitionSuiteBase $this, String t) {
        String parsed = ((IterableOnceOps)CatalystSqlParser$.MODULE$.parseMultipartIdentifier(t).map((Function1 & Serializable)part -> package$.MODULE$.quoteIdentifier(part))).mkString(".");
        AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (a='4', b='9')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        ((SparkFunSuite)$this).checkErrorTableNotFound((SparkThrowable)e, parsed, ((SparkFunSuite)$this).ExpectedContext().apply(t, 12, 11 + t.length()));
    }

    public static /* synthetic */ void $anonfun$$init$$19(AlterTableDropPartitionSuiteBase $this, String t$5, String ifExists) {
        $this.sql().apply((Object)("ALTER TABLE " + t$5 + " ADD PARTITION (ID=1) LOCATION 'loc1'"));
        $this.checkDropPartition(t$5, ifExists, (Seq<Map<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))}));
    }

    public static /* synthetic */ void $anonfun$$init$$15(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string) " + $this.defaultUsing() + " PARTITIONED BY (id)"));
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String errMsg;
            String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (ID=1)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105))).getMessage();
            String $org_scalatest_assert_macro_right = "ID is not a valid partition column";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"", (List)new .colon.colon((Object)"IF EXISTS", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ifExists -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$19($this, t, ifExists);
            return BoxedUnit.UNIT;
        }));
    }

    public static /* synthetic */ void $anonfun$$init$$21(AlterTableDropPartitionSuiteBase $this, String t) {
        String errMsg;
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE " + t + " (id bigint, part0 int, part1 string)\n        |" + $this.defaultUsing() + "\n        |PARTITIONED BY (part0, part1)")));
        String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (part0 = 1)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126))).getMessage();
        String $org_scalatest_assert_macro_right = "Partition spec is invalid. The spec (part0) must match the partition spec (part0, part1)";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
    }

    public static /* synthetic */ void $anonfun$$init$$24(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string) " + $this.defaultUsing() + " PARTITIONED BY (id)"));
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (id=1) LOCATION 'loc'"));
        NoSuchPartitionsException e = (NoSuchPartitionsException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (id=1), PARTITION (id=2)")), ClassTag$.MODULE$.apply(NoSuchPartitionsException.class), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        String string = $this.commandVersion();
        String string2 = DDLCommandTestUtils$.MODULE$.V1_COMMAND_VERSION();
        String expectedTableName = !(string != null ? !string.equals(string2) : string2 != null) ? "`ns`.`tbl`" : "`test_catalog`.`ns`.`tbl`";
        NoSuchPartitionsException x$1 = e;
        String x$2 = "PARTITIONS_NOT_FOUND";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"PARTITION (`id` = 2)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)expectedTableName)}));
        Option x$4 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$5 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$1, "PARTITIONS_NOT_FOUND", x$4, x$3, x$5, x$6);
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"1")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP IF EXISTS PARTITION (id=1), PARTITION (id=2)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$27(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, part int) " + $this.defaultUsing() + " PARTITIONED BY (part)"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=0) SELECT 0"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=1) SELECT 1"));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT * FROM " + t))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (part=0)"));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT * FROM " + t))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$29(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, part int) " + $this.defaultUsing() + " PARTITIONED BY (part)"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=0) SELECT 0"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=1) SELECT 1"));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(t), "AlterTableDropPartitionSuiteBase.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        $this.sql().apply((Object)("CACHE TABLE " + t));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(t), "AlterTableDropPartitionSuiteBase.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT * FROM " + t))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (part=0)"));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(t), "AlterTableDropPartitionSuiteBase.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("SELECT * FROM " + t))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$31(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (col1 INT, p1 STRING) " + $this.defaultUsing() + " PARTITIONED BY (p1)"));
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (p1 = null)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p1"), (Object)$this.nullPartitionValue())}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (p1 = null)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    private void insertAndDropNullPart$1(String t, String insertCmd) {
        this.sql().apply((Object)("CREATE TABLE " + t + " (col1 INT, p1 STRING) " + this.defaultUsing() + " PARTITIONED BY (p1)"));
        this.sql().apply((Object)insertCmd);
        this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p1"), (Object)this.nullPartitionValue())}))}));
        this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (p1 = null)"));
        this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$37(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, part int) " + $this.defaultUsing() + " PARTITIONED BY (part)"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=0) SELECT 0"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=1) SELECT 1"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=2) SELECT 2"));
        $this.sql().apply((Object)("INSERT INTO " + t + " PARTITION (part=3) SELECT 3"));
        $this.cacheRelation(t);
        $this.checkCachedRelation(t, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        $this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v0"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE VIEW v0 AS SELECT * FROM " + t));
            $this.cacheRelation("v0");
            $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (part=1)"));
            $this.checkCachedRelation("v0", (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))));
        });
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TEMP VIEW v1 AS SELECT * FROM " + t));
            $this.cacheRelation("v1");
            $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (part=2)"));
            $this.checkCachedRelation("v1", (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)));
        });
        String v2 = $this.spark().sharedState().globalTempViewManager().database() + ".v2";
        $this.withGlobalTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE GLOBAL TEMP VIEW v2 AS SELECT * FROM " + t));
            $this.cacheRelation(v2);
            $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (part=3)"));
            $this.checkCachedRelation(v2, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
        });
    }

    public static /* synthetic */ void $anonfun$$init$$42(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + "(name STRING, part DATE) USING PARQUET PARTITIONED BY (part)"));
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION(part = date'2020-01-01')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part"), (Object)"2020-01-01")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (part = date'2020-01-01')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$45(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + "(name STRING, age INT) using orc PARTITIONED BY (dt STRING)"));
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION(dt = 08)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dt"), (Object)"08")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (dt = 08)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION(dt = '08')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dt"), (Object)"08")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (dt = '08')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$47(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + "(name STRING, age INT) using orc PARTITIONED BY (dt STRING)"));
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION(dt = 08)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dt"), (Object)"8")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (dt = 08)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION(dt = 08)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dt"), (Object)"8")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (dt = 8)"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$50(AlterTableDropPartitionSuiteBase $this, String t) {
        $this.sql().apply((Object)("CREATE TABLE " + t + "(name STRING, age INT) USING PARQUET PARTITIONED BY (region STRING)"));
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (region='=reg1') LOCATION 'loc1'"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"region"), (Object)"=reg1")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " PARTITION (region='=reg1') RENAME TO PARTITION (region='=%reg1')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"region"), (Object)"=%reg1")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (region='=%reg1')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
        $this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (region='reg?2') LOCATION 'loc2'"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"region"), (Object)"reg?2")}))}));
        $this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (region='reg?2')"));
        $this.checkPartitions(t, (Seq<Map<String, String>>)Nil$.MODULE$);
    }

    public static void $init$(AlterTableDropPartitionSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$AlterTableDropPartitionSuiteBase$_setter_$command_$eq("ALTER TABLE .. DROP PARTITION");
        $this.test("single partition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$2($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        $this.test("multiple partitions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$5($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        $this.test("multi-part partition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$8($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        $this.test("table to alter does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "does_not_exist", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$11($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        $this.test("case sensitivity in resolving partition specs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$15($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        $this.test("SPARK-33676: not fully specified partition spec", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$21($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        $this.test("partition not exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$24($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        $this.test("SPARK-33990: do not return data from dropped partition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$27($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        $this.test("SPARK-33950, SPARK-33987: refresh cache after partition dropping", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$29($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        $this.test("SPARK-33591: null as a partition value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$31($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        $this.test("SPARK-33591, SPARK-34203: insert and drop partitions with null values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
                $this.insertAndDropNullPart$1(t, "INSERT INTO TABLE " + t + " PARTITION (p1 = null) SELECT 0");
                return BoxedUnit.UNIT;
            });
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
                $this.insertAndDropNullPart$1(t, "INSERT OVERWRITE TABLE " + t + " VALUES (0, null)");
                return BoxedUnit.UNIT;
            }));
        }, new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        $this.test("SPARK-34161, SPARK-34138, SPARK-34099: keep dependents cached after table altering", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$37($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        $this.test("SPARK-33474: Support typed literals as partition spec values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$42($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        $this.test("SPARK-41982: drop partition when keepPartitionSpecAsString set `true`", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_KEEP_PARTITION_SPEC_AS_STRING_LITERAL().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
                AlterTableDropPartitionSuiteBase.$anonfun$$init$$45($this, t);
                return BoxedUnit.UNIT;
            }));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_KEEP_PARTITION_SPEC_AS_STRING_LITERAL().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tb2", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
                AlterTableDropPartitionSuiteBase.$anonfun$$init$$47($this, t);
                return BoxedUnit.UNIT;
            }));
        }, new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        $this.test("SPARK-42480: drop partition when dropPartitionByName enabled", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_DROP_PARTITION_BY_NAME().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)t -> {
            AlterTableDropPartitionSuiteBase.$anonfun$$init$$50($this, t);
            return BoxedUnit.UNIT;
        })), new Position("AlterTableDropPartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
    }
}

