/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarDataTypeUtils$;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005q3AAB\u0004\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u0014\u0001A\u0003%\u0011\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0004O\u0001E\u0005I\u0011A(\u0003/\u0011K7\r^5p]\u0006\u0014\u00180\u00128d_\u0012LgnZ*vSR,'B\u0001\u0005\n\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005)Y\u0011\u0001C2pYVlg.\u0019:\u000b\u00051i\u0011!C3yK\u000e,H/[8o\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\tq\"\u0003\u0002\u001b\u001f\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0004\u0002\u00139,H\u000e\u001c,bYV,W#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u0007%sG/\u0001\u0006ok2dg+\u00197vK\u0002\na\u0003^3ti\u0012K7\r^5p]\u0006\u0014\u00180\u00128d_\u0012LgnZ\u000b\u0003Um\"Ba\u000b\u00185\u0013B\u0011!\u0005L\u0005\u0003[\r\u0012A!\u00168ji\")q\u0006\u0002a\u0001a\u0005Y1m\u001c7v[:\u001cF/\u0019;t!\t\t$'D\u0001\n\u0013\t\u0019\u0014BA\u0006D_2,XN\\*uCR\u001c\b\"B\u001b\u0005\u0001\u00041\u0014AC2pYVlg\u000eV=qKB\u0019\u0011gN\u001d\n\u0005aJ!\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f!\tQ4\b\u0004\u0001\u0005\u000bq\"!\u0019A\u001f\u0003\u0003Q\u000b\"AP!\u0011\u0005\tz\u0014B\u0001!$\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u000bQL\b/Z:\u000b\u0005\u0019k\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005!\u001b%\u0001\u0005)isNL7-\u00197ECR\fG+\u001f9f\u0011\u001dQE\u0001%AA\u0002-\u000ba\u0002^3ti\u0012+7m\\7qe\u0016\u001c8\u000f\u0005\u0002#\u0019&\u0011Qj\t\u0002\b\u0005>|G.Z1o\u0003\u0001\"Xm\u001d;ES\u000e$\u0018n\u001c8bef,enY8eS:<G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005A[V#A)+\u0005-\u00136&A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016!C;oG\",7m[3e\u0015\tA6%\u0001\u0006b]:|G/\u0019;j_:L!AW+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003=\u000b\t\u0007Q\b")
public class DictionaryEncodingSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends PhysicalDataType> void testDictionaryEncoding(ColumnStats columnStats, NativeColumnType<T> columnType, boolean testDecompress) {
        String typeName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName()), "$");
        this.test(DictionaryEncoding$.MODULE$ + " with " + typeName + ": empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton$1(0, (Seq)package$.MODULE$.Seq().empty(), columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test(DictionaryEncoding$.MODULE$ + " with " + typeName + ": simple case", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton$1(2, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1})), columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test(DictionaryEncoding$.MODULE$ + " with " + typeName + ": dictionary overflow", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 1, (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), (int)DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()), columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test(DictionaryEncoding$.MODULE$ + " with " + typeName + ": empty for decompress()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress$1(0, (Seq)package$.MODULE$.Seq().empty(), testDecompress, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test(DictionaryEncoding$.MODULE$ + " with " + typeName + ": simple case for decompress()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress$1(2, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, this.nullValue(), 0, this.nullValue()})), testDecompress, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test(DictionaryEncoding$.MODULE$ + " with " + typeName + ": dictionary overflow for decompress()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 2, (Seq)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.nullValue()})).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() - 1))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.nullValue()}))), testDecompress, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public <T extends PhysicalDataType> boolean testDictionaryEncoding$default$3() {
        return true;
    }

    private static final Map buildDictionary$1(ByteBuffer buffer, NativeColumnType columnType$1) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffer.getInt()).map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(columnType$1.extract(buffer)), (Object)BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToInt((Object)x$1))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Seq stableDistinct$1(Seq seq) {
        if (seq.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        int n = BoxesRunTime.unboxToInt((Object)seq.head());
        return (Seq)((SeqOps)((IterableOps)seq.tail()).filterNot((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 == BoxesRunTime.unboxToInt((Object)seq.head()))).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static final /* synthetic */ Assertion $anonfun$testDictionaryEncoding$9(DictionaryEncodingSuite $this, DictionaryEncoding.Decoder decoder$1, Seq values$1, GenericInternalRow mutableRow$1, NativeColumnType columnType$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder$1.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        Object object = values$1.apply(i);
        decoder$1.next((InternalRow)mutableRow$1, 0);
        return $this.assertResult(object, "Wrong decoded value", columnType$1.getField((InternalRow)mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    private final void skeleton$1(int uniqueValueCount, Seq inputSeq, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq values = (Seq)tuple2._1();
        Seq rows = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
        Seq values2 = (Seq)tuple22._1();
        Seq rows2 = (Seq)tuple22._2();
        Seq dictValues = DictionaryEncodingSuite.stableDistinct$1(inputSeq);
        inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> builder.appendFrom((InternalRow)rows2.apply(i), 0));
        if (dictValues.length() > DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
            this.withClue("Dictionary overflowed, compression should fail", (Function0 & Serializable)() -> (Throwable)this.intercept((Function0 & Serializable)() -> builder.build(), ClassTag$.MODULE$.apply(Throwable.class), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65)));
            return;
        }
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int dictionarySize = 4 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)rows2.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)columnType$1.actualSize((InternalRow)x$4, 0)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int compressedSize = 4 + dictionarySize + 2 * inputSeq.length();
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        Map dictionary = DictionaryEncodingSuite.buildDictionary$1(buffer, columnType$1).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        dictValues.foreach((Function1 & Serializable)i -> this.assertResult(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "Wrong dictionary entry", dictionary.apply(values2.apply(BoxesRunTime.unboxToInt((Object)i))), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
        inputSeq.foreach((Function1 & Serializable)i -> this.assertResult(BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToInt((Object)i))), "Wrong column element value", BoxesRunTime.boxToShort((short)buffer.getShort()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92)));
        buffer.rewind().position(headerSize + 4);
        DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (inputSeq.nonEmpty()) {
            inputSeq.foreach((Function1 & Serializable)i -> DictionaryEncodingSuite.$anonfun$testDictionaryEncoding$9(this, decoder, values2, mutableRow, columnType$1, BoxesRunTime.unboxToInt((Object)i)));
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    private final void skeletonForDecompress$1(int uniqueValueCount, Seq inputSeq, boolean testDecompress$1, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        if (!testDecompress$1) {
            return;
        }
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq values = (Seq)tuple2._1();
        Seq rows = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
        Seq values2 = (Seq)tuple22._1();
        Seq rows2 = (Seq)tuple22._2();
        Seq dictValues = DictionaryEncodingSuite.stableDistinct$1(inputSeq);
        GenericInternalRow nullRow = new GenericInternalRow(1);
        nullRow.setNullAt(0);
        inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i == this.nullValue()) {
                builder.appendFrom((InternalRow)nullRow, 0);
                return;
            }
            builder.appendFrom((InternalRow)rows2.apply(i), 0);
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
        OnHeapColumnVector columnVector = new OnHeapColumnVector(inputSeq.length(), ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType$1.dataType()));
        decoder.decompress((WritableColumnVector)columnVector, inputSeq.length());
        if (inputSeq.nonEmpty()) {
            ((IterableOnceOps)inputSeq.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int i = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    if (true) {
                        int n = i;
                        if (true) {
                            int n2 = index;
                            if (n == this.nullValue()) {
                                return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), "Wrong null " + n2 + "-th position", BoxesRunTime.boxToBoolean((boolean)columnVector.isNullAt(n2)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
                            }
                            NativeColumnType nativeColumnType = columnType$1;
                            if (INT$.MODULE$.equals(nativeColumnType)) {
                                return this.assertResult(values2.apply(n), "Wrong " + n2 + "-th decoded int value", BoxesRunTime.boxToInteger((int)columnVector.getInt(n2)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
                            }
                            if (LONG$.MODULE$.equals(nativeColumnType)) {
                                return this.assertResult(values2.apply(n), "Wrong " + n2 + "-th decoded long value", BoxesRunTime.boxToLong((long)columnVector.getLong(n2)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                            }
                            throw this.fail("Unsupported type", new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    public DictionaryEncodingSuite() {
        this.nullValue = -1;
        this.testDictionaryEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, this.testDictionaryEncoding$default$3());
        this.testDictionaryEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, this.testDictionaryEncoding$default$3());
        this.testDictionaryEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$, false);
    }
}

