/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.ColumnarToRowExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class InMemoryColumnarBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark,
AdaptiveSparkPlanHelper {
    public static final InMemoryColumnarBenchmark$ MODULE$ = new InMemoryColumnarBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        AdaptiveSparkPlanHelper.$init$((AdaptiveSparkPlanHelper)MODULE$);
    }

    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        InMemoryColumnarBenchmark$ inMemoryColumnarBenchmark$ = this;
        synchronized (inMemoryColumnarBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    public void intCache(long rowsNum, int numIters) {
        Dataset data = this.spark().range(0L, rowsNum, 1L, 1).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i"})).cache();
        Seq inMemoryScan = this.collect(data.queryExecution().executedPlan(), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InMemoryTableScanExec) {
                    InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)A1;
                    return (B1)inMemoryTableScanExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                return sparkPlan2 instanceof InMemoryTableScanExec;
            }
        });
        ColumnarToRowExec columnarScan = new ColumnarToRowExec((SparkPlan)inMemoryScan.apply(0));
        InMemoryTableScanExec rowScan = (InMemoryTableScanExec)inMemoryScan.apply(0);
        Predef$.MODULE$.assert(inMemoryScan.size() == 1);
        String x$12 = "Int In-Memory scan";
        long x$22 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Int In-Memory scan", x$22, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("columnar deserialization + columnar-to-row", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> columnarScan.executeCollect());
        benchmark.addCase("row-based deserialization", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> rowScan.executeCollect());
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        long rowsNum = mainArgs.length > 0 ? StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(mainArgs[0])) : 1000000L;
        this.runBenchmark("Int In-memory with " + rowsNum + " rows", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.intCache(rowsNum, 3));
    }

    private InMemoryColumnarBenchmark$() {
    }
}

