/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.benchmark.WideSchemaBenchmark$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class WideSchemaBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final WideSchemaBenchmark$ MODULE$ = new WideSchemaBenchmark$();
    private static final int scaleFactor;
    private static final Seq<Object> widthsToTest;
    private static final Seq<Object> depthsToTest;
    private static List<File> tmpFiles;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        scaleFactor = 100000;
        widthsToTest = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 100, 2500}));
        depthsToTest = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 100, 250}));
        Predef$.MODULE$.assert(MODULE$.scaleFactor() > BoxesRunTime.unboxToInt((Object)MODULE$.widthsToTest().max((Ordering)Ordering.Int$.MODULE$)));
        tmpFiles = Nil$.MODULE$;
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        WideSchemaBenchmark$ wideSchemaBenchmark$ = this;
        synchronized (wideSchemaBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private int scaleFactor() {
        return scaleFactor;
    }

    private Seq<Object> widthsToTest() {
        return widthsToTest;
    }

    private Seq<Object> depthsToTest() {
        return depthsToTest;
    }

    private List<File> tmpFiles() {
        return tmpFiles;
    }

    private void tmpFiles_$eq(List<File> x$1) {
        tmpFiles = x$1;
    }

    private void deleteTmpFiles() {
        this.tmpFiles().foreach((Function1 & Serializable)file -> {
            Utils$.MODULE$.deleteRecursively(file);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> saveAsParquet(Dataset<Row> df) {
        File tmpFile = File.createTempFile("WideSchemaBenchmark", "tmp");
        this.tmpFiles_$eq((List<File>)this.tmpFiles().$colon$colon((Object)tmpFile));
        tmpFile.delete();
        df.write().parquet(tmpFile.getAbsolutePath());
        Predef$.MODULE$.assert(tmpFile.isDirectory());
        return this.spark().read().parquet(tmpFile.getAbsolutePath());
    }

    private void addCases(Benchmark benchmark, Dataset<Row> df, String desc, String selector) {
        benchmark.addCase(desc + " (read in-mem)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum(" + selector + ")"}))).noop());
        benchmark.addCase(desc + " (exec in-mem)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"*", "hash(" + selector + ") as f"})).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum(" + selector + ")", "sum(f)"}))).noop());
        Dataset<Row> parquet = this.saveAsParquet(df);
        benchmark.addCase(desc + " (read parquet)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.DatasetToBenchmark(parquet.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum(" + selector + ") as f"}))).noop());
        benchmark.addCase(desc + " (write parquet)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.saveAsParquet((Dataset<Row>)df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum(" + selector + ") as f"}))));
    }

    public void parsingLargeSelectExpressions() {
        String x$1 = "parsing large select";
        long x$2 = 1L;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("parsing large select", 1L, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> WideSchemaBenchmark$.$anonfun$parsingLargeSelectExpressions$2(BoxesRunTime.unboxToInt((Object)i)));
            benchmark.addCase(width + " select expressions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.spark().range(1L).toDF().selectExpr((Seq)selectExpr));
        });
        benchmark.run();
    }

    public void optimizeLargeSelectExpressions() {
        String x$1 = "optimize large select";
        long x$2 = 1L;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("optimize large select", 1L, x$4, x$5, x$6, x$7, x$3);
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 1000, 10000})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            IndexedSeq columns = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> WideSchemaBenchmark$.$anonfun$optimizeLargeSelectExpressions$2(BoxesRunTime.unboxToInt((Object)i)));
            Dataset df = MODULE$.spark().range(1L).selectExpr((Seq)columns).cache();
            df.count();
            benchmark.addCase(width + " columns", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> df.withColumn("id", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).withColumn("name", functions$.MODULE$.lit((Object)"name")).queryExecution().optimizedPlan());
        });
        benchmark.run();
    }

    public void manyColumnFieldReadAndWrite() {
        String x$1 = "many column field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("many column field r/w", x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> WideSchemaBenchmark$.$anonfun$manyColumnFieldReadAndWrite$2(BoxesRunTime.unboxToInt((Object)i)));
            Dataset df = MODULE$.spark().range((long)numRows).toDF().selectExpr((Seq)selectExpr).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, width + " cols x " + numRows + " rows", "a_1");
        });
        benchmark.run();
    }

    public void wideShallowlyNestedStructFieldReadAndWrite() {
        String x$1 = "wide shallowly nested struct field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("wide shallowly nested struct field r/w", x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            ObjectRef datum = ObjectRef.create((Object)"{");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (i == 1) {
                    datum$1.elem = (String)datum$1.elem + "\"value_" + i + "\": 1";
                    return;
                }
                datum$1.elem = (String)datum$1.elem + ", \"value_" + i + "\": 1";
            });
            datum.elem = (String)datum.elem + "}";
            datum.elem = "{\"a\": {\"b\": {\"c\": " + (String)datum.elem + ", \"d\": " + (String)datum.elem + "}, \"e\": " + (String)datum.elem + "}}";
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable)x$1 -> (String)datum$1.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, width + " wide x " + numRows + " rows", "a.b.c.value_1");
        });
        benchmark.run();
    }

    public void deeplyNestedStructFieldReadAndWrite() {
        String x$1 = "deeply nested struct field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("deeply nested struct field r/w", x$2, x$4, x$5, x$6, x$7, x$3);
        this.depthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable)depth -> {
            int numRows = MODULE$.scaleFactor() / depth;
            ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
            ObjectRef selector = ObjectRef.create((Object)"value");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), depth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                datum$2.elem = "{\"value\": " + (String)datum$2.elem + "}";
                selector$2.elem = (String)selector$2.elem + ".value";
            });
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable)x$2 -> (String)datum$2.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, depth + " deep x " + numRows + " rows", (String)selector.elem);
        });
        benchmark.run();
    }

    public void bushyStructFieldReadAndWrite() {
        String x$1 = "bushy struct field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("bushy struct field r/w", x$2, x$4, x$5, x$6, x$7, x$3);
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 100, 1000})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            int numNodes = 1;
            ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
            Object selector = "value";
            int depth = 1;
            while (numNodes < width) {
                numNodes *= 2;
                datum.elem = "{\"left_" + depth + "\": " + (String)datum.elem + ", \"right_" + depth + "\": " + (String)datum.elem + "}";
                selector = "left_" + depth + "." + (String)selector;
                ++depth;
            }
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable)x$3 -> (String)datum$3.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, numNodes + " x " + depth + " deep x " + numRows + " rows", (String)selector);
        });
        benchmark.run();
    }

    public void wideArrayFieldReadAndWrite() {
        String x$1 = "wide array field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("wide array field r/w", x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            ObjectRef datum = ObjectRef.create((Object)"{\"value\": [");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (i == 1) {
                    datum$4.elem = (String)datum$4.elem + "1";
                    return;
                }
                datum$4.elem = (String)datum$4.elem + ", 1";
            });
            datum.elem = (String)datum.elem + "]}";
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable)x$4 -> (String)datum$4.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, width + " wide x " + numRows + " rows", "value[0]");
        });
        benchmark.run();
    }

    public void wideMapFieldReadAndWrite() {
        String x$1 = "wide map field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("wide map field r/w", x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            Tuple1 datum = new Tuple1((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("value_" + BoxesRunTime.unboxToInt((Object)i))), (Object)BoxesRunTime.boxToInteger((int)1))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_execution_benchmark_WideSchemaBenchmark$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_benchmark_WideSchemaBenchmark$$typecreator5$1() {
                }
            }
            Dataset df = MODULE$.spark().range((long)numRows).map((Function1 & Serializable)x$5 -> datum, MODULE$.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_WideSchemaBenchmark$$typecreator5$1()))).toDF().cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, width + " wide x " + numRows + " rows", "_1[\"value_1\"]");
        });
        benchmark.run();
    }

    public void runBenchmarkWithDeleteTmpFiles(String benchmarkName, Function0<Object> func) {
        this.runBenchmark(benchmarkName, func);
        this.deleteTmpFiles();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmarkWithDeleteTmpFiles("parsing large select expressions", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.parsingLargeSelectExpressions());
        this.runBenchmarkWithDeleteTmpFiles("optimize large select expressions", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.optimizeLargeSelectExpressions());
        this.runBenchmarkWithDeleteTmpFiles("many column field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.manyColumnFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("wide shallowly nested struct field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.wideShallowlyNestedStructFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("deeply nested struct field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.deeplyNestedStructFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("bushy struct field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.bushyStructFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("wide array field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.wideArrayFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("wide map field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.wideMapFieldReadAndWrite());
    }

    public static final /* synthetic */ String $anonfun$parsingLargeSelectExpressions$2(int i) {
        return "id as a_" + i;
    }

    public static final /* synthetic */ String $anonfun$optimizeLargeSelectExpressions$2(int i) {
        return "id as c_" + i;
    }

    public static final /* synthetic */ String $anonfun$manyColumnFieldReadAndWrite$2(int i) {
        return "id as a_" + i;
    }

    private WideSchemaBenchmark$() {
    }
}

