/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ParquetNestedPredicatePushDownBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final ParquetNestedPredicatePushDownBenchmark$ MODULE$ = new ParquetNestedPredicatePushDownBenchmark$();
    private static final int N;
    private static final int NUMBER_OF_ITER;
    private static final Dataset<Row> df;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        N = 0x6400000;
        NUMBER_OF_ITER = 10;
        df = MODULE$.spark().range(1L, (long)MODULE$.N(), 1L, 4).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "STRUCT(id x, STRUCT(CAST(id AS STRING) z) y) nested"})).sort("id", (Seq)Nil$.MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        ParquetNestedPredicatePushDownBenchmark$ parquetNestedPredicatePushDownBenchmark$ = this;
        synchronized (parquetNestedPredicatePushDownBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private int N() {
        return N;
    }

    private int NUMBER_OF_ITER() {
        return NUMBER_OF_ITER;
    }

    private Dataset<Row> df() {
        return df;
    }

    private void addCase(Benchmark benchmark, String inputPath, String enableNestedPD, String name, Function1<Dataset<Row>, Dataset<Row>> withFilter) {
        Dataset loadDF = this.spark().read().parquet(inputPath);
        benchmark.addCase(name, benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST().key(), (Object)enableNestedPD)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)withFilter.apply((Object)loadDF)).noop()));
    }

    private void createAndRunBenchmark(String name, Function1<Dataset<Row>, Dataset<Row>> withFilter) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)tempDir -> {
            ParquetNestedPredicatePushDownBenchmark$.$anonfun$createAndRunBenchmark$1(name, withFilter, tempDir);
            return BoxedUnit.UNIT;
        });
    }

    public void runLoadNoRowGroupWhenPredicatePushedDown() {
        this.createAndRunBenchmark("Can skip all row groups", (Function1<Dataset<Row>, Dataset<Row>>)(Function1 & Serializable)x$2 -> x$2.filter("nested.x < 0"));
    }

    public void runLoadSomeRowGroupWhenPredicatePushedDown() {
        this.createAndRunBenchmark("Can skip some row groups", (Function1<Dataset<Row>, Dataset<Row>>)(Function1 & Serializable)x$3 -> x$3.filter("nested.x = 100"));
    }

    public void runLoadAllRowGroupsWhenPredicatePushedDown() {
        this.createAndRunBenchmark("Can skip no row groups", (Function1<Dataset<Row>, Dataset<Row>>)(Function1 & Serializable)x$4 -> x$4.filter("nested.x >= 0 and nested.x <= " + MODULE$.N()));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runLoadNoRowGroupWhenPredicatePushedDown();
        this.runLoadSomeRowGroupWhenPredicatePushedDown();
        this.runLoadAllRowGroupsWhenPredicatePushedDown();
    }

    public static final /* synthetic */ void $anonfun$createAndRunBenchmark$1(String name$1, Function1 withFilter$2, File tempDir) {
        String outputPath = tempDir.getCanonicalPath();
        MODULE$.df().write().mode(SaveMode.Overwrite).parquet(outputPath);
        String x$1 = name$1;
        long x$2 = MODULE$.N();
        int x$3 = MODULE$.NUMBER_OF_ITER();
        Option x$4 = MODULE$.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$3, x$5, x$6, x$7, x$4);
        MODULE$.addCase(benchmark, outputPath, "", "Without nested predicate Pushdown", (Function1<Dataset<Row>, Dataset<Row>>)withFilter$2);
        MODULE$.addCase(benchmark, outputPath, "parquet", "With nested predicate Pushdown", (Function1<Dataset<Row>, Dataset<Row>>)withFilter$2);
        benchmark.run();
    }

    private ParquetNestedPredicatePushDownBenchmark$() {
    }
}

