/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.MiscBenchmark$;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MiscBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final MiscBenchmark$ MODULE$ = new MiscBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        MiscBenchmark$ miscBenchmark$ = this;
        synchronized (miscBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    public void filterAndAggregateWithoutGroup(long numRows) {
        this.runBenchmark("filter & aggregate without group", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.codegenBenchmark("range/filter/sum", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range(numRows).filter("(id & 1) = 1").groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$)).noop()));
    }

    public void limitAndAggregateWithoutGroup(long numRows) {
        this.runBenchmark("range/limit/sum", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.codegenBenchmark("range/limit/sum", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range(numRows).limit(1000000).groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$)).noop()));
    }

    public void sample(int numRows) {
        this.runBenchmark("sample", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.codegenBenchmark("sample with replacement", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)numRows).sample(true, 0.01).groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$)).noop());
            MODULE$.codegenBenchmark("sample without replacement", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)numRows).sample(false, 0.01).groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$)).noop());
        });
    }

    public void collect(int numRows) {
        this.runBenchmark("collect", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "collect";
            long x$2 = numRows;
            Option x$3 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark("collect", x$2, x$4, x$5, x$6, x$7, x$3);
            benchmark.addCase("collect 1 million", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.spark().range((long)numRows).collect());
            benchmark.addCase("collect 2 millions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.spark().range((long)(numRows * 2)).collect());
            benchmark.addCase("collect 4 millions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.spark().range((long)(numRows * 4)).collect());
            benchmark.run();
        });
    }

    public void collectLimit(int numRows) {
        this.runBenchmark("collect limit", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "collect limit";
            long x$2 = numRows;
            Option x$3 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark("collect limit", x$2, x$4, x$5, x$6, x$7, x$3);
            benchmark.addCase("collect limit 1 million", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.spark().range((long)(numRows * 4)).limit(numRows).collect());
            benchmark.addCase("collect limit 2 millions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)iter -> MODULE$.spark().range((long)(numRows * 4)).limit(numRows * 2).collect());
            benchmark.run();
        });
    }

    public void explode(int numRows) {
        this.runBenchmark("generate explode", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.codegenBenchmark("generate explode array", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Dataset df = MODULE$.spark().range((long)numRows).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as key", "array(rand(), rand(), rand(), rand(), rand()) as values"}));
                MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "explode(values) value"}))).noop();
            });
            MODULE$.codegenBenchmark("generate explode map", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Dataset df = MODULE$.spark().range((long)numRows).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as key", "map('a', rand(), 'b', rand(), 'c', rand(), 'd', rand(), 'e', rand()) pairs"}));
                MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "explode(pairs) as (k, v)"}))).noop();
            });
            MODULE$.codegenBenchmark("generate posexplode array", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Dataset df = MODULE$.spark().range((long)numRows).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as key", "array(rand(), rand(), rand(), rand(), rand()) as values"}));
                MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "posexplode(values) as (idx, value)"}))).noop();
            });
            MODULE$.codegenBenchmark("generate inline array", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Dataset df = MODULE$.spark().range((long)numRows).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as key", "array((rand(), rand()), (rand(), rand()), (rand(), 0.0d)) as values"}));
                MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "inline(values) as (r1, r2)"}))).noop();
            });
            int M = 60000;
            MODULE$.codegenBenchmark("generate big struct array", M, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                public final class Org_apache_spark_sql_execution_benchmark_MiscBenchmark$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_execution_benchmark_MiscBenchmark$$typecreator10$1() {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                Dataset df = MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)"1", Array$.MODULE$.fill(M, (Function0 & Serializable)() -> {
                    double i = scala.math.package$.MODULE$.random();
                    return new Tuple4((Object)Double.toString(i), (Object)Double.toString(i + 1.0), (Object)Double.toString(i + (double)2), (Object)Double.toString(i + (double)3));
                }, ClassTag$.MODULE$.apply(Tuple4.class))), (List)Nil$.MODULE$), MODULE$.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), MODULE$.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_MiscBenchmark$$typecreator10$1()))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col", "arr"}));
                MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"*", "explode(arr) as arr_col"})).select("col", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"arr_col.*"}))).noop();
            });
            MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.NESTED_PRUNING_ON_EXPRESSIONS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.codegenBenchmark("generate big nested struct array", M, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                public final class Org_apache_spark_sql_execution_benchmark_MiscBenchmark$$typecreator20$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_execution_benchmark_MiscBenchmark$$typecreator20$1() {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                Dataset df = MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)"1", Array$.MODULE$.fill(M, (Function0 & Serializable)() -> {
                    double i = scala.math.package$.MODULE$.random();
                    return new Tuple4((Object)Double.toString(i), (Object)Double.toString(i + 1.0), (Object)Double.toString(i + (double)2), (Object)Double.toString(i + (double)3));
                }, ClassTag$.MODULE$.apply(Tuple4.class))), (List)Nil$.MODULE$), MODULE$.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), MODULE$.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_MiscBenchmark$$typecreator20$1()))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col", "arr"})).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col", "struct(col, arr) as st"})).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col", "st.col as col1", "explode(st.arr) as arr_col"}));
                MODULE$.DatasetToBenchmark(df).noop();
            }));
        });
    }

    public void stack(int numRows) {
        this.runBenchmark("generate regular generator", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.codegenBenchmark("generate stack", numRows, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)numRows).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as key", "id % 2 as t1", "id % 3 as t2", "id % 5 as t3", "id % 7 as t4", "id % 13 as t5"}));
            MODULE$.DatasetToBenchmark(df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "stack(4, t1, t2, t3, t4, t5)"}))).noop();
        }));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.filterAndAggregateWithoutGroup(0x7D000000L);
        this.limitAndAggregateWithoutGroup(524288000L);
        this.sample(0x7D00000);
        this.collect(0x100000);
        this.collectLimit(0x100000);
        this.explode(0x1000000);
        this.stack(0x1000000);
    }

    private MiscBenchmark$() {
    }
}

