/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MetadataStructBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final MetadataStructBenchmark$ MODULE$ = new MetadataStructBenchmark$();
    private static final int NUM_ROWS;
    private static final int NUM_ITERS;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        NUM_ROWS = 5000000;
        NUM_ITERS = 32;
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        MetadataStructBenchmark$ metadataStructBenchmark$ = this;
        synchronized (metadataStructBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private int NUM_ROWS() {
        return NUM_ROWS;
    }

    private int NUM_ITERS() {
        return NUM_ITERS;
    }

    private void withTempData(String format, Function1<Dataset<Row>, BoxedUnit> f) {
        File dir = Utils$.MODULE$.createTempDir();
        dir.delete();
        try {
            this.spark().range(0L, (long)this.NUM_ROWS(), 1L, 1).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).withColumn("num1", this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$plus((Object)BoxesRunTime.boxToInteger((int)10))).withColumn("num2", this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$div((Object)BoxesRunTime.boxToInteger((int)10))).withColumn("str", functions$.MODULE$.lit((Object)"a sample string ").$plus((Object)this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).cast("string"))).write().format(format).save(dir.getAbsolutePath());
            Dataset df = this.spark().read().format(format).load(dir.getAbsolutePath());
            f.apply((Object)df);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(dir);
        }
    }

    private String withTempData$default$1() {
        return "parquet";
    }

    private void addCase(Benchmark benchmark, Dataset<Row> df, Option<String> metadataCol) {
        benchmark.addCase((String)metadataCol.getOrElse((Function0 & Serializable)() -> "no metadata columns"), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> MODULE$.DatasetToBenchmark(df.select("*", Option$.MODULE$.option2Iterable(metadataCol).toSeq())).noop());
    }

    private void metadataBenchmark(String name, String format) {
        this.withTempData(format, (Function1<Dataset<Row>, BoxedUnit>)(Function1 & Serializable)df -> {
            MetadataStructBenchmark$.$anonfun$metadataBenchmark$1(name, df);
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Metadata Struct Benchmark", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.metadataBenchmark("Vectorized Parquet", "parquet"));
            MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.metadataBenchmark("Parquet-mr", "parquet"));
            MODULE$.metadataBenchmark("JSON", "json");
        });
    }

    public static final /* synthetic */ void $anonfun$metadataBenchmark$1(String name$1, Dataset df) {
        String[] metadataCols = ((StructType)((StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])df.select(FileFormat$.MODULE$.METADATA_NAME(), (Seq)Nil$.MODULE$).schema().fields()))).dataType()).fieldNames();
        String x$1 = name$1;
        long x$2 = MODULE$.NUM_ROWS();
        int x$3 = MODULE$.NUM_ITERS();
        Option x$4 = MODULE$.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$3, x$5, x$6, x$7, x$4);
        MODULE$.addCase(benchmark, (Dataset<Row>)df, (Option<String>)None$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])metadataCols), (Function1 & Serializable)metadataCol -> {
            MetadataStructBenchmark$.MODULE$.addCase(benchmark, (Dataset<Row>)df, (Option<String>)new Some((Object)(FileFormat$.MODULE$.METADATA_NAME() + "." + metadataCol)));
            return BoxedUnit.UNIT;
        });
        MODULE$.addCase(benchmark, (Dataset<Row>)df, (Option<String>)new Some((Object)FileFormat$.MODULE$.METADATA_NAME()));
        benchmark.run();
    }

    private MetadataStructBenchmark$() {
    }
}

