/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.BroadcastNestedLoopJoinExec;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class JoinBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final JoinBenchmark$ MODULE$ = new JoinBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        JoinBenchmark$ joinBenchmark$ = this;
        synchronized (joinBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    public void broadcastHashJoinLongKey() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
        this.codegenBenchmark("Join w long", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinLongKey$2(x$1))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void broadcastHashJoinLongKeyWithDuplicates() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id/10 as long) as k"})));
        this.codegenBenchmark("Join w long duplicated", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinLongKeyWithDuplicates$2(x$2))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void broadcastHashJoinTwoIntKey() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim2 = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id as int) as k1", "cast(id as int) as k2", "cast(id as string) as v"})));
        this.codegenBenchmark("Join w 2 ints", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim2, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).cast((DataType)IntegerType$.MODULE$).$eq$eq$eq((Object)functions$.MODULE$.col("k1")).$amp$amp((Object)functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).cast((DataType)IntegerType$.MODULE$).$eq$eq$eq((Object)functions$.MODULE$.col("k2"))));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinTwoIntKey$2(x$3))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void broadcastHashJoinTwoLongKey() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim3 = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as k1", "id as k2", "cast(id as string) as v"})));
        this.codegenBenchmark("Join w 2 longs", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim3, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k1")).$amp$amp((Object)functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k2"))));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinTwoLongKey$2(x$4))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void broadcastHashJoinTwoLongKeyWithDuplicates() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim4 = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id/10 as long) as k1", "cast(id/10 as long) as k2"})));
        this.codegenBenchmark("Join w 2 longs duplicated", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim4, functions$.MODULE$.col("id").bitwiseAND((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k1")).$amp$amp((Object)functions$.MODULE$.col("id").bitwiseAND((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k2"))));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinTwoLongKeyWithDuplicates$2(x$5))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void broadcastHashJoinOuterJoinLongKey() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
        this.codegenBenchmark("outer join w long", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")), "left");
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinOuterJoinLongKey$2(x$6))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void broadcastHashJoinSemiJoinLongKey() {
        int N = 0x1400000;
        int M = 65536;
        Dataset dim = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
        this.codegenBenchmark("semi join w long", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim, functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)M)).$eq$eq$eq((Object)functions$.MODULE$.col("k")), "leftsemi");
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastHashJoinSemiJoinLongKey$2(x$7))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void sortMergeJoin() {
        int N = 0x200000;
        this.codegenBenchmark("sort merge join", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df1 = MODULE$.spark().range((long)N).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id * 2 as k1"}));
            Dataset df2 = MODULE$.spark().range((long)N).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id * 3 as k2"}));
            Dataset df = df1.join(df2, functions$.MODULE$.col("k1").$eq$eq$eq((Object)functions$.MODULE$.col("k2")));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$sortMergeJoin$2(x$8))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void sortMergeJoinWithDuplicates() {
        int N = 0x200000;
        this.codegenBenchmark("sort merge join with duplicates", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df1 = MODULE$.spark().range((long)N).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(id * 15485863) % " + N * 10 + " as k1"}));
            Dataset df2 = MODULE$.spark().range((long)N).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(id * 15485867) % " + N * 10 + " as k2"}));
            Dataset df = df1.join(df2, functions$.MODULE$.col("k1").$eq$eq$eq((Object)functions$.MODULE$.col("k2")));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$sortMergeJoinWithDuplicates$2(x$9))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void shuffleHashJoin() {
        long N = 0x400000L;
        this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"10000000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PREFER_SORTMERGEJOIN().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.codegenBenchmark("shuffle hash join", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df1 = MODULE$.spark().range(N).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as k1"}));
            Dataset df2 = MODULE$.spark().range(N / 3L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id * 3 as k2"}));
            Dataset df = df1.join(df2, functions$.MODULE$.col("k1").$eq$eq$eq((Object)functions$.MODULE$.col("k2")));
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$shuffleHashJoin$3(x$10))));
            MODULE$.DatasetToBenchmark(df).noop();
        }));
    }

    public void broadcastNestedLoopJoin() {
        int N = 0x1400000;
        int M = 16;
        Dataset dim = functions$.MODULE$.broadcast(this.spark().range((long)M).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as k", "cast(id as string) as v"})));
        this.codegenBenchmark("broadcast nested loop join", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = MODULE$.spark().range((long)N).join(dim);
            Predef$.MODULE$.assert(df.queryExecution().sparkPlan().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JoinBenchmark$.$anonfun$broadcastNestedLoopJoin$2(x$11))));
            MODULE$.DatasetToBenchmark(df).noop();
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Join Benchmark", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.broadcastHashJoinLongKey();
            MODULE$.broadcastHashJoinLongKeyWithDuplicates();
            MODULE$.broadcastHashJoinTwoIntKey();
            MODULE$.broadcastHashJoinTwoLongKey();
            MODULE$.broadcastHashJoinTwoLongKeyWithDuplicates();
            MODULE$.broadcastHashJoinOuterJoinLongKey();
            MODULE$.broadcastHashJoinSemiJoinLongKey();
            MODULE$.sortMergeJoin();
            MODULE$.sortMergeJoinWithDuplicates();
            MODULE$.shuffleHashJoin();
            MODULE$.broadcastNestedLoopJoin();
        });
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinLongKey$2(SparkPlan x$1) {
        return x$1 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinLongKeyWithDuplicates$2(SparkPlan x$2) {
        return x$2 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinTwoIntKey$2(SparkPlan x$3) {
        return x$3 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinTwoLongKey$2(SparkPlan x$4) {
        return x$4 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinTwoLongKeyWithDuplicates$2(SparkPlan x$5) {
        return x$5 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinOuterJoinLongKey$2(SparkPlan x$6) {
        return x$6 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastHashJoinSemiJoinLongKey$2(SparkPlan x$7) {
        return x$7 instanceof BroadcastHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$sortMergeJoin$2(SparkPlan x$8) {
        return x$8 instanceof SortMergeJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$sortMergeJoinWithDuplicates$2(SparkPlan x$9) {
        return x$9 instanceof SortMergeJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$shuffleHashJoin$3(SparkPlan x$10) {
        return x$10 instanceof ShuffledHashJoinExec;
    }

    public static final /* synthetic */ boolean $anonfun$broadcastNestedLoopJoin$2(SparkPlan x$11) {
        return x$11 instanceof BroadcastNestedLoopJoinExec;
    }

    private JoinBenchmark$() {
    }
}

