/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.DataSourceWriteBenchmark;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class InsertTableWithDynamicPartitionsBenchmark$
extends BenchmarkBase
implements DataSourceWriteBenchmark {
    public static final InsertTableWithDynamicPartitionsBenchmark$ MODULE$ = new InsertTableWithDynamicPartitionsBenchmark$();
    private static String tempTable;
    private static int numRows;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        DataSourceWriteBenchmark.$init$(MODULE$);
    }

    @Override
    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        DataSourceWriteBenchmark.withTempTable$(this, tableNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        DataSourceWriteBenchmark.withTable$(this, tableNames, f);
    }

    @Override
    public void writeNumeric(String table, String format, Benchmark benchmark, String dataType) {
        DataSourceWriteBenchmark.writeNumeric$(this, table, format, benchmark, dataType);
    }

    @Override
    public void writeIntString(String table, String format, Benchmark benchmark) {
        DataSourceWriteBenchmark.writeIntString$(this, table, format, benchmark);
    }

    @Override
    public void writePartition(String table, String format, Benchmark benchmark) {
        DataSourceWriteBenchmark.writePartition$(this, table, format, benchmark);
    }

    @Override
    public void writeBucket(String table, String format, Benchmark benchmark) {
        DataSourceWriteBenchmark.writeBucket$(this, table, format, benchmark);
    }

    @Override
    public void runDataSourceBenchmark(String format, Option<String> extraInfo) {
        DataSourceWriteBenchmark.runDataSourceBenchmark$(this, format, extraInfo);
    }

    @Override
    public Option<String> runDataSourceBenchmark$default$2() {
        return DataSourceWriteBenchmark.runDataSourceBenchmark$default$2$(this);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public String tempTable() {
        return tempTable;
    }

    @Override
    public int numRows() {
        return numRows;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$DataSourceWriteBenchmark$_setter_$tempTable_$eq(String x$1) {
        tempTable = x$1;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$DataSourceWriteBenchmark$_setter_$numRows_$eq(int x$1) {
        numRows = x$1;
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        InsertTableWithDynamicPartitionsBenchmark$ insertTableWithDynamicPartitionsBenchmark$ = this;
        synchronized (insertTableWithDynamicPartitionsBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    public long prepareSourceTableAndGetTotalRows(long numberRows, String sourceTable, int part1Step, int part2Step, int part3Step) {
        Dataset dataFrame = this.spark().range(0L, numberRows, 1L, 4);
        Dataset dataFrame1 = this.spark().range(0L, numberRows, (long)part1Step, 4);
        Dataset dataFrame2 = this.spark().range(0L, numberRows, (long)part2Step, 4);
        Dataset dataFrame3 = this.spark().range(0L, numberRows, (long)part3Step, 4);
        Dataset data = dataFrame.join(dataFrame1).join(dataFrame2).join(dataFrame3).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "part1", "part2", "part3"}));
        data.write().saveAsTable(sourceTable);
        return data.count();
    }

    public void writeOnePartitionColumnTable(String tableName, long partitionNumber, Benchmark benchmark) {
        this.spark().sql("create table " + tableName + "(i bigint, part bigint) using parquet partitioned by (part)");
        benchmark.addCase("one partition column, " + partitionNumber + " partitions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> MODULE$.spark().sql("insert overwrite table " + tableName + " partition(part) select id, part1 as part from sourceTable"));
    }

    public void writeTwoPartitionColumnTable(String tableName, long partitionNumber, Benchmark benchmark) {
        this.spark().sql("create table " + tableName + "(i bigint, part1 bigint, part2 bigint) using parquet partitioned by (part1, part2)");
        benchmark.addCase("two partition columns, " + partitionNumber + " partitions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.spark().sql("insert overwrite table " + tableName + " partition(part1, part2) select id, part1, part2 from sourceTable"));
    }

    public void writeThreePartitionColumnTable(String tableName, long partitionNumber, Benchmark benchmark) {
        this.spark().sql("create table " + tableName + "(i bigint, part1 bigint, part2 bigint, part3 bigint) using parquet partitioned by (part1, part2, part3)");
        benchmark.addCase("three partition columns, " + partitionNumber + " partitions", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.spark().sql("insert overwrite table " + tableName + " partition(part1, part2, part3) select id, part1, part2, part3 from sourceTable"));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        String sourceTable = "sourceTable";
        String onePartColTable = "onePartColTable";
        String twoPartColTable = "twoPartColTable";
        String threePartColTable = "threePartColTable";
        long numberRows = 100L;
        int part1Step = 1;
        int part2Step = 20;
        int part3Step = 25;
        long part1Number = numberRows / (long)part1Step;
        long part2Number = numberRows / (long)part2Step * part1Number;
        long part3Number = numberRows / (long)part3Step * part2Number;
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTable, onePartColTable, twoPartColTable, threePartColTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            long totalRows = MODULE$.prepareSourceTableAndGetTotalRows(numberRows, sourceTable, part1Step, part2Step, part3Step);
            String x$1 = "dynamic insert table benchmark, totalRows = " + totalRows;
            long x$2 = totalRows;
            Option x$3 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
            MODULE$.writeOnePartitionColumnTable(onePartColTable, part1Number, benchmark);
            MODULE$.writeTwoPartitionColumnTable(twoPartColTable, part2Number, benchmark);
            MODULE$.writeThreePartitionColumnTable(threePartColTable, part3Number, benchmark);
            benchmark.run();
        });
    }

    private InsertTableWithDynamicPartitionsBenchmark$() {
    }
}

