/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class BloomFilterBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final BloomFilterBenchmark$ MODULE$ = new BloomFilterBenchmark$();
    private static final int scaleFactor;
    private static final int N;
    private static final Dataset<Object> df;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        scaleFactor = 100;
        N = MODULE$.scaleFactor() * 1000 * 1000;
        df = MODULE$.spark().range((long)MODULE$.N()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt()), MODULE$.spark().implicits().newIntEncoder());
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        BloomFilterBenchmark$ bloomFilterBenchmark$ = this;
        synchronized (bloomFilterBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private int scaleFactor() {
        return scaleFactor;
    }

    private int N() {
        return N;
    }

    private Dataset<Object> df() {
        return df;
    }

    private void writeORCBenchmark() {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            BloomFilterBenchmark$.$anonfun$writeORCBenchmark$1(dir);
            return BoxedUnit.UNIT;
        });
    }

    private void readORCBenchmark() {
        Seq blockSizes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0x200000, 0x400000, 0x600000, 0x800000, 0xC00000, 0x1000000, 0x2000000}));
        blockSizes.foreach((Function1)(JFunction1.mcVI.sp & Serializable)blocksize -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            BloomFilterBenchmark$.$anonfun$readORCBenchmark$2(blocksize, dir);
            return BoxedUnit.UNIT;
        }));
    }

    private void writeParquetBenchmark() {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            BloomFilterBenchmark$.$anonfun$writeParquetBenchmark$1(dir);
            return BoxedUnit.UNIT;
        });
    }

    private void readParquetBenchmark() {
        Seq blockSizes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0x200000, 0x400000, 0x600000, 0x800000, 0xC00000, 0x1000000, 0x2000000}));
        blockSizes.foreach((Function1)(JFunction1.mcVI.sp & Serializable)blocksize -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            BloomFilterBenchmark$.$anonfun$readParquetBenchmark$2(blocksize, dir);
            return BoxedUnit.UNIT;
        }));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.writeORCBenchmark();
        this.readORCBenchmark();
        this.writeParquetBenchmark();
        this.readParquetBenchmark();
    }

    public static final /* synthetic */ void $anonfun$writeORCBenchmark$1(File dir) {
        String path = dir.getCanonicalPath();
        MODULE$.runBenchmark("ORC Write", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "Write " + MODULE$.scaleFactor() + "M rows";
            long x$22 = MODULE$.N();
            Option x$32 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$22, x$4, x$5, x$6, x$7, x$32);
            benchmark.addCase("Without bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.df().write().mode("overwrite").orc(path + "/withoutBF"));
            benchmark.addCase("With bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.df().write().mode("overwrite").option("orc.bloom.filter.columns", "value").orc(path + "/withBF"));
            benchmark.run();
        });
    }

    public static final /* synthetic */ void $anonfun$readORCBenchmark$2(int blocksize$1, File dir) {
        String path = dir.getCanonicalPath();
        MODULE$.df().write().option("orc.block.size", (long)blocksize$1).orc(path + "/withoutBF");
        MODULE$.df().write().option("orc.block.size", (long)blocksize$1).option("orc.bloom.filter.columns", "value").orc(path + "/withBF");
        MODULE$.runBenchmark("ORC Read", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "Read a row from " + MODULE$.scaleFactor() + "M rows";
            long x$2 = MODULE$.N();
            Option x$3 = MODULE$.output();
            int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$42, x$52, x$6, x$7, x$3);
            benchmark.addCase("Without bloom filter, blocksize: " + blocksize$1, benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().orc(path + "/withoutBF").where("value = 0")).noop());
            benchmark.addCase("With bloom filter, blocksize: " + blocksize$1, benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().orc(path + "/withBF").where("value = 0")).noop());
            benchmark.run();
        });
    }

    public static final /* synthetic */ void $anonfun$writeParquetBenchmark$1(File dir) {
        String path = dir.getCanonicalPath();
        MODULE$.runBenchmark("Parquet Write", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "Write " + MODULE$.scaleFactor() + "M rows";
            long x$2 = MODULE$.N();
            Option x$3 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$72 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$62, x$72, x$3);
            benchmark.addCase("Without bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> MODULE$.df().write().mode("overwrite").parquet(path + "/withoutBF"));
            benchmark.addCase("With bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> MODULE$.df().write().mode("overwrite").option("parquet.bloom.filter.enabled#value", true).parquet(path + "/withBF"));
            benchmark.run();
        });
    }

    public static final /* synthetic */ void $anonfun$readParquetBenchmark$2(int blocksize$2, File dir) {
        String path = dir.getCanonicalPath();
        MODULE$.df().write().option("parquet.block.size", (long)blocksize$2).parquet(path + "/withoutBF");
        MODULE$.df().write().option("parquet.bloom.filter.enabled#value", true).option("parquet.block.size", (long)blocksize$2).parquet(path + "/withBF");
        MODULE$.runBenchmark("Parquet Read", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "Read a row from " + MODULE$.scaleFactor() + "M rows";
            long x$2 = MODULE$.N();
            Option x$3 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
            benchmark.addCase("Without bloom filter, blocksize: " + blocksize$2, benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().parquet(path + "/withoutBF").where("value = 0")).noop());
            benchmark.addCase("With bloom filter, blocksize: " + blocksize$2, benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().option("parquet.filter.bloom.enabled", true).parquet(path + "/withBF").where("value = 0")).noop());
            benchmark.run();
        });
    }

    private BloomFilterBenchmark$() {
    }
}

