/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.Serializable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.execution.arrow.ArrowFieldWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.ArrowUtils$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t\u0001\u0012I\u001d:po^\u0013\u0018\u000e^3s'VLG/\u001a\u0006\u0003\t\u0015\tQ!\u0019:s_^T!AB\u0004\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0005\n\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\n\u0013\t!\u0012BA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\r\u0001")
public class ArrowWriterSuite
extends SparkFunSuite {
    private final void check$1(DataType dt, Seq data, String timeZoneId, boolean largeVarTypes) {
        DataType dataType = dt;
        DayTimeIntervalType datatype = dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : (dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : dataType);
        StructType schema = new StructType().add("value", (DataType)datatype, true);
        ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, timeZoneId, ArrowWriter$.MODULE$.create$default$3());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        data.foreach((Function1 & Serializable)datum -> {
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{datum})));
            return BoxedUnit.UNIT;
        });
        writer.finish();
        ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
        ((IterableOnceOps)data.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object = tuple2._1();
                int rowId = tuple2._2$mcI$sp();
                if (object == null) {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(rowId), "reader.isNullAt(rowId)", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
                }
            }
            if (tuple2 != null) {
                DecimalType decimalType;
                Option option;
                Object object;
                Object datum = tuple2._1();
                int rowId = tuple2._2$mcI$sp();
                DataType dataType = dt;
                if (BooleanType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToBoolean((boolean)reader.getBoolean(rowId));
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToByte((byte)reader.getByte(rowId));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToShort((short)reader.getShort(rowId));
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToInteger((int)reader.getInt(rowId));
                } else if (LongType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToLong((long)reader.getLong(rowId));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToFloat((float)reader.getFloat(rowId));
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToDouble((double)reader.getDouble(rowId));
                } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    object = reader.getDecimal(rowId, precision, scale);
                } else if (StringType$.MODULE$.equals(dataType)) {
                    object = reader.getUTF8String(rowId);
                } else if (BinaryType$.MODULE$.equals(dataType)) {
                    object = reader.getBinary(rowId);
                } else if (DateType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToInteger((int)reader.getInt(rowId));
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToLong((long)reader.getLong(rowId));
                } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
                    object = BoxesRunTime.boxToLong((long)reader.getLong(rowId));
                } else if (dataType instanceof YearMonthIntervalType) {
                    object = BoxesRunTime.boxToInteger((int)reader.getInt(rowId));
                } else if (dataType instanceof DayTimeIntervalType) {
                    object = BoxesRunTime.boxToLong((long)reader.getLong(rowId));
                } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    object = reader.getInterval(rowId);
                } else {
                    throw new MatchError((Object)dataType);
                }
                Boolean value = object;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(value);
                Object $org_scalatest_assert_macro_right = datum;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            }
            throw new MatchError((Object)tuple2);
        });
        writer.root().close();
    }

    private static final String check$default$3$1() {
        return null;
    }

    private static final boolean check$default$4$1() {
        return false;
    }

    private final void check$2(DataType dt, Seq data, String timeZoneId) {
        Object[] objectArray;
        DataType dataType = dt;
        DayTimeIntervalType avroDatatype = dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : (dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : dataType);
        StructType schema = new StructType().add("value", (DataType)avroDatatype, false);
        ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, timeZoneId, ArrowWriter$.MODULE$.create$default$3());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        data.foreach((Function1 & Serializable)datum -> {
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{datum})));
            return BoxedUnit.UNIT;
        });
        writer.finish();
        ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
        DataType dataType2 = dt;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getBooleans(0, data.size());
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getBytes(0, data.size());
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getShorts(0, data.size());
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getInts(0, data.size());
        } else if (LongType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getLongs(0, data.size());
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getFloats(0, data.size());
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getDoubles(0, data.size());
        } else if (DateType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getInts(0, data.size());
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getLongs(0, data.size());
        } else if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            objectArray = reader.getLongs(0, data.size());
        } else if (dataType2 instanceof YearMonthIntervalType) {
            objectArray = reader.getInts(0, data.size());
        } else if (dataType2 instanceof DayTimeIntervalType) {
            objectArray = reader.getLongs(0, data.size());
        } else {
            throw new MatchError((Object)dataType2);
        }
        boolean[] values = objectArray;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(values);
        Seq $org_scalatest_assert_macro_right2 = data;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        writer.root().close();
    }

    private static final String check$default$3$2() {
        return null;
    }

    public static final /* synthetic */ byte $anonfun$new$10(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ short $anonfun$new$11(int x$4) {
        return (short)x$4;
    }

    private static final Tuple2 createArrowWriter$1(StructType schema, String timeZoneId) {
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId, true, ArrowUtils$.MODULE$.toArrowSchema$default$4());
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)ArrowUtils$.MODULE$.rootAllocator());
        FieldVector vector = (FieldVector)root.getFieldVectors().get(0);
        vector.allocateNew();
        int cap = vector.getValueCapacity();
        ArrowWriter writer = new ArrowWriter(root, (ArrowFieldWriter[])((Object[])new ArrowFieldWriter[]{ArrowWriter$.MODULE$.createFieldWriter((ValueVector)vector)}));
        return new Tuple2((Object)writer, (Object)BoxesRunTime.boxToInteger((int)cap));
    }

    public static final /* synthetic */ Assertion $anonfun$new$24(ArrowWriterSuite $this, DataType dt$2, ArrowColumnVector reader$2, Seq data$1, int offset) {
        Object[] objectArray;
        DataType dataType = dt$2;
        if (BooleanType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getBooleans(offset, data$1.size());
        } else if (ByteType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getBytes(offset, data$1.size());
        } else if (ShortType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getShorts(offset, data$1.size());
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getInts(offset, data$1.size());
        } else if (LongType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getLongs(offset, data$1.size());
        } else if (FloatType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getFloats(offset, data$1.size());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getDoubles(offset, data$1.size());
        } else if (DateType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getInts(offset, data$1.size());
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getLongs(offset, data$1.size());
        } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
            objectArray = reader$2.getLongs(offset, data$1.size());
        } else if (dataType instanceof YearMonthIntervalType) {
            objectArray = reader$2.getInts(offset, data$1.size());
        } else if (dataType instanceof DayTimeIntervalType) {
            objectArray = reader$2.getLongs(offset, data$1.size());
        } else {
            throw new MatchError((Object)dataType);
        }
        boolean[] values = objectArray;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(values);
        Seq $org_scalatest_assert_macro_right = data$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
    }

    private final void check$3(DataType dt, Seq data, String timeZoneId) {
        DataType dataType = dt;
        Object dataType2 = dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : (dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : dataType);
        StructType schema = new StructType().add("value", (DataType)dataType2, false);
        Tuple2 tuple2 = ArrowWriterSuite.createArrowWriter$1(schema, timeZoneId);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrowWriter writer = (ArrowWriter)tuple2._1();
        int initialCapacity = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)writer, (Object)BoxesRunTime.boxToInteger((int)initialCapacity));
        ArrowWriter writer2 = (ArrowWriter)tuple22._1();
        int initialCapacity2 = tuple22._2$mcI$sp();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer2.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        int iterations = initialCapacity2 / data.length() + 1;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), iterations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> data.foreach((Function1 & Serializable)datum -> {
            writer2.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{datum})));
            return BoxedUnit.UNIT;
        }));
        writer2.finish();
        ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer2.root().getFieldVectors().get(0));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), iterations).map((Function1)(JFunction1.mcII.sp & Serializable)i -> i * data.size()).foreach((Function1 & Serializable)offset -> ArrowWriterSuite.$anonfun$new$24(this, dt, reader, data, BoxesRunTime.unboxToInt((Object)offset)));
        writer2.root().close();
    }

    private static final String check$default$3$3() {
        return null;
    }

    public static final /* synthetic */ byte $anonfun$new$25(int x$15) {
        return (byte)x$15;
    }

    public static final /* synthetic */ short $anonfun$new$26(int x$16) {
        return (short)x$16;
    }

    private static final String stringRepr$1(ColumnarMap map, StructType valueSchema$1) {
        return map.valueArray().getStruct(0, 2).toSeq(valueSchema$1).mkString(",");
    }

    public ArrowWriterSuite() {
        this.test("simple", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$1((DataType)BooleanType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), null, BoxesRunTime.boxToBoolean((boolean)false)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)ByteType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToByte((byte)((byte)2)), null, BoxesRunTime.boxToByte((byte)((byte)4))})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)ShortType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)1)), BoxesRunTime.boxToShort((short)((short)2)), null, BoxesRunTime.boxToShort((short)((short)4))})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)IntegerType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)4)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)LongType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), null, BoxesRunTime.boxToLong((long)4L)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)FloatType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)1.0f), BoxesRunTime.boxToFloat((float)2.0f), null, BoxesRunTime.boxToFloat((float)4.0f)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)DoubleType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToDouble((double)2.0), null, BoxesRunTime.boxToDouble((double)4.0)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), (Seq)new .colon.colon((Object)Decimal$.MODULE$.apply(1), (List)new .colon.colon((Object)Decimal$.MODULE$.apply(2), (List)new .colon.colon(null, (List)new .colon.colon((Object)Decimal$.MODULE$.apply(4), (List)Nil$.MODULE$)))), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)StringType$.MODULE$, (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon(null, (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1)), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)StringType$.MODULE$, (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon(null, (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1)), null, true);
            this.check$1((DataType)BinaryType$.MODULE$, (Seq)new .colon.colon((Object)"a".getBytes(), (List)new .colon.colon((Object)"b".getBytes(), (List)new .colon.colon(null, (List)new .colon.colon((Object)"d".getBytes(), (List)Nil$.MODULE$)))), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)BinaryType$.MODULE$, (Seq)new .colon.colon((Object)"a".getBytes(), (List)new .colon.colon((Object)"b".getBytes(), (List)new .colon.colon(null, (List)new .colon.colon((Object)"d".getBytes(), (List)Nil$.MODULE$)))), null, true);
            this.check$1((DataType)DateType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)4)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)TimestampType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), BoxesRunTime.boxToLong((long)3600000000L), null, BoxesRunTime.boxToLong((long)86400000000L)})), "America/Los_Angeles", ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)TimestampNTZType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), BoxesRunTime.boxToLong((long)3600000000L), null, BoxesRunTime.boxToLong((long)86400000000L)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            this.check$1((DataType)NullType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
            DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)x$1 -> {
                this.check$1((DataType)x$1, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)x$2 -> {
                this.check$1((DataType)x$2, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)0L), BoxesRunTime.boxToLong((long)1000L), BoxesRunTime.boxToLong((long)-1000L), BoxesRunTime.boxToLong((long)9223372036854775000L), BoxesRunTime.boxToLong((long)-9223372036854775000L)})), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
                return BoxedUnit.UNIT;
            });
            this.check$1((DataType)CalendarIntervalType$.MODULE$, (Seq)new .colon.colon((Object)new CalendarInterval(1, 2, 3L), (List)new .colon.colon((Object)new CalendarInterval(11, 22, 33L), (List)new .colon.colon((Object)new CalendarInterval(-1, -2, -3L), (List)new .colon.colon((Object)new CalendarInterval(-11, -22, -33L), (List)new .colon.colon(null, (List)Nil$.MODULE$))))), ArrowWriterSuite.check$default$3$1(), ArrowWriterSuite.check$default$4$1());
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("get multiple", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$2((DataType)BooleanType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)ByteType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToByte((byte)ArrowWriterSuite.$anonfun$new$10(BoxesRunTime.unboxToInt((Object)x$3)))), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)ShortType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToShort((short)ArrowWriterSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)x$4)))), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)IntegerType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)LongType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$5 -> x$5), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)FloatType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcFI.sp & Serializable)x$6 -> x$6), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)DoubleType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcDI.sp & Serializable)x$7 -> x$7), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)DateType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10), ArrowWriterSuite.check$default$3$2());
            this.check$2((DataType)TimestampType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$8 -> (long)x$8 * 43200000000L), "America/Los_Angeles");
            this.check$2((DataType)TimestampNTZType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$9 -> (long)x$9 * 43200000000L), ArrowWriterSuite.check$default$3$2());
            DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)x$10 -> {
                this.check$2((DataType)x$10, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 14), ArrowWriterSuite.check$default$3$2());
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)x$11 -> {
                this.check$2((DataType)x$11, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(-10), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$12 -> (long)x$12 * 1000L), ArrowWriterSuite.check$default$3$2());
                return BoxedUnit.UNIT;
            });
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("write multiple, over initial capacity", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$3((DataType)BooleanType$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)ByteType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToByte((byte)ArrowWriterSuite.$anonfun$new$25(BoxesRunTime.unboxToInt((Object)x$15)))), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)ShortType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToShort((short)ArrowWriterSuite.$anonfun$new$26(BoxesRunTime.unboxToInt((Object)x$16)))), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)IntegerType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)LongType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$17 -> x$17), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)FloatType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcFI.sp & Serializable)x$18 -> x$18), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)DoubleType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcDI.sp & Serializable)x$19 -> x$19), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)DateType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10), ArrowWriterSuite.check$default$3$3());
            this.check$3((DataType)TimestampType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$20 -> (long)x$20 * 43200000000L), "America/Los_Angeles");
            this.check$3((DataType)TimestampNTZType$.MODULE$, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$21 -> (long)x$21 * 43200000000L), ArrowWriterSuite.check$default$3$3());
            DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)x$22 -> {
                this.check$3((DataType)x$22, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 14), ArrowWriterSuite.check$default$3$3());
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)x$23 -> {
                this.check$3((DataType)x$23, (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(-10), 10).map((Function1)(JFunction1.mcJI.sp & Serializable)x$24 -> (long)x$24 * 1000L), ArrowWriterSuite.check$default$3$3());
                return BoxedUnit.UNIT;
            });
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("array", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("arr", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true);
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData((Object)new int[]{1, 2, 3})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData((Object)new int[]{4, 5})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)8)})})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarArray array0 = reader.getArray(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array0.numElements()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array0.getInt(0)));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array0.getInt(1)));
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array0.getInt(2)));
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            ColumnarArray array1 = reader.getArray(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array1.numElements()));
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array1.getInt(0)));
            int $org_scalatest_assert_macro_right7 = 4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array1.getInt(1)));
            int $org_scalatest_assert_macro_right8 = 5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(2), "reader.isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            ColumnarArray array3 = reader.getArray(3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array3.numElements()));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            ColumnarArray array4 = reader.getArray(4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array4.numElements()));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array4.getInt(0)));
            int $org_scalatest_assert_macro_right11 = 6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(array4.isNullAt(1), "array4.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array4.getInt(2)));
            int $org_scalatest_assert_macro_right12 = 8;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("nested array", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("nested", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)));
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData((Object)new ArrayData[]{ArrayData$.MODULE$.toArrayData((Object)new int[]{1, 2, 3}), ArrayData$.MODULE$.toArrayData((Object)new int[]{4, 5}), null, ArrayData$.MODULE$.toArrayData(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int())), ArrayData$.MODULE$.toArrayData((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)8)})})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData(Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing()))})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarArray array0 = reader.getArray(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array0.numElements()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            ColumnarArray array00 = array0.getArray(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array00.numElements()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array00.getInt(0)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array00.getInt(1)));
            int $org_scalatest_assert_macro_right5 = 2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array00.getInt(2)));
            int $org_scalatest_assert_macro_right6 = 3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            ColumnarArray array01 = array0.getArray(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array01.numElements()));
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array01.getInt(0)));
            int $org_scalatest_assert_macro_right8 = 4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array01.getInt(1)));
            int $org_scalatest_assert_macro_right9 = 5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(array0.isNullAt(2), "array0.isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            ColumnarArray array03 = array0.getArray(3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array03.numElements()));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            ColumnarArray array04 = array0.getArray(4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array04.numElements()));
            int $org_scalatest_assert_macro_right11 = 3;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array04.getInt(0)));
            int $org_scalatest_assert_macro_right12 = 6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(array04.isNullAt(1), "array04.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array04.getInt(2)));
            int $org_scalatest_assert_macro_right13 = 8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(1), "reader.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            ColumnarArray array2 = reader.getArray(2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array2.numElements()));
            int $org_scalatest_assert_macro_right14 = 0;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("null array", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("arr", (DataType)new ArrayType((DataType)NullType$.MODULE$, true), true);
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData(Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}), ClassTag$.MODULE$.Null()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData(Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null}), ClassTag$.MODULE$.Null()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayData$.MODULE$.toArrayData(Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}), ClassTag$.MODULE$.Null()))})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarArray array0 = reader.getArray(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array0.numElements()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(array0.isNullAt(0), "array0.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(array0.isNullAt(1), "array0.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(array0.isNullAt(2), "array0.isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            ColumnarArray array1 = reader.getArray(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array1.numElements()));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(array1.isNullAt(0), "array1.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(array1.isNullAt(1), "array1.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(2), "reader.isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            ColumnarArray array3 = reader.getArray(3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array3.numElements()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            ColumnarArray array4 = reader.getArray(4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)array4.numElements()));
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(array4.isNullAt(0), "array4.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(array4.isNullAt(1), "array4.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(array4.isNullAt(2), "array4.isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("struct", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("str", (DataType)StringType$.MODULE$));
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"str1")}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), null}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, UTF8String.fromString((String)"str5")}))})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarRow struct0 = reader.getStruct(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct0.getInt(0)));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(struct0.getUTF8String(1));
            UTF8String $org_scalatest_assert_macro_right3 = UTF8String.fromString((String)"str1");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            ColumnarRow struct1 = reader.getStruct(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(struct1.isNullAt(0), "struct1.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(struct1.isNullAt(1), "struct1.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(2), "reader.isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            ColumnarRow struct3 = reader.getStruct(3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct3.getInt(0)));
            int $org_scalatest_assert_macro_right4 = 4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(struct3.isNullAt(1), "struct3.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            ColumnarRow struct4 = reader.getStruct(4);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(struct4.isNullAt(0), "struct4.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(struct4.getUTF8String(1));
            UTF8String $org_scalatest_assert_macro_right5 = UTF8String.fromString((String)"str5");
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        this.test("nested struct", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("struct", (DataType)new StructType().add("nested", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("str", (DataType)StringType$.MODULE$)));
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"str1")}))}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarRow struct00 = reader.getStruct(0).getStruct(0, 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct00.getInt(0)));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(struct00.getUTF8String(1));
            UTF8String $org_scalatest_assert_macro_right3 = UTF8String.fromString((String)"str1");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            ColumnarRow struct10 = reader.getStruct(1).getStruct(0, 2);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(struct10.isNullAt(0), "struct10.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(struct10.isNullAt(1), "struct10.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            ColumnarRow struct2 = reader.getStruct(2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(struct2.isNullAt(0), "struct2.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(3), "reader.isNullAt(3)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("null struct", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("struct", (DataType)new StructType().add("n1", (DataType)NullType$.MODULE$).add("n2", (DataType)NullType$.MODULE$));
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarRow struct0 = reader.getStruct(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(struct0.isNullAt(0), "struct0.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(struct0.isNullAt(1), "struct0.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(reader.isNullAt(1), "reader.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            ColumnarRow struct2 = reader.getStruct(2);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(struct2.isNullAt(0), "struct2.isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(struct2.isNullAt(1), "struct2.isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        this.test("map", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ColumnarMap map3;
            StructType schema = new StructType().add("map", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$), true);
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            StructType $org_scalatest_assert_macro_left = writer.schema();
            StructType $org_scalatest_assert_macro_right = schema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{1, 2, 3}, (Object)new UTF8String[]{UTF8String.fromString((String)"v2"), UTF8String.fromString((String)"v3"), UTF8String.fromString((String)"v4")})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{43}, (Object)new UTF8String[]{UTF8String.fromString((String)"v5")})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{43}, Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarMap map0 = reader.getMap(0);
            int $org_scalatest_assert_macro_left2 = map0.numElements();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            String $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray(map0.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right3 = Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}).mkString(",");
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
            String $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapRefArray(map0.valueArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right4 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v2", "v3", "v4"}).mkString(",");
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            ColumnarMap map1 = reader.getMap(1);
            int $org_scalatest_assert_macro_left5 = map1.numElements();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            String $org_scalatest_assert_macro_left6 = Predef$.MODULE$.wrapRefArray(map1.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right6 = Predef$.MODULE$.wrapIntArray(new int[]{43}).mkString(",");
            String string5 = $org_scalatest_assert_macro_left6;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
            String $org_scalatest_assert_macro_left7 = Predef$.MODULE$.wrapRefArray(map1.valueArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right7 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v5"}).mkString(",");
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            ColumnarMap map2 = reader.getMap(2);
            int $org_scalatest_assert_macro_left8 = map2.numElements();
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            String $org_scalatest_assert_macro_left9 = Predef$.MODULE$.wrapRefArray(map2.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right9 = Predef$.MODULE$.wrapIntArray(new int[]{43}).mkString(",");
            String string9 = $org_scalatest_assert_macro_left9;
            String string10 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            String $org_scalatest_assert_macro_left10 = Predef$.MODULE$.wrapRefArray(map2.valueArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right10 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null())).mkString(",");
            String string11 = $org_scalatest_assert_macro_left10;
            String string12 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            ColumnarMap $org_scalatest_assert_macro_left11 = map3 = reader.getMap(3);
            Object $org_scalatest_assert_macro_right11 = null;
            ColumnarMap columnarMap = $org_scalatest_assert_macro_left11;
            Object var47_46 = null;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", null, !(columnarMap != null ? !columnarMap.equals(var47_46) : var47_46 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        this.test("empty map", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("map", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$), true);
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            StructType $org_scalatest_assert_macro_left = writer.schema();
            StructType $org_scalatest_assert_macro_right = schema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()))})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarMap map0 = reader.getMap(0);
            int $org_scalatest_assert_macro_left2 = map0.numElements();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        this.test("null value map", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ColumnarMap map2;
            StructType schema = new StructType().add("map", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)NullType$.MODULE$), true);
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            StructType $org_scalatest_assert_macro_left = writer.schema();
            StructType $org_scalatest_assert_macro_right = schema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{1, 2, 3}, Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}), ClassTag$.MODULE$.Null()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{43}, Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null()))})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarMap map0 = reader.getMap(0);
            int $org_scalatest_assert_macro_left2 = map0.numElements();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
            String $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray(map0.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right3 = Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}).mkString(",");
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
            String $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapRefArray(map0.valueArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right4 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}), ClassTag$.MODULE$.Null())).mkString(",");
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
            ColumnarMap map1 = reader.getMap(1);
            int $org_scalatest_assert_macro_left5 = map1.numElements();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            String $org_scalatest_assert_macro_left6 = Predef$.MODULE$.wrapRefArray(map1.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right6 = Predef$.MODULE$.wrapIntArray(new int[]{43}).mkString(",");
            String string5 = $org_scalatest_assert_macro_left6;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
            String $org_scalatest_assert_macro_left7 = Predef$.MODULE$.wrapRefArray(map1.valueArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right7 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null())).mkString(",");
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            ColumnarMap $org_scalatest_assert_macro_left8 = map2 = reader.getMap(3);
            Object $org_scalatest_assert_macro_right8 = null;
            ColumnarMap columnarMap = $org_scalatest_assert_macro_left8;
            Object var35_34 = null;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", null, !(columnarMap != null ? !columnarMap.equals(var35_34) : var35_34 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            writer.root().close();
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        this.test("nested map", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType valueSchema = new StructType().add("name", (DataType)StringType$.MODULE$).add("age", (DataType)IntegerType$.MODULE$);
            StructType schema = new StructType().add("map", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)valueSchema), true);
            ArrowWriter writer = ArrowWriter$.MODULE$.create(schema, null, ArrowWriter$.MODULE$.create$default$3());
            StructType $org_scalatest_assert_macro_left = writer.schema();
            StructType $org_scalatest_assert_macro_right = schema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{1}, (Object)new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"jon"), BoxesRunTime.boxToInteger((int)20)}))})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{1}, (Object)new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"alice"), BoxesRunTime.boxToInteger((int)30)}))})})));
            writer.write(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayBasedMapData$.MODULE$.apply((Object)new int[]{1}, (Object)new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"bob"), BoxesRunTime.boxToInteger((int)40)}))})})));
            writer.finish();
            ArrowColumnVector reader = new ArrowColumnVector((ValueVector)writer.root().getFieldVectors().get(0));
            ColumnarMap map0 = reader.getMap(0);
            int $org_scalatest_assert_macro_left2 = map0.numElements();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            String $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray(map0.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right3 = Predef$.MODULE$.wrapIntArray(new int[]{1}).mkString(",");
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
            String $org_scalatest_assert_macro_left4 = ArrowWriterSuite.stringRepr$1(map0, valueSchema);
            String $org_scalatest_assert_macro_right4 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jon", "20"}).mkString(",");
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
            ColumnarMap map1 = reader.getMap(1);
            int $org_scalatest_assert_macro_left5 = map1.numElements();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
            String $org_scalatest_assert_macro_left6 = Predef$.MODULE$.wrapRefArray(map1.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right6 = Predef$.MODULE$.wrapIntArray(new int[]{1}).mkString(",");
            String string5 = $org_scalatest_assert_macro_left6;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
            String $org_scalatest_assert_macro_left7 = ArrowWriterSuite.stringRepr$1(map1, valueSchema);
            String $org_scalatest_assert_macro_right7 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alice", "30"}).mkString(",");
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            ColumnarMap map2 = reader.getMap(2);
            int $org_scalatest_assert_macro_left8 = map2.numElements();
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            String $org_scalatest_assert_macro_left9 = Predef$.MODULE$.wrapRefArray(map2.keyArray().array()).mkString(",");
            String $org_scalatest_assert_macro_right9 = Predef$.MODULE$.wrapIntArray(new int[]{1}).mkString(",");
            String string9 = $org_scalatest_assert_macro_left9;
            String string10 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            String $org_scalatest_assert_macro_left10 = ArrowWriterSuite.stringRepr$1(map2, valueSchema);
            String $org_scalatest_assert_macro_right10 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bob", "40"}).mkString(",");
            String string11 = $org_scalatest_assert_macro_left10;
            String string12 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        }, new Position("ArrowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
    }
}

