/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.util.ExecutionListenerBus;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u000552Aa\u0001\u0003\u0001\u001b!)!\u0004\u0001C\u00017!)a\u0004\u0001C!?\tA2\u000b]1sWN+7o]5p]\n+\u0018\u000e\u001c3feN+\u0018\u000e^3\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u0018\u0015\u0005I1oY1mCR,7\u000f^\u0005\u00033Q\u0011!\"\u0012<f]R,\u0018\r\u001c7z\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\tA!A\u0005bMR,'/R1dQR\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bF\u0001\u0001(!\tA3&D\u0001*\u0015\tQc!\u0001\u0003uC\u001e\u001c\u0018B\u0001\u0017*\u0005=)\u0005\u0010^3oI\u0016$7+\u0015'UKN$\b")
public class SparkSessionBuilderSuite
extends SparkFunSuite
implements Eventually {
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public void afterEach() {
        SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.getDefaultSession().foreach((Function1 & Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        SparkSession$.MODULE$.clearDefaultSession();
    }

    private final void PatienceConfig$lzycompute$1() {
        SparkSessionBuilderSuite sparkSessionBuilderSuite = this;
        synchronized (sparkSessionBuilderSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$2(SparkListenerInterface x$3) {
        return x$3 instanceof ExecutionListenerBus;
    }

    private static final int listenersNum$1(SparkSession spark$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(spark$1.sparkContext().listenerBus().listeners()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$2(x$3)));
    }

    public static final /* synthetic */ void $anonfun$new$26(Long v) {
        SparkSession$.MODULE$.builder().master("local").getOrCreate();
    }

    public static final /* synthetic */ void $anonfun$new$28(Long v) {
        SparkSession$.MODULE$.builder().master("local").config(package$.MODULE$.EXECUTOR_ALLOW_SPARK_CONTEXT().key(), true).getOrCreate().stop();
    }

    public static final /* synthetic */ boolean $anonfun$new$36(String msg$1, LogEvent x$5) {
        return x$5.getMessage().getFormattedMessage().contains(msg$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$39(String msg$2, LogEvent x$6) {
        return x$6.getMessage().getFormattedMessage().contains(msg$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$44(String msg$3, LogEvent x$7) {
        return x$7.getMessage().getFormattedMessage().contains(msg$3);
    }

    public SparkSessionBuilderSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        this.test("SPARK-34087: Fix memory leak of ExecutionListenerBus", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession spark = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                spark.cloneSession();
                SparkSession$.MODULE$.clearActiveSession();
            });
            return (Assertion)this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).seconds()), (Function0 & Serializable)() -> {
                System.gc();
                int $org_scalatest_assert_macro_left = SparkSessionBuilderSuite.listenersNum$1(spark);
                int $org_scalatest_assert_macro_right = 11;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("create with config options and propagate them to SparkContext and SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(UI$.MODULE$.UI_ENABLED().key(), false).config("some-config", "v2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.sparkContext().conf().get("some-config");
            String $org_scalatest_assert_macro_right = "v2";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            String $org_scalatest_assert_macro_left2 = session.conf().get("some-config");
            String $org_scalatest_assert_macro_right2 = "v2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("use global default session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = SparkSession$.MODULE$.builder().getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = session;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("sets default and active session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left;
            None$ none$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left2;
            None$ none$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(none$2) : none$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getDefaultSession();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)session);
            Option option3 = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)session);
            Option option4 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option4 != null ? !option4.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("get active or default session", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = SparkSession$.MODULE$.active();
            SparkSession $org_scalatest_assert_macro_right = session;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.active();
            SparkSession $org_scalatest_assert_macro_right2 = session;
            SparkSession sparkSession3 = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession3 != null ? !sparkSession3.equals(sparkSession4) : sparkSession4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            SparkSession$.MODULE$.clearDefaultSession();
            this.intercept((Function0 & Serializable)() -> SparkSession$.MODULE$.active(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            session.stop();
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("config options are propagated to existing SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session1 = SparkSession$.MODULE$.builder().master("local").config("spark-config1", "a").getOrCreate();
            String $org_scalatest_assert_macro_left = session1.conf().get("spark-config1");
            String $org_scalatest_assert_macro_right = "a";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            SparkSession session2 = SparkSession$.MODULE$.builder().config("spark-config1", "b").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left2 = session1;
            SparkSession $org_scalatest_assert_macro_right2 = session2;
            SparkSession sparkSession = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            String $org_scalatest_assert_macro_left3 = session1.conf().get("spark-config1");
            String $org_scalatest_assert_macro_right3 = "b";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("use session from active thread session and propagate config options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession defaultSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession activeSession = defaultSession.newSession();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            SparkSession session = SparkSession$.MODULE$.builder().config("spark-config2", "a").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = activeSession;
            SparkSession $org_scalatest_assert_macro_right = defaultSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            SparkSession $org_scalatest_assert_macro_left2 = session;
            SparkSession $org_scalatest_assert_macro_right2 = activeSession;
            SparkSession sparkSession3 = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession3 != null ? !sparkSession3.equals(sparkSession4) : sparkSession4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            String $org_scalatest_assert_macro_left3 = session.conf().get("spark-config2");
            String $org_scalatest_assert_macro_right3 = "a";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            SQLConf $org_scalatest_assert_macro_left4 = session.sessionState().conf();
            SQLConf $org_scalatest_assert_macro_right4 = SQLConf$.MODULE$.get();
            SQLConf sQLConf = $org_scalatest_assert_macro_left4;
            SQLConf sQLConf2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(sQLConf != null ? !sQLConf.equals(sQLConf2) : sQLConf2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            String $org_scalatest_assert_macro_left5 = SQLConf$.MODULE$.get().getConfString("spark-config2");
            String $org_scalatest_assert_macro_right5 = "a";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession $org_scalatest_assert_macro_left6 = SparkSession$.MODULE$.builder().getOrCreate();
            SparkSession $org_scalatest_assert_macro_right6 = defaultSession;
            SparkSession sparkSession5 = $org_scalatest_assert_macro_left6;
            SparkSession sparkSession6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(sparkSession5 != null ? !sparkSession5.equals(sparkSession6) : sparkSession6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("create a new session if the default session has been stopped", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession newSession;
            SparkSession defaultSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession$.MODULE$.setDefaultSession(defaultSession);
            defaultSession.stop();
            SparkSession $org_scalatest_assert_macro_left = newSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = defaultSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("create a new session if the active thread session has been stopped", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession newSession;
            SparkSession activeSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            activeSession.stop();
            SparkSession $org_scalatest_assert_macro_left = newSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = activeSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("create SparkContext first then SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local").set("key1", "value1");
            SparkContext sparkContext2 = new SparkContext(conf);
            SparkSession session = SparkSession$.MODULE$.builder().config("key2", "value2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.conf().get("key1");
            String $org_scalatest_assert_macro_right = "value1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            String $org_scalatest_assert_macro_left2 = session.conf().get("key2");
            String $org_scalatest_assert_macro_right2 = "value2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            SparkContext $org_scalatest_assert_macro_left3 = session.sparkContext();
            SparkContext $org_scalatest_assert_macro_right3 = sparkContext2;
            SparkContext sparkContext = $org_scalatest_assert_macro_left3;
            SparkContext sparkContext3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkContext != null ? !sparkContext.equals(sparkContext3) : sparkContext3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            SparkConf $org_scalatest_assert_macro_left4 = sparkContext2.conf();
            String $org_scalatest_assert_macro_right4 = "key2";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            String $org_scalatest_assert_macro_left5 = sparkContext2.conf().get("key1");
            String $org_scalatest_assert_macro_right5 = "value1";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("create SparkContext first then pass context to SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local").set("key1", "value1");
            SparkContext newSC = new SparkContext(conf);
            SparkSession session = SparkSession$.MODULE$.builder().sparkContext(newSC).config("key2", "value2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.conf().get("key1");
            String $org_scalatest_assert_macro_right = "value1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            String $org_scalatest_assert_macro_left2 = session.conf().get("key2");
            String $org_scalatest_assert_macro_right2 = "value2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            SparkContext $org_scalatest_assert_macro_left3 = session.sparkContext();
            SparkContext $org_scalatest_assert_macro_right3 = newSC;
            SparkContext sparkContext = $org_scalatest_assert_macro_left3;
            SparkContext sparkContext2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkContext != null ? !sparkContext.equals(sparkContext2) : sparkContext2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            String $org_scalatest_assert_macro_left4 = session.sparkContext().conf().get("key1");
            String $org_scalatest_assert_macro_right4 = "value1";
            String string5 = $org_scalatest_assert_macro_left4;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            SparkConf $org_scalatest_assert_macro_left5 = session.sparkContext().conf();
            String $org_scalatest_assert_macro_right5 = "key2";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            String $org_scalatest_assert_macro_left6 = session.sparkContext().conf().get("spark.app.name");
            String $org_scalatest_assert_macro_right6 = "test";
            String string7 = $org_scalatest_assert_macro_left6;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("SPARK-15887: hive-site.xml should be loaded", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            String $org_scalatest_assert_macro_left = session.sessionState().newHadoopConf().get("hive.in.test");
            String $org_scalatest_assert_macro_right = "true";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            String $org_scalatest_assert_macro_left2 = session.sparkContext().hadoopConfiguration().get("hive.in.test");
            String $org_scalatest_assert_macro_right2 = "true";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("SPARK-15991: Set global Hadoop conf", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            String mySpecialKey = "my.special.key.15991";
            String mySpecialValue = "msv";
            try {
                session.sparkContext().hadoopConfiguration().set(mySpecialKey, mySpecialValue);
                String $org_scalatest_assert_macro_left = session.sessionState().newHadoopConf().get(mySpecialKey);
                String $org_scalatest_assert_macro_right = mySpecialValue;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            }
            finally {
                session.sparkContext().hadoopConfiguration().unset(mySpecialKey);
            }
            return assertion;
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("SPARK-31234: RESET command will not change static sql configs and spark context conf values in SessionState", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31234").config("spark.app.name", "test-app-SPARK-31234").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right = "test-app-SPARK-31234";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31234";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            session.sql("RESET");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(session.conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right3 = "test-app-SPARK-31234";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right4 = "globaltempdb-spark-31234";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("SPARK-31354: SparkContext only register one SparkSession ApplicationEnd listener", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-app-SPARK-31354-1");
            SparkContext context = new SparkContext(conf);
            SparkSession$.MODULE$.builder().sparkContext(context).master("local").getOrCreate();
            int postFirstCreation = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession$.MODULE$.builder().sparkContext(context).master("local").getOrCreate();
            int postSecondCreation = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession$.MODULE$.clearDefaultSession();
            int $org_scalatest_assert_macro_left = postFirstCreation;
            int $org_scalatest_assert_macro_right = postSecondCreation;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("SPARK-31532: should not propagate static sql configs to the existing active/default SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532").config("spark.app.name", "test-app-SPARK-31532").getOrCreate();
            SparkSession session1 = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-1").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session1.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession session2 = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-2").getOrCreate();
            String $org_scalatest_assert_macro_left3 = (String)session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            String $org_scalatest_assert_macro_right3 = "SPARK-31532-db";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
            String $org_scalatest_assert_macro_right4 = (String)session2.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(session2.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right5 = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("SPARK-31532: propagate static sql configs if no existing SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-app-SPARK-31532-2").set(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globaltempdb-spark-31532").set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db");
            SparkContext$.MODULE$.getOrCreate(conf);
            SparkSession session = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-2").config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db-2").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right = "test-app-SPARK-31532-2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31532-2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            String $org_scalatest_assert_macro_left3 = (String)session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            String $org_scalatest_assert_macro_right3 = "SPARK-31532-db-2";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("SPARK-32062: reset listenerRegistered in SparkSession", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-SPARK-32062-" + i);
            SparkContext context = new SparkContext(conf);
            int beforeListenerSize = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.builder().sparkContext(context).getOrCreate();
            int afterListenerSize = context.listenerBus().listeners().size();
            int $org_scalatest_assert_macro_left = beforeListenerSize + 1;
            int $org_scalatest_assert_macro_right = afterListenerSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            context.stop();
        }), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("SPARK-32160: Disallow to create SparkSession in executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String error;
            SparkSession session = SparkSession$.MODULE$.builder().master("local-cluster[3, 1, 1024]").getOrCreate();
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> session.range(1L).foreach((Function1 & Serializable)v -> {
                SparkSessionBuilderSuite.$anonfun$new$26(v);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302))).getMessage();
            String $org_scalatest_assert_macro_right = "SparkSession should only be created and accessed on the driver.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("SPARK-32160: Allow to create SparkSession in executors if the config is set", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local-cluster[3, 1, 1024]").getOrCreate();
            session.range(1L).foreach((Function1 & Serializable)v -> {
                SparkSessionBuilderSuite.$anonfun$new$28(v);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("SPARK-32991: Use conf in shared state as the original configuration for RESET", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String wh = "spark.sql.warehouse.dir";
            String td = "spark.sql.globalTempDatabase";
            String custom = "spark.sql.custom";
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-32991").set(wh, "./data1").set(td, "bob");
            SparkContext sc = new SparkContext(conf);
            SparkSession spark = SparkSession$.MODULE$.builder().config(wh, "./data2").config(td, "alice").config(custom, "kyao").getOrCreate();
            String sharedWH = spark.sharedState().conf().get(wh);
            String sharedTD = spark.sharedState().conf().get(td);
            String $org_scalatest_assert_macro_left = sharedWH;
            String $org_scalatest_assert_macro_right = "data2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The warehouse dir in shared state should be determined by the 1st created spark session", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sharedTD);
            String $org_scalatest_assert_macro_right2 = "alice";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Static sql configs in shared state should be determined by the 1st created spark session", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            Option $org_scalatest_assert_macro_left3 = spark.sharedState().conf().getOption(custom);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Dynamic sql configs is session specific", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            String $org_scalatest_assert_macro_left4 = spark.conf().get(wh);
            String $org_scalatest_assert_macro_right3 = sharedWH;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"The warehouse dir in session conf and shared state conf should be consistent", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right4 = sharedTD;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"Static sql configs in session conf and shared state conf should be consistent", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right5 = "kyao";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"Dynamic sql configs is session specific", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            spark.sql("RESET");
            String $org_scalatest_assert_macro_left7 = spark.conf().get(wh);
            String $org_scalatest_assert_macro_right6 = sharedWH;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"The warehouse dir in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right7 = sharedTD;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"Static sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right8 = "kyao";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"Dynamic sql configs in session initial map should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            SparkSession spark2 = SparkSession$.MODULE$.builder().config(wh, "./data3").config(custom, "kyaoo").getOrCreate();
            String $org_scalatest_assert_macro_left10 = spark2.conf().get(wh);
            String $org_scalatest_assert_macro_right9 = sharedWH;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(spark2.conf().get(td));
            String $org_scalatest_assert_macro_right10 = sharedTD;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right11 = "kyaoo";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("SPARK-32991: RESET should work properly with multi threads", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String wh = "spark.sql.warehouse.dir";
            String td = "spark.sql.globalTempDatabase";
            String custom = "spark.sql.custom";
            SparkSession spark = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 0", false, (Function0 & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config(wh, "./data0").config(td, "bob").config(custom, "c0").getOrCreate());
            spark.sql("SET " + custom + "=c1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right = "c1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            spark.sql("RESET");
            String $org_scalatest_assert_macro_left2 = spark.conf().get(wh);
            String $org_scalatest_assert_macro_right2 = "data0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The warehouse dir in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right3 = "bob";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Static sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right4 = "c0";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Dynamic sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            SparkSession spark1 = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 1", false, (Function0 & Serializable)() -> SparkSession$.MODULE$.builder().getOrCreate());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spark);
            SparkSession $org_scalatest_assert_macro_right5 = spark1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession spark2 = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 2", false, (Function0 & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config(wh, "./data1").config(td, "alice").config(custom, "c2").getOrCreate());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spark2);
            SparkSession $org_scalatest_assert_macro_right6 = spark;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            spark2.sql("SET " + custom + "=c1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right7 = "c1";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
            spark2.sql("RESET");
            String $org_scalatest_assert_macro_left8 = spark2.conf().get(wh);
            String $org_scalatest_assert_macro_right8 = "data1";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spark2.conf().get(td));
            String $org_scalatest_assert_macro_right9 = "alice";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right10 = "c2";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("SPARK-33944: warning setting hive.metastore.warehouse.dir using session options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg = "Not allowing to set hive.metastore.warehouse.dir in SparkSession's options";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config("hive.metastore.warehouse.dir", "any").getOrCreate().sharedState());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$36(msg, x$5))), "logAppender.loggingEvents.exists(((x$5: org.apache.logging.log4j.core.LogEvent) => x$5.getMessage().getFormattedMessage().contains(msg)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("SPARK-33944: no warning setting spark.sql.warehouse.dir using session options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg = "Not allowing to set hive.metastore.warehouse.dir in SparkSession's options";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config("spark.sql.warehouse.dir", "any").getOrCreate().sharedState());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$39(msg, x$6))), "logAppender.loggingEvents.exists(((x$6: org.apache.logging.log4j.core.LogEvent) => x$6.getMessage().getFormattedMessage().contains(msg)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        new .colon.colon((Object)".", (List)new .colon.colon((Object)"..", (List)new .colon.colon((Object)"dir0", (List)new .colon.colon((Object)"dir0/dir1", (List)new .colon.colon((Object)"/dir0/dir1", (List)new .colon.colon((Object)"./dir0", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)pathStr -> {
            this.test("SPARK-34558: warehouse path (" + pathStr + ") should be qualified for spark/hadoop conf", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Path path = new Path(pathStr);
                SparkConf conf = new SparkConf().set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH(), (Object)pathStr);
                SparkSession session = SparkSession$.MODULE$.builder().master("local").config(conf).getOrCreate();
                Configuration hadoopConf = session.sessionState().newHadoopConf();
                String expected = path.getFileSystem(hadoopConf).makeQualified(path).toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(hadoopConf.get("hive.metastore.warehouse.dir"));
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
                String $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(session.sessionState().conf().warehousePath());
                String $org_scalatest_assert_macro_right3 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(session.sharedState().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
                String $org_scalatest_assert_macro_right4 = expected;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(session.sharedState().hadoopConf().get("hive.metastore.warehouse.dir"));
                String $org_scalatest_assert_macro_right5 = expected;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(session.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
                String $org_scalatest_assert_macro_right6 = expected;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(session.sparkContext().hadoopConfiguration().get("hive.metastore.warehouse.dir"));
                String $org_scalatest_assert_macro_right7 = expected;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-34558: Create a working SparkSession with a broken FileSystem", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg = "Cannot qualify the warehouse path, leaving it unqualified";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "unknown:///mydir").getOrCreate();
                session.sql("SELECT 1").collect();
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$44(msg, x$7))), "logAppender.loggingEvents.exists(((x$7: org.apache.logging.log4j.core.LogEvent) => x$7.getMessage().getFormattedMessage().contains(msg)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("SPARK-37727: Show ignored configurations in debug level logs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, this.LogAppender().$lessinit$greater$default$1(), this.LogAppender().$lessinit$greater$default$2());
            logAppender.setThreshold(Level.DEBUG);
            SparkFunSuite.LogAppender x$1 = logAppender;
            Some x$2 = new Some((Object)Level.DEBUG);
            Seq x$3 = this.withLogAppender$default$2();
            JFunction0.mcV.sp & Serializable x$4 = (JFunction0.mcV.sp & Serializable)() -> SparkSession$.MODULE$.builder().config("spark.sql.warehouse.dir", "2").config("spark.abc", "abcb").config("spark.abcd", "abcb4").getOrCreate();
            this.withLogAppender((AbstractAppender)x$1, x$3, (Option)x$2, (Function0)x$4);
            ArrayBuffer logs = (ArrayBuffer)logAppender.loggingEvents().map((Function1 & Serializable)x$8 -> x$8.getMessage().getFormattedMessage());
            new .colon.colon((Object)"Ignored static SQL configurations", (List)new .colon.colon((Object)"spark.sql.warehouse.dir=2", (List)new .colon.colon((Object)"Configurations that might not take effect", (List)new .colon.colon((Object)"spark.abcd=abcb4", (List)new .colon.colon((Object)"spark.abc=abcb", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)msg -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.contains(msg))), "logs.exists(((x$9: String) => x$9.contains(msg)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)(msg + " did not exist in:\n" + logs.mkString("\n")), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
            });
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("SPARK-37727: Hide the same configuration already explicitly set in logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession$.MODULE$.builder().master("local").config("spark.abc", "abc").getOrCreate();
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, this.LogAppender().$lessinit$greater$default$1(), this.LogAppender().$lessinit$greater$default$2());
            logAppender.setThreshold(Level.DEBUG);
            SparkFunSuite.LogAppender x$5 = logAppender;
            Some x$6 = new Some((Object)Level.DEBUG);
            Seq x$7 = this.withLogAppender$default$2();
            JFunction0.mcV.sp & Serializable x$8 = (JFunction0.mcV.sp & Serializable)() -> {
                SparkSession$.MODULE$.builder().config("spark.abc", "abc").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.abc.new", "abc").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.abc.new", "abc").getOrCreate();
            };
            this.withLogAppender((AbstractAppender)x$5, x$7, (Option)x$6, (Function0)x$8);
            ArrayBuffer logs = (ArrayBuffer)logAppender.loggingEvents().map((Function1 & Serializable)x$10 -> x$10.getMessage().getFormattedMessage());
            new .colon.colon((Object)"Using an existing Spark session; only runtime SQL configurations will take effect", (List)new .colon.colon((Object)"Configurations that might not take effect", (List)new .colon.colon((Object)"spark.abc.new=abc", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)msg -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.contains(msg))), "logs.exists(((x$11: String) => x$11.contains(msg)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)(msg + " did not exist in:\n" + logs.mkString("\n")), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains("spark.abc=abc"))), "logs.exists(((x$12: String) => x$12.contains(\"spark.abc=abc\")))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("'spark.abc=abc' existed in:\n" + logs.mkString("\n")), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        this.test("SPARK-37727: Hide runtime SQL configurations in logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, this.LogAppender().$lessinit$greater$default$1(), this.LogAppender().$lessinit$greater$default$2());
            logAppender.setThreshold(Level.DEBUG);
            SparkFunSuite.LogAppender x$9 = logAppender;
            Some x$10 = new Some((Object)Level.DEBUG);
            Seq x$11 = this.withLogAppender$default$2();
            JFunction0.mcV.sp & Serializable x$12 = (JFunction0.mcV.sp & Serializable)() -> {
                SparkSession$.MODULE$.builder().config("spark.sql.ansi.enabled", "true").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.buffer.size", "1234").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.sql.source.abc", "abc").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.sql.warehouse.dir", "xyz").getOrCreate();
            };
            this.withLogAppender((AbstractAppender)x$9, x$11, (Option)x$10, (Function0)x$12);
            ArrayBuffer logs = (ArrayBuffer)logAppender.loggingEvents().map((Function1 & Serializable)x$13 -> x$13.getMessage().getFormattedMessage());
            new .colon.colon((Object)"spark.buffer.size=1234", (List)new .colon.colon((Object)"spark.sql.source.abc=abc", (List)new .colon.colon((Object)"spark.sql.warehouse.dir=xyz", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)msg -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.contains(msg))), "logs.exists(((x$14: String) => x$14.contains(msg)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)(msg + " did not exist in:\n" + logs.mkString("\n")), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.contains("spark.sql.ansi.enabled\""))), "logs.exists(((x$15: String) => x$15.contains(\"spark.sql.ansi.enabled\\\"\")))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("'spark.sql.ansi.enabled' existed in:\n" + logs.mkString("\n")), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("SPARK-40163: SparkSession.config(Map)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"boolean"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"double"), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"long"), (Object)BoxesRunTime.boxToLong((long)0L))}));
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(map).getOrCreate();
            map.foreach((Function1 & Serializable)e -> {
                String $org_scalatest_assert_macro_left = session.conf().get((String)e._1());
                String $org_scalatest_assert_macro_right = e._2().toString();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            });
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        Statics.releaseFence();
    }
}

