/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.ExtendedAnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.columnar.CachedRDDBuilder;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tmf!\u0002\u0014(\u0003\u0003\u0001\u0004\"B\u001f\u0001\t\u0003q\u0004\"\u0002\u0016\u0001\r#\t\u0005\"B#\u0001\t\u00031\u0005\"\u00024\u0001\t\u00039\u0007\"\u00026\u0001\t#Y\u0007bBA\u0004\u0001\u0011E\u0011\u0011\u0002\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t9\u0005\u0001C\t\u0003\u0013Bq!a\u0012\u0001\t#\ti\u0006C\u0004\u0002H\u0001!\t\"a\u0019\t\u000f\u0005%\u0004\u0001\"\u0005\u0002l!9\u0011\u0011\u000e\u0001\u0005\u0012\u0005u\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\n\u0003C\u0003\u0011\u0013!C\u0001\u0003GCq!!\"\u0001\t\u0003\tI\fC\u0004\u0002\\\u0002!\t!!8\t\u000f\u0005-\b\u0001\"\u0005\u0002n\"9\u0011q\u001e\u0001\u0005\u0012\u0005E\b\"CA|\u0001E\u0005I\u0011CAR\u000f\u001d\tIp\nE\u0001\u0003w4aAJ\u0014\t\u0002\u0005u\bBB\u001f\u0016\t\u0003\u0011\t\u0003C\u0004\u0002HU!\tAa\t\t\u0013\tMR#%A\u0005\u0002\tU\u0002b\u0002B\u001d+\u0011\u0005!1\b\u0005\n\u0005\u0013*\u0012\u0013!C\u0001\u0005kAqAa\u0013\u0016\t\u0003\u0011i\u0005C\u0004\u0003XU!\tA!\u0017\t\u000f\t}S\u0003\"\u0003\u0003b!I!1N\u000b\u0012\u0002\u0013%!Q\u0007\u0005\b\u0005[*B\u0011\u0001B8\u0011\u001d\u00119(\u0006C\u0001\u0005sBqAa!\u0016\t\u0003\u0011)\tC\u0005\u0003\u000eV\t\n\u0011\"\u0001\u00036!9\u0011\u0011N\u000b\u0005\u0012\t=\u0005bBA$+\u0011\u0005!\u0011\u0014\u0005\n\u0005W+\u0012\u0011!C\u0005\u0005[\u0013\u0011\"U;fef$Vm\u001d;\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tT\u0007\u0005\u00023g5\t\u0011&\u0003\u00025S\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000bAd\u0017M\\:\u000b\u0005i:\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005q:$\u0001\u0003)mC:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005y\u0004C\u0001!\u0001\u001b\u00059S#\u0001\"\u0011\u0005\u0001\u001b\u0015B\u0001#(\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003I\u0019\u0007.Z2l\u0017\u0016Lxo\u001c:eg\u0016C\u0018n\u001d;\u0015\u0007\u001dke\u000b\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0003V]&$\b\"\u0002(\u0004\u0001\u0004y\u0015A\u00013g!\t\u00016K\u0004\u0002A#&\u0011!kJ\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0005ECR\fgI]1nK*\u0011!k\n\u0005\u0006/\u000e\u0001\r\u0001W\u0001\tW\u0016Lxo\u001c:egB\u0019\u0001*W.\n\u0005iK%A\u0003\u001fsKB,\u0017\r^3e}A\u0011Al\u0019\b\u0003;\u0006\u0004\"AX%\u000e\u0003}S!\u0001Y\u0018\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0017*\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012J\u0003U\u0019\u0007.Z2l\u0017\u0016Lxo\u001c:eg:{G/\u0012=jgR$2a\u00125j\u0011\u0015qE\u00011\u0001P\u0011\u00159F\u00011\u0001Y\u00031\u0019\u0007.Z2l\t\u0006$\u0018m]3u+\taw\u000f\u0006\u0003H[\u0006\u0005\u0001B\u00028\u0006\t\u0003\u0007q.\u0001\u0002egB\u0019\u0001\n\u001d:\n\u0005EL%\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007\u0001\u001bX/\u0003\u0002uO\t9A)\u0019;bg\u0016$\bC\u0001<x\u0019\u0001!Q\u0001_\u0003C\u0002e\u0014\u0011\u0001V\t\u0003uv\u0004\"\u0001S>\n\u0005qL%a\u0002(pi\"Lgn\u001a\t\u0003\u0011zL!a`%\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0004\u0015\u0001\r!!\u0002\u0002\u001d\u0015D\b/Z2uK\u0012\fen]<feB\u0019\u0001*W;\u0002+\rDWmY6ECR\f7/\u001a;V]>\u0014H-\u001a:msV!\u00111BA\u0013)\u0019\ti!a\n\u0002.Q\u0019q)a\u0004\t\u0013\u0005Ea!!AA\u0004\u0005M\u0011AC3wS\u0012,gnY3%cA1\u0011QCA\u000f\u0003GqA!a\u0006\u0002\u001c9\u0019a,!\u0007\n\u0003)K!AU%\n\t\u0005}\u0011\u0011\u0005\u0002\t\u001fJ$WM]5oO*\u0011!+\u0013\t\u0004m\u0006\u0015B!\u0002=\u0007\u0005\u0004I\bb\u00028\u0007\t\u0003\u0007\u0011\u0011\u0006\t\u0005\u0011B\fY\u0003\u0005\u0003Ag\u0006\r\u0002bBA\u0002\r\u0001\u0007\u0011q\u0006\t\u0005\u0011f\u000b\u0019#A\u0005hKR\u0014Vm];miV!\u0011QGA )\u0011\t9$!\u0011\u0011\u000b!\u000bI$!\u0010\n\u0007\u0005m\u0012JA\u0003BeJ\f\u0017\u0010E\u0002w\u0003\u007f!Q\u0001_\u0004C\u0002eDqA\\\u0004\u0005\u0002\u0004\t\u0019\u0005\u0005\u0003Ia\u0006\u0015\u0003\u0003\u0002!t\u0003{\t1b\u00195fG.\fen]<feR)q)a\u0013\u0002P!9a\n\u0003CA\u0002\u00055\u0003c\u0001%q\u001f\"9\u00111\u0001\u0005A\u0002\u0005E\u0003CBA\u000b\u0003'\n9&\u0003\u0003\u0002V\u0005\u0005\"aA*fcB\u0019\u0001)!\u0017\n\u0007\u0005msEA\u0002S_^$RaRA0\u0003CBqAT\u0005\u0005\u0002\u0004\ti\u0005C\u0004\u0002\u0004%\u0001\r!a\u0016\u0015\u000b\u001d\u000b)'a\u001a\t\u000f9SA\u00111\u0001\u0002N!1\u00111\u0001\u0006A\u0002=\u000bac\u00195fG.\fum\u001a:fO\u0006$Xm],ji\"$v\u000e\u001c\u000b\b\u000f\u00065\u0014\u0011OA:\u0011\u0019\tyg\u0003a\u0001\u001f\u0006IA-\u0019;b\rJ\fW.\u001a\u0005\b\u0003\u0007Y\u0001\u0019AA)\u0011\u001d\t)h\u0003a\u0001\u0003o\na!\u00192t)>d\u0007c\u0001%\u0002z%\u0019\u00111P%\u0003\r\u0011{WO\u00197f)\u001d9\u0015qPAA\u0003\u0007Ca!a\u001c\r\u0001\u0004y\u0005bBA\u0002\u0019\u0001\u0007\u0011q\u000b\u0005\b\u0003kb\u0001\u0019AA<\u00031\t7o]3si\u000e\u000b7\r[3e)\u00159\u0015\u0011RAL\u0011\u001d\tY)\u0004a\u0001\u0003\u001b\u000bQ!];fef\u0004D!a$\u0002\u0014B!\u0001i]AI!\r1\u00181\u0013\u0003\f\u0003+\u000bI)!A\u0001\u0002\u000b\u0005\u0011PA\u0002`IEB\u0011\"!'\u000e!\u0003\u0005\r!a'\u0002\u001f9,XnQ1dQ\u0016$G+\u00192mKN\u00042\u0001SAO\u0013\r\ty*\u0013\u0002\u0004\u0013:$\u0018AF1tg\u0016\u0014HoQ1dQ\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015&\u0006BAN\u0003O[#!!+\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003gK\u0015AC1o]>$\u0018\r^5p]&!\u0011qWAW\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\b\u000f\u0006m\u0016qYAf\u0011\u001d\tYi\u0004a\u0001\u0003{\u0003D!a0\u0002DB!\u0001i]Aa!\r1\u00181\u0019\u0003\f\u0003\u000b\fY,!A\u0001\u0002\u000b\u0005\u0011PA\u0002`IIBa!!3\u0010\u0001\u0004Y\u0016AC2bG\",GMT1nK\"9\u0011QZ\bA\u0002\u0005=\u0017\u0001D:u_J\fw-\u001a'fm\u0016d\u0007\u0003BAi\u0003/l!!a5\u000b\u0007\u0005U\u0017&A\u0004ti>\u0014\u0018mZ3\n\t\u0005e\u00171\u001b\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0001\u0018CN\u001cXM\u001d;F[B$\u00180T5tg&tw-\u00138qkR$2aRAp\u0011\u001d\tY\t\u0005a\u0001\u0003C\u0004D!a9\u0002hB!\u0001i]As!\r1\u0018q\u001d\u0003\f\u0003S\fy.!A\u0001\u0002\u000b\u0005\u0011PA\u0002`IM\nadZ3u\u0007V\u0014(/\u001a8u\u00072\f7o]\"bY2\u001c\u0016\u000e^3QCR$XM\u001d8\u0016\u0003m\u000b!dZ3u\u001d\u0016DH\u000fT5oK\u000e\u000bG\u000e\\*ji\u0016\u0004\u0016\r\u001e;fe:$2aWAz\u0011%\t)P\u0005I\u0001\u0002\u0004\tY*A\u0003mS:,7/\u0001\u0013hKRtU\r\u001f;MS:,7)\u00197m'&$X\rU1ui\u0016\u0014h\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002A+M9Q#a@\u0003\u0006\tE\u0001c\u0001%\u0003\u0002%\u0019!1A%\u0003\r\u0005s\u0017PU3g!\u0011\u00119A!\u0004\u000e\u0005\t%!b\u0001B\u0006[\u0005I1oY1mCR,7\u000f^\u0005\u0005\u0005\u001f\u0011IA\u0001\u0006BgN,'\u000f^5p]N\u0004BAa\u0005\u0003\u001e5\u0011!Q\u0003\u0006\u0005\u0005/\u0011I\"\u0001\u0002j_*\u0011!1D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003 \tU!\u0001D*fe&\fG.\u001b>bE2,GCAA~)\u001d9%Q\u0005B\u0014\u0005SAQAT\fA\u0002=Cq!a\u0001\u0018\u0001\u0004\t\t\u0006C\u0005\u0003,]\u0001\n\u00111\u0001\u0003.\u0005Q1\r[3dWR{'\u000b\u0012#\u0011\u0007!\u0013y#C\u0002\u00032%\u0013qAQ8pY\u0016\fg.A\u000bdQ\u0016\u001c7.\u00118to\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t]\"\u0006\u0002B\u0017\u0003O\u000bAdZ3u\u000bJ\u0014xN]'fgN\fw-Z%o\u0007\",7m[!og^,'\u000f\u0006\u0005\u0003>\t\r#Q\tB$!\u0011A%qH.\n\u0007\t\u0005\u0013J\u0001\u0004PaRLwN\u001c\u0005\u0006\u001df\u0001\ra\u0014\u0005\b\u0003\u0007I\u0002\u0019AA)\u0011%\u0011Y#\u0007I\u0001\u0002\u0004\u0011i#\u0001\u0014hKR,%O]8s\u001b\u0016\u001c8/Y4f\u0013:\u001c\u0005.Z2l\u0003:\u001cx/\u001a:%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:fa\u0006\u0014X-\u00118to\u0016\u0014HCBA)\u0005\u001f\u0012\u0019\u0006C\u0004\u0003Rm\u0001\r!!\u0015\u0002\r\u0005t7o^3s\u0011\u001d\u0011)f\u0007a\u0001\u0005[\t\u0001\"[:T_J$X\rZ\u0001\u000baJ,\u0007/\u0019:f%><H\u0003BA,\u00057BqA!\u0018\u001d\u0001\u0004\t9&A\u0002s_^\f\u0001bZ3o\u000bJ\u0014xN\u001d\u000b\b7\n\r$Q\rB5\u0011\u001d\t\u0019!\ba\u0001\u0003#BqAa\u001a\u001e\u0001\u0004\t\t&A\u0006ta\u0006\u00148.\u00118to\u0016\u0014\b\"\u0003B+;A\u0005\t\u0019\u0001B\u0017\u0003I9WM\\#se>\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019%t7\r\\;eKN\u0014vn^:\u0015\r\tu\"\u0011\u000fB;\u0011\u001d\u0011\u0019h\ba\u0001\u0003#\nA\"\u001a=qK\u000e$X\r\u001a*poNDqAa\u001a \u0001\u0004\t\t&A\u0004d_6\u0004\u0018M]3\u0015\r\t5\"1\u0010B@\u0011\u0019\u0011i\b\ta\u0001{\u0006!qN\u001962\u0011\u0019\u0011\t\t\ta\u0001{\u0006!qN\u001963\u0003!\u0019\u0018-\\3S_^\u001cH\u0003\u0003B\u001f\u0005\u000f\u0013IIa#\t\u000f\u0005\r\u0011\u00051\u0001\u0002R!9!qM\u0011A\u0002\u0005E\u0003\"\u0003B+CA\u0005\t\u0019\u0001B\u0017\u0003I\u0019\u0018-\\3S_^\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0015\u000f\u001d\u0013\tJ!&\u0003\u0018\"9!1S\u0012A\u0002\u0005]\u0013\u0001D1diV\fG.\u00118to\u0016\u0014\bbBA\u0002G\u0001\u0007\u0011q\u000b\u0005\b\u0003k\u001a\u0003\u0019AA<)\u00159%1\u0014BO\u0011\u0015qE\u00051\u0001P\u0011\u001d\t\u0019\u0001\na\u0001\u0005?\u0003bA!)\u0003(\u0006]SB\u0001BR\u0015\u0011\u0011)K!\u0007\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005S\u0013\u0019K\u0001\u0003MSN$\u0018\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BX!\u0011\u0011\tLa.\u000e\u0005\tM&\u0002\u0002B[\u00053\tA\u0001\\1oO&!!\u0011\u0018BZ\u0005\u0019y%M[3di\u0002")
public abstract class QueryTest
extends SparkFunSuite
implements PlanTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public static boolean sameRows$default$3() {
        return QueryTest$.MODULE$.sameRows$default$3();
    }

    public static Option<String> sameRows(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        return QueryTest$.MODULE$.sameRows(expectedAnswer, sparkAnswer, isSorted);
    }

    public static boolean compare(Object obj1, Object obj2) {
        return QueryTest$.MODULE$.compare(obj1, obj2);
    }

    public static Option<String> includesRows(Seq<Row> expectedRows, Seq<Row> sparkAnswer) {
        return QueryTest$.MODULE$.includesRows(expectedRows, sparkAnswer);
    }

    public static Row prepareRow(Row row) {
        return QueryTest$.MODULE$.prepareRow(row);
    }

    public static Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        return QueryTest$.MODULE$.prepareAnswer(answer, isSorted);
    }

    public static boolean getErrorMessageInCheckAnswer$default$3() {
        return QueryTest$.MODULE$.getErrorMessageInCheckAnswer$default$3();
    }

    public static Option<String> getErrorMessageInCheckAnswer(Dataset<Row> df, Seq<Row> expectedAnswer, boolean checkToRDD) {
        return QueryTest$.MODULE$.getErrorMessageInCheckAnswer(df, expectedAnswer, checkToRDD);
    }

    public static boolean checkAnswer$default$3() {
        return QueryTest$.MODULE$.checkAnswer$default$3();
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        QueryTest queryTest = this;
        synchronized (queryTest) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public abstract SparkSession spark();

    public void checkKeywordsExist(Dataset<Row> df, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$1 -> x$1.mkString(), ClassTag$.MODULE$.apply(String.class))).mkString();
        keywords.foreach((Function1 & Serializable)key -> {
            String $org_scalatest_assert_macro_left = outputs;
            String $org_scalatest_assert_macro_right = key;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Failed for " + df + " (" + key + " doesn't exist in result)"), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        });
    }

    public void checkKeywordsNotExist(Dataset<Row> df, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$2 -> x$2.mkString(), ClassTag$.MODULE$.apply(String.class))).mkString();
        keywords.foreach((Function1 & Serializable)key -> {
            String $org_scalatest_assert_macro_left = outputs;
            String $org_scalatest_assert_macro_right = key;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Failed for " + df + " (" + key + " existed in the result)"), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        });
    }

    public <T> void checkDataset(Function0<Dataset<T>> ds, Seq<T> expectedAnswer) {
        Object result = this.getResult(ds);
        if (!QueryTest$.MODULE$.compare(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)), expectedAnswer)) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |Decoded objects do not match expected objects:\n           |expected: " + expectedAnswer + "\n           |actual:   " + ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)) + "\n           |" + ((Dataset)ds.apply()).exprEnc().deserializer().treeString() + "\n         ")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }
    }

    public <T> void checkDatasetUnorderly(Function0<Dataset<T>> ds, Seq<T> expectedAnswer, Ordering<T> evidence$1) {
        Object result = this.getResult(ds);
        if (!QueryTest$.MODULE$.compare(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)).sorted(evidence$1), expectedAnswer.sorted(evidence$1))) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |Decoded objects do not match expected objects:\n           |expected: " + expectedAnswer + "\n           |actual:   " + ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)) + "\n           |" + ((Dataset)ds.apply()).exprEnc().deserializer().treeString() + "\n         ")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }
    }

    private <T> Object getResult(Function0<Dataset<T>> ds) {
        Object object;
        Dataset dataset;
        try {
            dataset = (Dataset)ds.apply();
        }
        catch (ExtendedAnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |Failed to analyze query: " + ae + "\n               |" + ae.plan().get() + "\n               |\n               |" + package$.MODULE$.stackTraceToString((Throwable)ae) + "\n             ")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            }
            throw ae;
        }
        Dataset analyzedDS = dataset;
        this.assertEmptyMissingInput(analyzedDS);
        try {
            object = ((Dataset)ds.apply()).collect();
        }
        catch (Exception e) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |Exception collecting dataset as objects\n             |" + ((Dataset)ds.apply()).exprEnc() + "\n             |" + ((Dataset)ds.apply()).exprEnc().deserializer().treeString() + "\n             |" + ((Dataset)ds.apply()).queryExecution() + "\n           ")), e, new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }
        return object;
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Seq<Row> expectedAnswer) {
        Dataset dataset;
        try {
            dataset = (Dataset)df.apply();
        }
        catch (ExtendedAnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |Failed to analyze query: " + ae + "\n               |" + ae.plan().get() + "\n               |\n               |" + package$.MODULE$.stackTraceToString((Throwable)ae) + "\n               |")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            }
            throw ae;
        }
        Dataset analyzedDF = dataset;
        this.assertEmptyMissingInput(analyzedDF);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)analyzedDF, expectedAnswer, QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Row expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)new .colon.colon((Object)expectedAnswer, (List)Nil$.MODULE$));
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Dataset<Row> expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(expectedAnswer.collect()));
    }

    public void checkAggregatesWithTol(Dataset<Row> dataFrame, Seq<Row> expectedAnswer, double absTol) {
        Row[] actualAnswer = (Row[])dataFrame.collect();
        Predef$.MODULE$.require(actualAnswer.length == expectedAnswer.length(), (Function0 & Serializable)() -> "actual num rows " + actualAnswer.length + " != expected num of rows " + expectedAnswer.length());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])actualAnswer), expectedAnswer)), (Function1 & Serializable)x0$1 -> {
            QueryTest.$anonfun$checkAggregatesWithTol$2(absTol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void checkAggregatesWithTol(Dataset<Row> dataFrame, Row expectedAnswer, double absTol) {
        this.checkAggregatesWithTol(dataFrame, (Seq<Row>)new .colon.colon((Object)expectedAnswer, (List)Nil$.MODULE$), absTol);
    }

    public void assertCached(Dataset<?> query, int numCachedTables) {
        Seq cachedData;
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        Seq $org_scalatest_assert_macro_left = cachedData = planWithCaching.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InMemoryRelation) {
                    InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                    return (B1)inMemoryRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof InMemoryRelation;
            }
        });
        int $org_scalatest_assert_macro_right = numCachedTables;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected query to contain " + numCachedTables + ", but it actually had " + cachedData.size() + "\n" + planWithCaching), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
    }

    public void assertCached(Dataset<?> query, String cachedName, StorageLevel storageLevel) {
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        boolean matched = planWithCaching.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QueryTest.$anonfun$assertCached$1(cachedName, storageLevel, x0$1)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(matched, "matched", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected query plan to hit cache " + cachedName + " with storage level " + storageLevel + ", but it doesn't."), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
    }

    public int assertCached$default$2() {
        return 1;
    }

    public void assertEmptyMissingInput(Dataset<?> query) {
        AttributeSet $org_scalatest_assert_macro_left = query.queryExecution().analyzed().missingInput();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("The analyzed logical plan has missing inputs:\n" + query.queryExecution().analyzed()), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        AttributeSet $org_scalatest_assert_macro_left2 = query.queryExecution().optimizedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("The optimized logical plan has missing inputs:\n" + query.queryExecution().optimizedPlan()), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        AttributeSet $org_scalatest_assert_macro_left3 = query.queryExecution().executedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)("The physical plan has missing inputs:\n" + query.queryExecution().executedPlan()), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
    }

    public String getCurrentClassCallSitePattern() {
        StackTraceElement cs = Thread.currentThread().getStackTrace()[2];
        return cs.getClassName() + "\\..*\\(" + cs.getFileName() + ":\\d+\\)";
    }

    public String getNextLineCallSitePattern(int lines) {
        StackTraceElement cs = Thread.currentThread().getStackTrace()[2];
        return Pattern.quote(cs.getClassName() + "." + cs.getMethodName() + "(" + cs.getFileName() + ":" + (cs.getLineNumber() + lines) + ")");
    }

    public int getNextLineCallSitePattern$default$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$checkAggregatesWithTol$2(double absTol$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Row actualRow = (Row)tuple2._1();
            Row expectedRow = (Row)tuple2._2();
            QueryTest$.MODULE$.checkAggregatesWithTol(actualRow, expectedRow, absTol$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$assertCached$1(String cachedName$1, StorageLevel storageLevel$1, LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        if (!(logicalPlan instanceof InMemoryRelation)) return false;
        InMemoryRelation inMemoryRelation = (InMemoryRelation)logicalPlan;
        CachedRDDBuilder cacheBuilder = inMemoryRelation.cacheBuilder();
        String string = cachedName$1;
        Object object = cacheBuilder.tableName().get();
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        StorageLevel storageLevel = storageLevel$1;
        StorageLevel storageLevel2 = cacheBuilder.storageLevel();
        if (storageLevel == null) {
            if (storageLevel2 == null) return true;
            return false;
        } else {
            if (!storageLevel.equals(storageLevel2)) return false;
            return true;
        }
    }

    public QueryTest() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
    }
}

