/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.TestUtils$;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.api.python.PythonFunction;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.SimplePythonFunction;
import org.apache.spark.sql.IntegratedUDFTestUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.python.UserDefinedPythonDataSource;
import org.apache.spark.sql.execution.python.UserDefinedPythonTableFunction;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;
import scala.util.Try$;

public final class IntegratedUDFTestUtils$
implements SQLHelper {
    public static final IntegratedUDFTestUtils$ MODULE$ = new IntegratedUDFTestUtils$();
    private static String pythonPath;
    private static Path sourcePath;
    private static Path py4jPath;
    private static String pysparkPythonPath;
    private static boolean isPythonAvailable;
    private static boolean isPySparkAvailable;
    private static boolean isPandasAvailable;
    private static boolean isPyArrowAvailable;
    private static String pythonVer;
    private static String pandasVer;
    private static String pyarrowVer;
    private static byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc;
    private static byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc;
    private static byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pandasGroupedAggFunc;
    private static String pythonExec;
    private static boolean shouldTestPythonUDFs;
    private static boolean shouldTestPandasUDFs;
    private static final HashMap<String, String> org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv;
    private static String sparkHome;
    private static volatile int bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv = new HashMap();
        MODULE$.org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv().put("PYTHONPATH", MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath());
    }

    public void withSQLConf(scala.collection.immutable.Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x20000) == 0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 |= 0x20000;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if ((bitmap$0 & 0x20000) == 0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private String pythonPath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 1) == 0) {
                pythonPath = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> "");
                bitmap$0 |= 1;
            }
        }
        return pythonPath;
    }

    public String pythonPath() {
        if ((bitmap$0 & 1) == 0) {
            return this.pythonPath$lzycompute();
        }
        return pythonPath;
    }

    private Path sourcePath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 2) == 0) {
                sourcePath = Paths.get(this.sparkHome(), "python").toAbsolutePath();
                bitmap$0 |= 2;
            }
        }
        return sourcePath;
    }

    private Path sourcePath() {
        if ((bitmap$0 & 2) == 0) {
            return this.sourcePath$lzycompute();
        }
        return sourcePath;
    }

    private Path py4jPath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 4) == 0) {
                py4jPath = Paths.get(this.sparkHome(), "python", "lib", PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toAbsolutePath();
                bitmap$0 |= 4;
            }
        }
        return py4jPath;
    }

    private Path py4jPath() {
        if ((bitmap$0 & 4) == 0) {
            return this.py4jPath$lzycompute();
        }
        return py4jPath;
    }

    private String pysparkPythonPath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 8) == 0) {
                pysparkPythonPath = this.py4jPath() + ":" + this.sourcePath();
                bitmap$0 |= 8;
            }
        }
        return pysparkPythonPath;
    }

    public String pysparkPythonPath() {
        if ((bitmap$0 & 8) == 0) {
            return this.pysparkPythonPath$lzycompute();
        }
        return pysparkPythonPath;
    }

    private boolean isPythonAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x10) == 0) {
                isPythonAvailable = TestUtils$.MODULE$.testCommandAvailable(this.pythonExec());
                bitmap$0 |= 0x10;
            }
        }
        return isPythonAvailable;
    }

    private boolean isPythonAvailable() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.isPythonAvailable$lzycompute();
        }
        return isPythonAvailable;
    }

    private boolean isPySparkAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x20) == 0) {
                isPySparkAvailable = this.isPythonAvailable() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"import pyspark", (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
                    return true;
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                bitmap$0 |= 0x20;
            }
        }
        return isPySparkAvailable;
    }

    private boolean isPySparkAvailable() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.isPySparkAvailable$lzycompute();
        }
        return isPySparkAvailable;
    }

    private boolean isPandasAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x40) == 0) {
                isPandasAvailable = this.isPythonAvailable() && this.isPySparkAvailable() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"from pyspark.sql.pandas.utils import require_minimum_pandas_version;require_minimum_pandas_version()", (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
                    return true;
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                bitmap$0 |= 0x40;
            }
        }
        return isPandasAvailable;
    }

    private boolean isPandasAvailable() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.isPandasAvailable$lzycompute();
        }
        return isPandasAvailable;
    }

    private boolean isPyArrowAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x80) == 0) {
                isPyArrowAvailable = this.isPythonAvailable() && this.isPySparkAvailable() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"from pyspark.sql.pandas.utils import require_minimum_pyarrow_version;require_minimum_pyarrow_version()", (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
                    return true;
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                bitmap$0 |= 0x80;
            }
        }
        return isPyArrowAvailable;
    }

    private boolean isPyArrowAvailable() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.isPyArrowAvailable$lzycompute();
        }
        return isPyArrowAvailable;
    }

    private String pythonVer$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x100) == 0) {
                if (!this.isPythonAvailable()) {
                    throw new RuntimeException("Python executable [" + this.pythonExec() + "] is unavailable.");
                }
                pythonVer = Process$.MODULE$.apply((Seq)new .colon.colon((Object)this.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"import sys; print('%d.%d' % sys.version_info[:2])", (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(this.pysparkPythonPath() + ":" + this.pythonPath()))})).$bang$bang().trim();
                bitmap$0 |= 0x100;
            }
        }
        return pythonVer;
    }

    public String pythonVer() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.pythonVer$lzycompute();
        }
        return pythonVer;
    }

    private String pandasVer$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x200) == 0) {
                if (!this.isPandasAvailable()) {
                    throw new RuntimeException("Pandas is unavailable.");
                }
                pandasVer = Process$.MODULE$.apply((Seq)new .colon.colon((Object)this.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"import pandas; print(pandas.__version__)", (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(this.pysparkPythonPath() + ":" + this.pythonPath()))})).$bang$bang().trim();
                bitmap$0 |= 0x200;
            }
        }
        return pandasVer;
    }

    public String pandasVer() {
        if ((bitmap$0 & 0x200) == 0) {
            return this.pandasVer$lzycompute();
        }
        return pandasVer;
    }

    private String pyarrowVer$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x400) == 0) {
                if (!this.isPyArrowAvailable()) {
                    throw new RuntimeException("PyArrow is unavailable.");
                }
                pyarrowVer = Process$.MODULE$.apply((Seq)new .colon.colon((Object)this.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"import pyarrow; print(pyarrow.__version__)", (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(this.pysparkPythonPath() + ":" + this.pythonPath()))})).$bang$bang().trim();
                bitmap$0 |= 0x400;
            }
        }
        return pyarrowVer;
    }

    public String pyarrowVer() {
        if ((bitmap$0 & 0x400) == 0) {
            return this.pyarrowVer$lzycompute();
        }
        return pyarrowVer;
    }

    private byte[] pythonFunc$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x800) == 0) {
                if (!this.shouldTestPythonUDFs()) {
                    throw new RuntimeException("Python executable [" + this.pythonExec() + "] and/or pyspark are unavailable.");
                }
                ObjectRef binaryPythonFunc = ObjectRef.create(null);
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
                    IntegratedUDFTestUtils$.$anonfun$pythonFunc$1(binaryPythonFunc, path);
                    return BoxedUnit.UNIT;
                });
                byte[] $org_scalatest_assert_macro_left = (byte[])binaryPythonFunc.elem;
                Object $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
                org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc = (byte[])binaryPythonFunc.elem;
                bitmap$0 |= 0x800;
            }
        }
        return org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc;
    }

    public byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc() {
        if ((bitmap$0 & 0x800) == 0) {
            return this.pythonFunc$lzycompute();
        }
        return org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc;
    }

    private byte[] createPythonUDTF(String funcName, String pythonScript) {
        if (!this.shouldTestPythonUDFs()) {
            throw new RuntimeException("Python executable [" + this.pythonExec() + "] and/or pyspark are unavailable.");
        }
        ObjectRef binaryPythonUDTF = ObjectRef.create(null);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)codePath -> {
            IntegratedUDFTestUtils$.$anonfun$createPythonUDTF$1(pythonScript, funcName, binaryPythonUDTF, codePath);
            return BoxedUnit.UNIT;
        });
        byte[] $org_scalatest_assert_macro_left = (byte[])binaryPythonUDTF.elem;
        Object $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        return (byte[])binaryPythonUDTF.elem;
    }

    private byte[] createPythonDataSource(String dataSourceName, String pythonScript) {
        if (!this.shouldTestPythonUDFs()) {
            throw new RuntimeException("Python executable [" + this.pythonExec() + "] and/or pyspark are unavailable.");
        }
        ObjectRef binaryPythonDataSource = ObjectRef.create(null);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)codePath -> {
            IntegratedUDFTestUtils$.$anonfun$createPythonDataSource$1(pythonScript, dataSourceName, binaryPythonDataSource, codePath);
            return BoxedUnit.UNIT;
        });
        byte[] $org_scalatest_assert_macro_left = (byte[])binaryPythonDataSource.elem;
        Object $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        return (byte[])binaryPythonDataSource.elem;
    }

    private byte[] pandasFunc$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x1000) == 0) {
                if (!this.shouldTestPandasUDFs()) {
                    throw new RuntimeException("Python executable [" + this.pythonExec() + "] and/or pyspark are unavailable.");
                }
                ObjectRef binaryPandasFunc = ObjectRef.create(null);
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
                    IntegratedUDFTestUtils$.$anonfun$pandasFunc$1(binaryPandasFunc, path);
                    return BoxedUnit.UNIT;
                });
                byte[] $org_scalatest_assert_macro_left = (byte[])binaryPandasFunc.elem;
                Object $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
                org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc = (byte[])binaryPandasFunc.elem;
                bitmap$0 |= 0x1000;
            }
        }
        return org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc;
    }

    public byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc() {
        if ((bitmap$0 & 0x1000) == 0) {
            return this.pandasFunc$lzycompute();
        }
        return org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc;
    }

    private byte[] pandasGroupedAggFunc$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x2000) == 0) {
                if (!this.shouldTestPandasUDFs()) {
                    throw new RuntimeException("Python executable [" + this.pythonExec() + "] and/or pyspark are unavailable.");
                }
                ObjectRef binaryPandasFunc = ObjectRef.create(null);
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
                    IntegratedUDFTestUtils$.$anonfun$pandasGroupedAggFunc$1(binaryPandasFunc, path);
                    return BoxedUnit.UNIT;
                });
                byte[] $org_scalatest_assert_macro_left = (byte[])binaryPandasFunc.elem;
                Object $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                org$apache$spark$sql$IntegratedUDFTestUtils$$pandasGroupedAggFunc = (byte[])binaryPandasFunc.elem;
                bitmap$0 |= 0x2000;
            }
        }
        return org$apache$spark$sql$IntegratedUDFTestUtils$$pandasGroupedAggFunc;
    }

    public byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pandasGroupedAggFunc() {
        if ((bitmap$0 & 0x2000) == 0) {
            return this.pandasGroupedAggFunc$lzycompute();
        }
        return org$apache$spark$sql$IntegratedUDFTestUtils$$pandasGroupedAggFunc;
    }

    public byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$createPandasGroupedMapFuncWithState(String pythonScript) {
        if (this.shouldTestPandasUDFs()) {
            ObjectRef binaryPandasFunc = ObjectRef.create(null);
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)codePath -> {
                IntegratedUDFTestUtils$.$anonfun$createPandasGroupedMapFuncWithState$1(pythonScript, binaryPandasFunc, codePath);
                return BoxedUnit.UNIT;
            });
            byte[] $org_scalatest_assert_macro_left = (byte[])binaryPandasFunc.elem;
            Object $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            return (byte[])binaryPandasFunc.elem;
        }
        throw new RuntimeException("Python executable [" + this.pythonExec() + "] and/or pyspark are unavailable.");
    }

    public HashMap<String, String> org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv() {
        return org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv;
    }

    private String pythonExec$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x4000) == 0) {
                String pythonExec = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable)() -> (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable)() -> "python3"));
                IntegratedUDFTestUtils$.pythonExec = TestUtils$.MODULE$.testCommandAvailable(pythonExec) ? pythonExec : "python";
                bitmap$0 |= 0x4000;
            }
        }
        return pythonExec;
    }

    public String pythonExec() {
        if ((bitmap$0 & 0x4000) == 0) {
            return this.pythonExec$lzycompute();
        }
        return pythonExec;
    }

    private boolean shouldTestPythonUDFs$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x8000) == 0) {
                shouldTestPythonUDFs = this.isPythonAvailable() && this.isPySparkAvailable();
                bitmap$0 |= 0x8000;
            }
        }
        return shouldTestPythonUDFs;
    }

    public boolean shouldTestPythonUDFs() {
        if ((bitmap$0 & 0x8000) == 0) {
            return this.shouldTestPythonUDFs$lzycompute();
        }
        return shouldTestPythonUDFs;
    }

    private boolean shouldTestPandasUDFs$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((bitmap$0 & 0x10000) == 0) {
                shouldTestPandasUDFs = this.isPythonAvailable() && this.isPandasAvailable() && this.isPyArrowAvailable();
                bitmap$0 |= 0x10000;
            }
        }
        return shouldTestPandasUDFs;
    }

    public boolean shouldTestPandasUDFs() {
        if ((bitmap$0 & 0x10000) == 0) {
            return this.shouldTestPandasUDFs$lzycompute();
        }
        return shouldTestPandasUDFs;
    }

    public UserDefinedPythonDataSource createUserDefinedPythonDataSource(String name, String pythonScript) {
        return new UserDefinedPythonDataSource((PythonFunction)new SimplePythonFunction((scala.collection.immutable.Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)this.createPythonDataSource(name, pythonScript)), (Map)this.org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv().clone(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), this.pythonExec(), this.pythonVer(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), null));
    }

    public UserDefinedPythonTableFunction createUserDefinedPythonTableFunction(String name, String pythonScript, Option<StructType> returnType, int evalType, boolean deterministic) {
        return new UserDefinedPythonTableFunction(name, (PythonFunction)new SimplePythonFunction((scala.collection.immutable.Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)this.createPythonUDTF(name, pythonScript)), (Map)this.org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv().clone(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), this.pythonExec(), this.pythonVer(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), null), returnType, evalType, deterministic);
    }

    public int createUserDefinedPythonTableFunction$default$4() {
        return PythonEvalType$.MODULE$.SQL_TABLE_UDF();
    }

    public boolean createUserDefinedPythonTableFunction$default$5() {
        return false;
    }

    public void registerTestUDF(IntegratedUDFTestUtils.TestUDF testUDF, SparkSession session) {
        IntegratedUDFTestUtils.TestUDF testUDF2 = testUDF;
        if (testUDF2 instanceof IntegratedUDFTestUtils.TestPythonUDF) {
            IntegratedUDFTestUtils.TestPythonUDF testPythonUDF = (IntegratedUDFTestUtils.TestPythonUDF)testUDF2;
            session.udf().registerPython(testPythonUDF.name(), testPythonUDF.udf());
            return;
        }
        if (testUDF2 instanceof IntegratedUDFTestUtils.TestScalarPandasUDF) {
            IntegratedUDFTestUtils.TestScalarPandasUDF testScalarPandasUDF = (IntegratedUDFTestUtils.TestScalarPandasUDF)testUDF2;
            session.udf().registerPython(testScalarPandasUDF.name(), testScalarPandasUDF.udf());
            return;
        }
        if (testUDF2 instanceof IntegratedUDFTestUtils.TestGroupedAggPandasUDF) {
            IntegratedUDFTestUtils.TestGroupedAggPandasUDF testGroupedAggPandasUDF = (IntegratedUDFTestUtils.TestGroupedAggPandasUDF)testUDF2;
            session.udf().registerPython(testGroupedAggPandasUDF.name(), testGroupedAggPandasUDF.udf());
            return;
        }
        if (testUDF2 instanceof IntegratedUDFTestUtils.TestScalaUDF) {
            IntegratedUDFTestUtils.TestScalaUDF testScalaUDF = (IntegratedUDFTestUtils.TestScalaUDF)testUDF2;
            session.udf().register(testScalaUDF.name(), (UserDefinedFunction)testScalaUDF.udf());
            return;
        }
        throw new RuntimeException("Unknown UDF class [" + testUDF2.getClass() + "]");
    }

    public void registerTestUDTFs(IntegratedUDFTestUtils.TestUDTFSet testUDTFSet, SparkSession session) {
        testUDTFSet.udtfs().foreach((Function1 & Serializable)x$1 -> {
            IntegratedUDFTestUtils$.$anonfun$registerTestUDTFs$1(session, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$pythonFunc$1(ObjectRef binaryPythonFunc$1, File path) {
        Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("from pyspark.sql.types import StringType; from pyspark.serializers import CloudPickleSerializer; f = open('" + path + "', 'wb');f.write(CloudPickleSerializer().dumps((lambda x: None if x is None else str(x), StringType())))"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
        binaryPythonFunc$1.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$createPythonUDTF$2(File codePath$1, String funcName$1, ObjectRef binaryPythonUDTF$1, File path) {
        Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("from pyspark.serializers import CloudPickleSerializer; f = open('" + path + "', 'wb');exec(open('" + codePath$1 + "', 'r').read());f.write(CloudPickleSerializer().dumps(" + funcName$1 + "))"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
        binaryPythonUDTF$1.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$createPythonUDTF$1(String pythonScript$1, String funcName$1, ObjectRef binaryPythonUDTF$1, File codePath) {
        Files.write(codePath.toPath(), pythonScript$1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            IntegratedUDFTestUtils$.$anonfun$createPythonUDTF$2(codePath, funcName$1, binaryPythonUDTF$1, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createPythonDataSource$2(File codePath$2, String dataSourceName$1, ObjectRef binaryPythonDataSource$1, File path) {
        Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("from pyspark.serializers import CloudPickleSerializer; f = open('" + path + "', 'wb');exec(open('" + codePath$2 + "', 'r').read());dataSourceCls = " + dataSourceName$1 + ";f.write(CloudPickleSerializer().dumps(dataSourceCls))"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
        binaryPythonDataSource$1.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$createPythonDataSource$1(String pythonScript$2, String dataSourceName$1, ObjectRef binaryPythonDataSource$1, File codePath) {
        Files.write(codePath.toPath(), pythonScript$2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            IntegratedUDFTestUtils$.$anonfun$createPythonDataSource$2(codePath, dataSourceName$1, binaryPythonDataSource$1, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$pandasFunc$1(ObjectRef binaryPandasFunc$1, File path) {
        Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("from pyspark.sql.types import StringType; from pyspark.serializers import CloudPickleSerializer; f = open('" + path + "', 'wb');f.write(CloudPickleSerializer().dumps((lambda x: x.apply(lambda v: None if v is None else str(v)), StringType())))"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
        binaryPandasFunc$1.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$pandasGroupedAggFunc$1(ObjectRef binaryPandasFunc$2, File path) {
        Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("from pyspark.sql.types import IntegerType; from pyspark.serializers import CloudPickleSerializer; f = open('" + path + "', 'wb');f.write(CloudPickleSerializer().dumps((lambda x: x.agg('count'), IntegerType())))"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
        binaryPandasFunc$2.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$createPandasGroupedMapFuncWithState$2(File codePath$3, ObjectRef binaryPandasFunc$3, File path) {
        Process$.MODULE$.apply((Seq)new .colon.colon((Object)MODULE$.pythonExec(), (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("from pyspark.serializers import CloudPickleSerializer; f = open('" + path + "', 'wb');exec(open('" + codePath$3 + "', 'r').read());f.write(CloudPickleSerializer().dumps((func, tpe)))"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)(MODULE$.pysparkPythonPath() + ":" + MODULE$.pythonPath()))})).$bang$bang();
        binaryPandasFunc$3.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$createPandasGroupedMapFuncWithState$1(String pythonScript$3, ObjectRef binaryPandasFunc$3, File codePath) {
        Files.write(codePath.toPath(), pythonScript$3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            IntegratedUDFTestUtils$.$anonfun$createPandasGroupedMapFuncWithState$2(codePath, binaryPandasFunc$3, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$registerTestUDTFs$1(SparkSession session$1, IntegratedUDFTestUtils.TestUDTF x$1) {
        IntegratedUDFTestUtils.TestUDTF testUDTF = x$1;
        if (testUDTF != null) {
            IntegratedUDFTestUtils.TestUDTF testUDTF2 = testUDTF;
            session$1.udtf().registerPython(testUDTF2.name(), testUDTF2.udtf());
            return;
        }
        throw new RuntimeException("Unknown UDTF class [" + testUDTF.getClass() + "]");
    }

    private IntegratedUDFTestUtils$() {
    }
}

