/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000554q\u0001C\u0005\u0011\u0002\u0007\u0005!\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003&\u0001\u0019\u0005a\u0005C\u00033\u0001\u0011\u00051\u0007C\u0003B\u0001\u0011\u0005!\tC\u0003P\u0001\u0011%\u0001\u000bC\u0003V\u0001\u0011%a\u000bC\u0003i\u0001\u0011%\u0011N\u0001\u000bDQ\u0006\u0014h+\u0019:dQ\u0006\u0014H+Z:u'VLG/\u001a\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005I\u0011B\u0001\f\n\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0013\u0005!A/Z:u\u0013\ta\u0012D\u0001\u0007T#2#Vm\u001d;Vi&d7/\u0001\u0004%S:LG\u000f\n\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5u\u0003\u00191wN]7biV\tq\u0005\u0005\u0002)_9\u0011\u0011&\f\t\u0003U\u0005j\u0011a\u000b\u0006\u0003YE\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\n\u0013\u0001D2iK\u000e\\7i\u001c7UsB,GcA\u00105y!)Qg\u0001a\u0001m\u0005\ta\r\u0005\u00028u5\t\u0001H\u0003\u0002:\u0013\u0005)A/\u001f9fg&\u00111\b\u000f\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0003>\u0007\u0001\u0007a(\u0001\u0002eiB\u0011qgP\u0005\u0003\u0001b\u0012\u0001\u0002R1uCRK\b/Z\u0001\u0011G\",7m\u001b)mC&t'+Z:vYR$BaH\"M\u001b\")A\t\u0002a\u0001\u000b\u0006\u0011AM\u001a\t\u0003\r&s!\u0001F$\n\u0005!K\u0011a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005!K\u0001\"B\u001f\u0005\u0001\u00049\u0003\"\u0002(\u0005\u0001\u00049\u0013!C5og\u0016\u0014HOV1m\u00039!Xm\u001d;UC\ndWm\u0016:ji\u0016$\"aH)\t\u000bU*\u0001\u0019\u0001*\u0011\t\u0001\u001aveH\u0005\u0003)\u0006\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001dQ,7\u000f^\"p]\u0012LG/[8ogR\u0019qd\u0016-\t\u000b\u00113\u0001\u0019A#\t\u000be3\u0001\u0019\u0001.\u0002\u0015\r|g\u000eZ5uS>t7\u000fE\u0002\\?\nt!\u0001\u00180\u000f\u0005)j\u0016\"\u0001\u0012\n\u0005!\u000b\u0013B\u00011b\u0005\r\u0019V-\u001d\u0006\u0003\u0011\u0006\u0002B\u0001I2(K&\u0011A-\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u00012\u0017BA4\"\u0005\u001d\u0011un\u001c7fC:\f!\u0003^3ti:+H\u000e\\\"p]\u0012LG/[8ogR\u0019qD[6\t\u000b\u0011;\u0001\u0019A#\t\u000be;\u0001\u0019\u00017\u0011\u0007m{v\u0005")
public interface CharVarcharTestSuite
extends SQLTestUtils {
    public String format();

    public static /* synthetic */ void checkColType$(CharVarcharTestSuite $this, StructField f, DataType dt) {
        $this.checkColType(f, dt);
    }

    default public void checkColType(StructField f, DataType dt) {
        DataType $org_scalatest_assert_macro_left = f.dataType();
        DataType $org_scalatest_assert_macro_right = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(dt);
        DataType dataType = $org_scalatest_assert_macro_left;
        DataType dataType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        Option $org_scalatest_assert_macro_left2 = CharVarcharUtils$.MODULE$.getRawType(f.metadata());
        Some $org_scalatest_assert_macro_right2 = new Some((Object)dt);
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public static /* synthetic */ void checkPlainResult$(CharVarcharTestSuite $this, Dataset df, String dt, String insertVal) {
        $this.checkPlainResult((Dataset<Row>)df, dt, insertVal);
    }

    default public void checkPlainResult(Dataset<Row> df, String dt, String insertVal) {
        DataType dataType = CatalystSqlParser$.MODULE$.parseDataType(dt);
        this.checkColType(df.schema().apply(1), dataType);
        DataType dataType2 = dataType;
        if (dataType2 instanceof CharType) {
            CharType charType = (CharType)dataType2;
            int len = charType.length();
            String fixLenStr = insertVal != null ? StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(insertVal), len)), len, (Object)" ").mkString() : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", fixLenStr})));
            return;
        }
        if (dataType2 instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType2;
            int len = varcharType.length();
            String varLenStrWithUpperBound = insertVal != null ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(insertVal), len) : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", varLenStrWithUpperBound})));
            return;
        }
        throw new MatchError((Object)dataType2);
    }

    private void testTableWrite(Function1<String, BoxedUnit> f) {
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)"char"));
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)"varchar"));
    }

    private void testConditions(Dataset<Row> df, Seq<Tuple2<String, Object>> conditions) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.selectExpr((Seq)conditions.map((Function1 & Serializable)x$1 -> (String)x$1._1())), Row$.MODULE$.fromSeq((Seq)conditions.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._2$mcZ$sp()))));
    }

    private void testNullConditions(Dataset<Row> df, Seq<String> conditions) {
        conditions.foreach((Function1 & Serializable)cond -> {
            CharVarcharTestSuite.$anonfun$testNullConditions$1(this, df, cond);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ String $anonfun$$init$$4(int n) {
        return "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
    }

    public static /* synthetic */ void $anonfun$$init$$5(CharVarcharTestSuite $this, String typ$1, String v) {
        $this.sql().apply((Object)("INSERT OVERWRITE t VALUES ('1', '" + v + "')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ$1, v);
    }

    public static /* synthetic */ String $anonfun$$init$$8(int n) {
        return "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
    }

    public static /* synthetic */ void $anonfun$$init$$9(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)("INSERT OVERWRITE t VALUES ('1', '" + v + "')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
    }

    public static /* synthetic */ String $anonfun$$init$$11(int n) {
        return "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
    }

    public static /* synthetic */ void $anonfun$$init$$12(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)("INSERT INTO t VALUES ('1', '" + v + "')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
        $this.sql().apply((Object)("INSERT INTO t PARTITION (c ='" + v + "') VALUES ('1')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$30(CharVarcharTestSuite $this, String op) {
        SparkRuntimeException x$1 = (SparkRuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE t " + op + " PARTITION(c='abcdef')")), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        String x$2 = "EXCEED_LIMIT_LENGTH";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$4 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$5 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$1, "EXCEED_LIMIT_LENGTH", x$4, x$3, x$5, x$6);
    }

    public static /* synthetic */ void $anonfun$$init$$80(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c " + typeName + "(5)) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES ('123456')"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$19 = sparkRuntimeException;
        String x$20 = "EXCEED_LIMIT_LENGTH";
        Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$22 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$23 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$24 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$19, "EXCEED_LIMIT_LENGTH", x$22, x$21, x$23, x$24);
    }

    public static /* synthetic */ void $anonfun$$init$$84(CharVarcharTestSuite $this, String tableName$1, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE " + tableName$1 + "(i INT, c " + typeName + "(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
        $this.sql().apply((Object)("INSERT INTO " + tableName$1 + " VALUES (1, null)"));
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(tableName$1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("INSERT INTO " + tableName$1 + " VALUES (1, '123456')")), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340)));
        SparkException x$25 = (SparkException)e.getCause();
        String x$26 = "TASK_WRITE_FAILED";
        Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)(".*" + tableName$1 + ".*"))}));
        boolean x$28 = true;
        Option x$29 = ((SparkFunSuite)$this).checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$30 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$25, "TASK_WRITE_FAILED", x$29, x$27, true, x$30);
    }

    public static /* synthetic */ void $anonfun$$init$$88(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c STRUCT<c: " + typeName + "(5)>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        SparkRuntimeException x$31 = (SparkRuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t SELECT struct('123456')"), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        String x$32 = "EXCEED_LIMIT_LENGTH";
        Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$34 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$35 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$36 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$31, "EXCEED_LIMIT_LENGTH", x$34, x$33, x$35, x$36);
    }

    public static /* synthetic */ void $anonfun$$init$$92(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c ARRAY<" + typeName + "(5)>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$37 = sparkRuntimeException;
        String x$38 = "EXCEED_LIMIT_LENGTH";
        Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$40 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$41 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$42 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$37, "EXCEED_LIMIT_LENGTH", x$40, x$39, x$41, x$42);
    }

    public static /* synthetic */ void $anonfun$$init$$96(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c MAP<" + typeName + "(5), STRING>) USING " + $this.format()));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('123456', 'a'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$43 = sparkRuntimeException;
        String x$44 = "EXCEED_LIMIT_LENGTH";
        Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$46 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$47 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$48 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$43, "EXCEED_LIMIT_LENGTH", x$46, x$45, x$47, x$48);
    }

    public static /* synthetic */ void $anonfun$$init$$99(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c MAP<STRING, " + typeName + "(5)>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (map('a', null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$49 = sparkRuntimeException;
        String x$50 = "EXCEED_LIMIT_LENGTH";
        Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$52 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$53 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$54 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$49, "EXCEED_LIMIT_LENGTH", x$52, x$51, x$53, x$54);
    }

    public static /* synthetic */ void $anonfun$$init$$103(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        SparkRuntimeException sparkRuntimeException2;
        $this.sql().apply((Object)("CREATE TABLE t(c MAP<" + typeName + "(5), " + typeName + "(5)>) USING " + $this.format()));
        SparkException e1 = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('123456', 'a'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420)));
        Throwable throwable = e1.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException3;
            sparkRuntimeException2 = sparkRuntimeException3 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException2 = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$55 = sparkRuntimeException2;
        String x$56 = "EXCEED_LIMIT_LENGTH";
        Map x$57 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$58 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$59 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$60 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$55, "EXCEED_LIMIT_LENGTH", x$58, x$57, x$59, x$60);
        SparkException e2 = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429)));
        Throwable throwable2 = e2.getCause();
        if (throwable2 instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException4;
            sparkRuntimeException = sparkRuntimeException4 = (SparkRuntimeException)throwable2;
        } else if (throwable2 instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable2;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable2);
        }
        SparkRuntimeException x$61 = sparkRuntimeException;
        String x$62 = "EXCEED_LIMIT_LENGTH";
        Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$64 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$65 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$66 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$61, "EXCEED_LIMIT_LENGTH", x$64, x$63, x$65, x$66);
    }

    public static /* synthetic */ void $anonfun$$init$$107(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c STRUCT<c: ARRAY<" + typeName + "(5)>>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t SELECT struct(array('123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$67 = sparkRuntimeException;
        String x$68 = "EXCEED_LIMIT_LENGTH";
        Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$70 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$71 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$72 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$67, "EXCEED_LIMIT_LENGTH", x$70, x$69, x$71, x$72);
    }

    public static /* synthetic */ void $anonfun$$init$$111(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c ARRAY<STRUCT<c: " + typeName + "(5)>>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('123456')))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$73 = sparkRuntimeException;
        String x$74 = "EXCEED_LIMIT_LENGTH";
        Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$76 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$77 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$78 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$73, "EXCEED_LIMIT_LENGTH", x$76, x$75, x$77, x$78);
    }

    public static /* synthetic */ void $anonfun$$init$$115(CharVarcharTestSuite $this, String typeName) {
        SparkRuntimeException sparkRuntimeException;
        $this.sql().apply((Object)("CREATE TABLE t(c ARRAY<ARRAY<" + typeName + "(5)>>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(array(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))), (List)Nil$.MODULE$)})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array(array('123456')))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480)));
        Throwable throwable = e.getCause();
        if (throwable instanceof SparkRuntimeException) {
            SparkRuntimeException sparkRuntimeException2;
            sparkRuntimeException = sparkRuntimeException2 = (SparkRuntimeException)throwable;
        } else if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
        } else {
            throw new MatchError((Object)throwable);
        }
        SparkRuntimeException x$79 = sparkRuntimeException;
        String x$80 = "EXCEED_LIMIT_LENGTH";
        Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$82 = ((SparkFunSuite)$this).checkError$default$3();
        boolean x$83 = ((SparkFunSuite)$this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$84 = ((SparkFunSuite)$this).checkError$default$6();
        ((SparkFunSuite)$this).checkError((SparkThrowable)x$79, "EXCEED_LIMIT_LENGTH", x$82, x$81, x$83, x$84);
    }

    public static /* synthetic */ void $anonfun$testNullConditions$1(CharVarcharTestSuite $this, Dataset df$3, String cond) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df$3.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{cond})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
    }

    public static /* synthetic */ void $anonfun$$init$$131(CharVarcharTestSuite $this, Seq conditions$2) {
        $this.sql().apply((Object)("CREATE TABLE t(c CHAR(2)) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES ('a')");
        $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions$2);
    }

    public static /* synthetic */ void $anonfun$$init$$132(CharVarcharTestSuite $this, Seq conditions$2) {
        $this.sql().apply((Object)("CREATE TABLE t(i INT, c CHAR(2)) USING " + $this.format() + " PARTITIONED BY (c)"));
        $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a')");
        $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions$2);
    }

    public static /* synthetic */ void $anonfun$$init$$135(CharVarcharTestSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String con = (String)tuple2._1();
            boolean res = tuple2._2$mcZ$sp();
            Dataset df = $this.spark().table("t");
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Assertions)$this).withClue((Object)con, (Function0)(JFunction0.mcV.sp & Serializable)() -> ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.where(con), (Dataset<Row>)df.where(Boolean.toString(res))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$$init$$169(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT v FROM t1\n             |WHERE 'a' IN (SELECT v FROM t2 WHERE " + predicate + ")\n           "))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c"})));
    }

    public static /* synthetic */ void $anonfun$$init$$173(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT c0 FROM t t1\n             |WHERE (\n             |  SELECT count(*) AS c\n             |  FROM t\n             |  WHERE c0 = t1.c0 AND " + predicate + "\n             |) > 0\n         "))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
    }

    public static void $init$(CharVarcharTestSuite $this) {
        $this.test("apply char padding/trimming and varchar trimming: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c " + typ + ") USING " + $this.format()));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$4(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$5($this, typ, v);
                    return BoxedUnit.UNIT;
                });
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        $this.test("char type values should be padded or trimmed: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c CHAR(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$8(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$9($this, v);
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c CHAR(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$11(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$12($this, v);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        $this.test("char type values should not be padded when charVarcharAsString is true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(a STRING, b CHAR(5), c CHAR(5)) USING " + $this.format() + " partitioned by (c)"));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('abc', 'abc', 'abc')");
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b='abc'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b in ('abc')"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c='abc'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c in ('abc')"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        $this.test("varchar type values length check and trim: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)n -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c VARCHAR(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
            String v = "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
            $this.sql().apply((Object)("INSERT INTO t VALUES ('1', '" + v + "')"));
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)("ALTER TABLE t DROP PARTITION(c='" + v + "')"));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
            $this.sql().apply((Object)("INSERT INTO t PARTITION (c='" + v + "') VALUES ('1')"));
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)("ALTER TABLE t DROP PARTITION(c='" + v + "')"));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        $this.test("oversize char/varchar values for alter table partition operations", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c " + typ + ") USING " + $this.format() + " PARTITIONED BY (c)"));
                new .colon.colon((Object)"ADD", (List)new .colon.colon((Object)"DROP", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)op -> {
                    CharVarcharTestSuite.$anonfun$$init$$30($this, op);
                    return BoxedUnit.UNIT;
                });
                SparkRuntimeException x$7 = (SparkRuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t PARTITION (c='abcdef') RENAME TO PARTITION (c='2')"), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                String x$8 = "EXCEED_LIMIT_LENGTH";
                Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
                Option x$10 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$11 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$12 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$7, "EXCEED_LIMIT_LENGTH", x$10, x$9, x$11, x$12);
                SparkRuntimeException x$13 = (SparkRuntimeException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t PARTITION (c='1') RENAME TO PARTITION (c='abcdef')"), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
                String x$14 = "EXCEED_LIMIT_LENGTH";
                Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
                Option x$16 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$17 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$18 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$13, "EXCEED_LIMIT_LENGTH", x$16, x$15, x$17, x$18);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        $this.test("SPARK-34233: char/varchar with null value for partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c " + typ + ") USING " + $this.format() + " PARTITIONED BY (c)"));
                $this.sql().apply((Object)"INSERT INTO t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c=null) VALUES ('1')");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c=null)");
                ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        $this.test("char type values should be padded: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c STRUCT<c: CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct('a'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        $this.test("char type values should be padded: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c ARRAY<CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (List)new .colon.colon((Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)), (List)Nil$.MODULE$))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        $this.test("char type values should be padded: nested in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c MAP<CHAR(5), STRING>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (Object)"ab")}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)StringType$.MODULE$));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        $this.test("char type values should be padded: nested in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c MAP<STRING, CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', map('a', null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        $this.test("char type values should be padded: nested in both map key and value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c MAP<CHAR(5), CHAR(10)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 8)))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)new CharType(10)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        $this.test("char type values should be padded: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c STRUCT<c: ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (List)new .colon.colon((Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)), (List)Nil$.MODULE$))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        $this.test("char type values should be padded: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c ARRAY<STRUCT<c: CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(struct('a'), struct('ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)})), (List)Nil$.MODULE$))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", (DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(struct(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        $this.test("char type values should be padded: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c ARRAY<ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)new .colon.colon((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (List)new .colon.colon((Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))), (List)Nil$.MODULE$)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        $this.test("length check for input string values: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$80($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        $this.test("length check for input string values: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            if (!$this.conf().contains(SQLConf$.MODULE$.DEFAULT_CATALOG().key())) {
                String tableName = "t";
                $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
                    CharVarcharTestSuite.$anonfun$$init$$84($this, tableName, typeName);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        $this.test("length check for input string values: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$88($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        $this.test("length check for input string values: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$92($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        $this.test("length check for input string values: nested in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$96($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        $this.test("length check for input string values: nested in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$99($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        $this.test("length check for input string values: nested in both map key and value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$103($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        $this.test("length check for input string values: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$107($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        $this.test("length check for input string values: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$111($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        $this.test("length check for input string values: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$115($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        $this.test("length check for input string values: with trailing spaces", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('12 ', '12 ')");
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1234  ', '1234  ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"12" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3), "12 "})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234 "})), (List)Nil$.MODULE$)));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        $this.test("length check for input string values: with implicit cast", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            SparkRuntimeException sparkRuntimeException;
            SparkRuntimeException sparkRuntimeException2;
            $this.sql().apply((Object)("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1234, 1234)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234"})));
            SparkException e1 = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (123456, 1)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508)))));
            Throwable throwable = e1.getCause();
            if (throwable instanceof SparkRuntimeException) {
                SparkRuntimeException sparkRuntimeException3;
                sparkRuntimeException2 = sparkRuntimeException3 = (SparkRuntimeException)throwable;
            } else if (throwable instanceof SparkException) {
                SparkException sparkException = (SparkException)throwable;
                sparkRuntimeException2 = (SparkRuntimeException)sparkException.getCause();
            } else {
                throw new MatchError((Object)throwable);
            }
            SparkRuntimeException x$85 = sparkRuntimeException2;
            String x$86 = "EXCEED_LIMIT_LENGTH";
            Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
            Option x$88 = ((SparkFunSuite)$this).checkError$default$3();
            boolean x$89 = ((SparkFunSuite)$this).checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$90 = ((SparkFunSuite)$this).checkError$default$6();
            ((SparkFunSuite)$this).checkError((SparkThrowable)x$85, "EXCEED_LIMIT_LENGTH", x$88, x$87, x$89, x$90);
            SparkException e2 = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (1, 123456)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517)))));
            Throwable throwable2 = e2.getCause();
            if (throwable2 instanceof SparkRuntimeException) {
                SparkRuntimeException sparkRuntimeException4;
                sparkRuntimeException = sparkRuntimeException4 = (SparkRuntimeException)throwable2;
            } else if (throwable2 instanceof SparkException) {
                SparkException sparkException = (SparkException)throwable2;
                sparkRuntimeException = (SparkRuntimeException)sparkException.getCause();
            } else {
                throw new MatchError((Object)throwable2);
            }
            SparkRuntimeException x$91 = sparkRuntimeException;
            String x$92 = "EXCEED_LIMIT_LENGTH";
            Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
            Option x$94 = ((SparkFunSuite)$this).checkError$default$3();
            boolean x$95 = ((SparkFunSuite)$this).checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$96 = ((SparkFunSuite)$this).checkError$default$6();
            ((SparkFunSuite)$this).checkError((SparkThrowable)x$91, "EXCEED_LIMIT_LENGTH", x$94, x$93, x$95, x$96);
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        $this.test("char type comparison: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 CHAR(2), c2 CHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        $this.test("char type comparison: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i INT, c1 CHAR(2), c2 CHAR(5)) USING " + $this.format() + " PARTITIONED BY (c1, c2)"));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        $this.test("SPARK-34233: char type comparison with null values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon conditions = new .colon.colon((Object)"c = null", (List)new .colon.colon((Object)"c IN ('e', null)", (List)new .colon.colon((Object)"c IN (null)", (List)Nil$.MODULE$)));
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> CharVarcharTestSuite.$anonfun$$init$$131($this, (Seq)conditions)));
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> CharVarcharTestSuite.$anonfun$$init$$132($this, (Seq)conditions)));
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        $this.test("char type comparison: partition pruning", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i INT, c1 CHAR(2), c2 VARCHAR(5)) USING " + $this.format() + " PARTITIONED BY (c1, c2)"));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c2 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true))})).foreach((Function1 & Serializable)x0$1 -> {
                CharVarcharTestSuite.$anonfun$$init$$135($this, x0$1);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
        $this.test("char type comparison: join", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t1(c CHAR(2)) USING " + $this.format()));
            $this.sql().apply((Object)("CREATE TABLE t2(c CHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('a')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT t1.c FROM t1 JOIN t2 ON t1.c = t2.c"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        $this.test("char type comparison: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 STRUCT<c: CHAR(2)>, c2 STRUCT<c: CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct('a'), struct('a'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
        $this.test("char type comparison: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 ARRAY<CHAR(2)>, c2 ARRAY<CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (array('a', 'b'), array('a', 'b'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        $this.test("char type comparison: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 STRUCT<a: ARRAY<CHAR(2)>>, c2 STRUCT<a: ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct(array('a', 'b')), struct(array('a', 'b')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
        $this.test("char type comparison: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 ARRAY<STRUCT<c: CHAR(2)>>, c2 ARRAY<STRUCT<c: CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('a')), array(struct('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
        $this.test("char type comparison: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 ARRAY<ARRAY<CHAR(2)>>, c2 ARRAY<ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(array('a')), array(array('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        $this.test("SPARK-33892: DESCRIBE TABLE w/ char/varchar", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3), c CHAR(5)) USING " + $this.format()));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"desc t")).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"})).where("data_type like '%char%'"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(3)"})), (List)Nil$.MODULE$)));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        $this.test("SPARK-34003: fix char/varchar fails w/ both group by and order by ", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3), i INT) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT v, sum(i) FROM t GROUP BY v ORDER BY v"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
        $this.test("SPARK-34003: fix char/varchar fails w/ order by functions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3), i INT) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT substr(v, 1, 2), sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        $this.test("SPARK-34114: varchar type will strip tailing spaces to certain length at write time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c      ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c  "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        $this.test("SPARK-34114: varchar type will remain the value length with spaces at read time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - join keys", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t1(v VARCHAR(3), c CHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)("CREATE TABLE t2(v VARCHAR(5), c CHAR(8)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('c', 'b')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a', 'b')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1.c = t2.c", "t2.c = t1.c", "t1.c = 'b'", "'b' = t1.c", "t1.c = 'b    '", "'b    ' = t1.c", "t1.c = 'b      '", "'b      ' = t1.c"})).foreach((Function1 & Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$169($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - other preds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c0 INT, c1 CHAR(5), c2 CHAR(7)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'abc', 'abc')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1 = 'abc'", "'abc' = c1", "c1 = 'abc  '", "'abc  ' = c1", "c1 = 'abc    '", "'abc    ' = c1", "c1 = c2", "c2 = c1", "c1 IN ('xxx', 'abc', 'xxxxx')", "c1 IN ('xxx', 'abc  ', 'xxxxx')", "c1 IN ('xxx', 'abc    ', 'xxxxx')", "c1 IN (c2)", "c2 IN (c1)"})).foreach((Function1 & Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$173($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        $this.test("SPARK-35359: create table and insert data over length values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"char", (List)new .colon.colon((Object)"varchar", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t (col " + typ + "(2)) using " + $this.format()));
                $this.sql().apply((Object)"INSERT INTO t SELECT 'aaa'");
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"aaa"})));
            }));
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
    }
}

