/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.credutils.kerberos;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

public class KerberosCredentialsProvider
implements CredentialsProvider {
    private AuthScope authScope;
    private Credentials credentials;

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        if (!authscope.getScheme().regionMatches(true, 0, "Negotiate", 0, "Negotiate".length())) {
            throw new IllegalArgumentException("Only Negotiate auth scheme is supported in AuthScope");
        }
        this.authScope = authscope;
        this.credentials = credentials;
    }

    public Credentials getCredentials(AuthScope authscope) {
        Credentials ret = null;
        if (this.authScope != null && authscope != null) {
            ret = authscope.match(this.authScope) > -1 ? this.credentials : null;
        }
        return ret;
    }

    public void clear() {
        this.authScope = null;
        this.credentials = null;
    }
}

