/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.types.IntValue;
import org.apache.flink.util.MutableObjectIterator;

public class UniformBinaryRowGenerator
implements MutableObjectIterator<BinaryRowData> {
    int numKeys;
    int numVals;
    int keyCnt = 0;
    int valCnt = 0;
    int startKey = 0;
    int startVal = 0;
    boolean repeatKey;
    private IntValue key = new IntValue();
    private IntValue value = new IntValue();

    public UniformBinaryRowGenerator(int numKeys, int numVals, boolean repeatKey) {
        this(numKeys, numVals, 0, 0, repeatKey);
    }

    public UniformBinaryRowGenerator(int numKeys, int numVals, int startKey, int startVal, boolean repeatKey) {
        this.numKeys = numKeys;
        this.numVals = numVals;
        this.startKey = startKey;
        this.startVal = startVal;
        this.repeatKey = repeatKey;
    }

    public BinaryRowData next(BinaryRowData reuse) {
        if (!this.repeatKey) {
            if (this.valCnt >= this.numVals + this.startVal) {
                return null;
            }
            this.key.setValue(this.keyCnt++);
            this.value.setValue(this.valCnt);
            if (this.keyCnt == this.numKeys + this.startKey) {
                this.keyCnt = this.startKey;
                ++this.valCnt;
            }
        } else {
            if (this.keyCnt >= this.numKeys + this.startKey) {
                return null;
            }
            this.key.setValue(this.keyCnt);
            this.value.setValue(this.valCnt++);
            if (this.valCnt == this.numVals + this.startVal) {
                this.valCnt = this.startVal;
                ++this.keyCnt;
            }
        }
        BinaryRowWriter writer = new BinaryRowWriter(reuse);
        writer.writeInt(0, this.key.getValue());
        writer.writeInt(1, this.value.getValue());
        writer.complete();
        return reuse;
    }

    public BinaryRowData next() {
        this.key = new IntValue();
        this.value = new IntValue();
        return this.next(new BinaryRowData(2));
    }
}

