/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.WindowKeySerializer;
import org.apache.flink.table.runtime.util.WindowKey;

class WindowKeySerializerTest
extends SerializerTestBase<WindowKey> {
    WindowKeySerializerTest() {
    }

    protected TypeSerializer<WindowKey> createSerializer() {
        return new WindowKeySerializer((PagedTypeSerializer)new BinaryRowDataSerializer(2));
    }

    protected int getLength() {
        return -1;
    }

    protected Class<WindowKey> getTypeClass() {
        return WindowKey.class;
    }

    protected WindowKey[] getTestData() {
        return new WindowKey[]{new WindowKey(1000L, (RowData)WindowKeySerializerTest.createRow("11", 1)), new WindowKey(-2000L, (RowData)WindowKeySerializerTest.createRow("12", 2)), new WindowKey(Long.MAX_VALUE, (RowData)WindowKeySerializerTest.createRow("132", 3)), new WindowKey(Long.MIN_VALUE, (RowData)WindowKeySerializerTest.createRow("55", 4))};
    }

    private static BinaryRowData createRow(String f0, int f1) {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)f0));
        writer.writeInt(1, f1);
        writer.complete();
        return row;
    }
}

