/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;

class ComparableInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    ComparableInputTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Numeric types are comparable", InputTypeStrategies.comparable((ConstantArgumentCount)ConstantArgumentCount.of((int)7), (StructuredType.StructuredComparison)StructuredType.StructuredComparison.EQUALS)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.FLOAT(), DataTypes.DECIMAL((int)10, (int)2)}).expectSignature("f(<COMPARABLE>...)").expectArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.FLOAT(), DataTypes.DECIMAL((int)10, (int)2)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Datetime types are comparable", InputTypeStrategies.comparable((ConstantArgumentCount)ConstantArgumentCount.of((int)5), (StructuredType.StructuredComparison)StructuredType.StructuredComparison.EQUALS)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(), DataTypes.TIMESTAMP_LTZ(), DataTypes.TIMESTAMP_WITH_TIME_ZONE(), DataTypes.DATE()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(), DataTypes.TIMESTAMP_LTZ(), DataTypes.TIMESTAMP_WITH_TIME_ZONE(), DataTypes.DATE()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("VARCHAR and CHAR types are comparable", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)10), DataTypes.CHAR((int)13)}).expectArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)10), DataTypes.CHAR((int)13)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("VARBINARY and BINARY types are comparable", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.VARBINARY((int)10), DataTypes.BINARY((int)13)}).expectArgumentTypes(new AbstractDataType[]{DataTypes.VARBINARY((int)10), DataTypes.BINARY((int)13)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable array types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.TINYINT()), DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)10, (int)2))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.TINYINT()), DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)10, (int)2))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable map types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)3), (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)3), (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Fully comparable structured types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.FULL).notNull(), ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.FULL).nullable()).expectArgumentTypes(ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.FULL).notNull(), ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.FULL).nullable()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Equals comparable structured types", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS), ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS)}).expectArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS), ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable arrays of structured types", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS).notNull())), DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS).nullable()))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS).notNull())), DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS).nullable()))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Distinct types are comparable if the source type is comparable", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).notNull(), ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).nullable()).expectArgumentTypes(ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).notNull(), ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).nullable()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable multisets of distinct types", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).notNull())), DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).nullable()))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).notNull())), DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTest.distinctType("type", DataTypes.INT()).nullable()))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Everything is comparable with null type", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.NULL()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.NULL()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("RAW types are comparable if the originating class implements Comparable", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(ComparableInputTypeStrategyTest.rawType(ComparableClass.class).notNull(), ComparableInputTypeStrategyTest.rawType(ComparableClass.class).nullable()).expectArgumentTypes(ComparableInputTypeStrategyTest.rawType(ComparableClass.class).notNull(), ComparableInputTypeStrategyTest.rawType(ComparableClass.class).nullable()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable map of raw types", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class).notNull()), (DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class)), DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class).nullable()), (DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class).notNull()), (DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class)), DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class).nullable()), (DataType)ComparableInputTypeStrategyTest.rawType(ComparableClass.class))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("RAW types are not comparable if the originating class does not implement Comparable", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.rawType(NotComparableClass.class), ComparableInputTypeStrategyTest.rawType(NotComparableClass.class)}).expectErrorMessage(String.format("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare RAW('%s', '...') with RAW('%s', '...')", NotComparableClass.class.getName(), NotComparableClass.class.getName())), InputTypeStrategiesTestBase.TestSpec.forStrategy("RAW types are not comparable if the types are different", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.rawType(NotComparableClass.class), DataTypes.RAW(NotComparableClass.class, (TypeSerializer)new PojoSerializer(NotComparableClass.class, new TypeSerializer[0], new Field[0], (SerializerConfig)new SerializerConfigImpl()))}).expectErrorMessage(String.format("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare RAW('%s', '...') with RAW('%s', '...')", NotComparableClass.class.getName(), NotComparableClass.class.getName())), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not fully comparable structured types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS), ComparableInputTypeStrategyTest.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS)}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare `cat`.`db`.`type` with `cat`.`db`.`type`"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Two different structured types are not comparable", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.structuredType("type1", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS), ComparableInputTypeStrategyTest.structuredType("type2", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparison.EQUALS)}).expectErrorMessage("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare `cat`.`db`.`type1` with `cat`.`db`.`type2`"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Two different different distinct types are not comparable even if point to the same type", SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTest.distinctType("type1", DataTypes.INT()), ComparableInputTypeStrategyTest.distinctType("type2", DataTypes.INT())}).expectErrorMessage("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare `cat`.`db`.`type1` with `cat`.`db`.`type2`"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable array types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.TINYINT()), DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)2))}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare ARRAY<TINYINT> with ARRAY<VARCHAR(2)>"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable key types in map types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.VARCHAR((int)3), (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare MAP<TINYINT, TIMESTAMP(6)> with MAP<VARCHAR(3), TIMESTAMP(6) WITH TIME ZONE>"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable value types in map types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)3), (DataType)DataTypes.INT())}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare MAP<TINYINT, TIMESTAMP(6)> with MAP<DECIMAL(10, 3), INT>"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable types", SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.BIGINT()}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare TIMESTAMP(6) with BIGINT"));
    }

    private static <T> DataType rawType(Class<T> clazz) {
        return DataTypes.RAW(clazz, (TypeSerializer)new KryoSerializer(clazz, (SerializerConfig)new SerializerConfigImpl()));
    }

    private static DataType distinctType(String typeName, DataType sourceType) {
        return new AtomicDataType((LogicalType)DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)typeName), (LogicalType)sourceType.getLogicalType()).build(), sourceType.getConversionClass());
    }

    private static DataType structuredType(String typeName, List<DataType> fieldDataTypes, StructuredType.StructuredComparison comparison) {
        return new FieldsDataType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)typeName)).attributes(IntStream.range(0, fieldDataTypes.size()).mapToObj(idx -> new StructuredType.StructuredAttribute("f" + idx, ((DataType)fieldDataTypes.get(idx)).getLogicalType())).collect(Collectors.toList())).comparison(comparison).build(), fieldDataTypes);
    }

    private static class NotComparableClass {
        private NotComparableClass() {
        }
    }

    private static class ComparableClass
    implements Comparable<ComparableClass> {
        private ComparableClass() {
        }

        @Override
        public int compareTo(@Nonnull ComparableClass o) {
            return 0;
        }
    }
}

