/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.workflow;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.factories.WorkflowSchedulerFactory;
import org.apache.flink.table.factories.WorkflowSchedulerFactoryUtil;
import org.apache.flink.table.refresh.RefreshHandler;
import org.apache.flink.table.refresh.RefreshHandlerSerializer;
import org.apache.flink.table.workflow.CreateRefreshWorkflow;
import org.apache.flink.table.workflow.DeleteRefreshWorkflow;
import org.apache.flink.table.workflow.ModifyRefreshWorkflow;
import org.apache.flink.table.workflow.WorkflowException;
import org.apache.flink.table.workflow.WorkflowScheduler;

public class TestWorkflowSchedulerFactory
implements WorkflowSchedulerFactory {
    public static final String IDENTIFIER = "test";
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"user-name").stringType().noDefaultValue();
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue();
    public static final ConfigOption<String> PROJECT_NAME = ConfigOptions.key((String)"project-name").stringType().noDefaultValue();

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(USERNAME);
        options.add(PASSWORD);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PROJECT_NAME);
        return options;
    }

    public WorkflowScheduler<?> createWorkflowScheduler(WorkflowSchedulerFactory.Context context) {
        WorkflowSchedulerFactoryUtil.WorkflowSchedulerFactoryHelper helper = WorkflowSchedulerFactoryUtil.createWorkflowSchedulerFactoryHelper((WorkflowSchedulerFactory)this, (WorkflowSchedulerFactory.Context)context);
        helper.validate();
        return new TestWorkflowScheduler((String)helper.getOptions().get(USERNAME), (String)helper.getOptions().get(PASSWORD), (String)helper.getOptions().get(PROJECT_NAME));
    }

    public static class TestRefreshHandlerSerializer
    implements RefreshHandlerSerializer<TestRefreshHandler> {
        public static final TestRefreshHandlerSerializer INSTANCE = new TestRefreshHandlerSerializer();

        public byte[] serialize(TestRefreshHandler refreshHandler) throws IOException {
            return new byte[0];
        }

        public TestRefreshHandler deserialize(byte[] serializedBytes, ClassLoader cl) throws IOException, ClassNotFoundException {
            return TestRefreshHandler.INSTANCE;
        }
    }

    public static class TestRefreshHandler
    implements RefreshHandler {
        public static final TestRefreshHandler INSTANCE = new TestRefreshHandler();

        public String asSummaryString() {
            return "Test RefreshHandler";
        }
    }

    public static class TestWorkflowScheduler
    implements WorkflowScheduler<TestRefreshHandler> {
        private final String userName;
        private final String password;
        private final String projectName;

        public TestWorkflowScheduler(String userName, String password, String projectName) {
            this.userName = userName;
            this.password = password;
            this.projectName = projectName;
        }

        public void open() throws WorkflowException {
        }

        public void close() throws WorkflowException {
        }

        public RefreshHandlerSerializer<TestRefreshHandler> getRefreshHandlerSerializer() {
            return TestRefreshHandlerSerializer.INSTANCE;
        }

        public TestRefreshHandler createRefreshWorkflow(CreateRefreshWorkflow createRefreshWorkflow) throws WorkflowException {
            return TestRefreshHandler.INSTANCE;
        }

        public void modifyRefreshWorkflow(ModifyRefreshWorkflow<TestRefreshHandler> modifyRefreshWorkflow) throws WorkflowException {
            throw new UnsupportedOperationException();
        }

        public void deleteRefreshWorkflow(DeleteRefreshWorkflow<TestRefreshHandler> deleteRefreshWorkflow) throws WorkflowException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestWorkflowScheduler that = (TestWorkflowScheduler)o;
            return Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.projectName, that.projectName);
        }

        public int hashCode() {
            return Objects.hash(this.userName, this.password, this.projectName);
        }
    }
}

