/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;

class ObjectOfInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    private static final InputTypeStrategy OBJECT_OF_INPUT_STRATEGY = BuiltInFunctionDefinitions.OBJECT_OF.getTypeInference((DataTypeFactory)new DataTypeFactoryMock()).getInputTypeStrategy();
    private static final String USER_CLASS_PATH = "com.example.User";

    ObjectOfInputTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid OBJECT_OF with only class", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(DataTypes.STRING().notNull()).calledWithLiteralAt(0, USER_CLASS_PATH).expectSignature("f(class name STRING, [STRING, ANY]*...)").expectArgumentTypes(DataTypes.STRING().notNull()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid OBJECT_OF with class and one field and value", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INT()}).calledWithLiteralAt(0, USER_CLASS_PATH).calledWithLiteralAt(1, "field1").expectArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid OBJECT_OF with multiple fields", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRUCTURED((String)"c1", (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.INT())}), DataTypes.STRING().notNull(), DataTypes.STRUCTURED((String)"c2", (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.FLOAT())})}).calledWithLiteralAt(0, USER_CLASS_PATH).calledWithLiteralAt(1, "field1").calledWithLiteralAt(3, "field2").expectArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRUCTURED((String)"c1", (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.INT())}), DataTypes.STRING().notNull(), DataTypes.STRUCTURED((String)"c2", (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.FLOAT())})}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_OF with class argument as type STRING with null value", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING()}).calledWithLiteralAt(0, null).expectErrorMessage("The first argument must be a non-nullable character string literal representing the class name."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid OBJECT_OF with key as type STRING with null value", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.INT()}).calledWithLiteralAt(0, USER_CLASS_PATH).calledWithLiteralAt(1, null).expectErrorMessage("The field key at position 2 must be a non-nullable character string literal."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_OF with even number of arguments", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(DataTypes.STRING().notNull(), DataTypes.STRING().notNull()).calledWithLiteralAt(0, USER_CLASS_PATH).expectErrorMessage("Invalid number of arguments."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_OF with no arguments", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[0]).expectErrorMessage("Invalid number of arguments."), InputTypeStrategiesTestBase.TestSpec.forStrategy("OBJECT_OF with non-string class name", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).calledWithLiteralAt(0, 72).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).expectErrorMessage("The first argument must be a non-nullable character string representing the class name, but was INT."), InputTypeStrategiesTestBase.TestSpec.forStrategy("OBJECT_OF with non-string field name", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.INT(), DataTypes.INT()}).calledWithLiteralAt(0, USER_CLASS_PATH).calledWithLiteralAt(1, 5).expectArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.INT(), DataTypes.INT()}).expectErrorMessage("The field key at position 2 must be a non-nullable character string, but was INT."), InputTypeStrategiesTestBase.TestSpec.forStrategy("OBJECT_OF with repeated field names", OBJECT_OF_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INT(), DataTypes.STRING().notNull(), DataTypes.INT()}).calledWithLiteralAt(0, USER_CLASS_PATH).calledWithLiteralAt(1, "field1").calledWithLiteralAt(3, "field1").expectArgumentTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INT(), DataTypes.STRING().notNull(), DataTypes.INT()}).expectErrorMessage("The field name 'field1' at position 4 is repeated."));
    }
}

