/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;
import org.apache.flink.table.types.inference.utils.ModelSemanticsMock;
import org.apache.flink.table.types.inference.utils.TableSemanticsMock;
import org.apache.flink.types.ColumnList;

class MLPredictInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    private static final DataType TABLE_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE())});
    private static final DataType MODEL_INPUT_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE())});
    private static final DataType MODEL_OUTPUT_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"prediction", (DataType)DataTypes.DOUBLE())});
    private static final DataType DESCRIPTOR_TYPE = DataTypes.DESCRIPTOR();
    private static final DataType MAP_TYPE = DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING());

    MLPredictInputTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid ML_PREDICT with table, model, and descriptor", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE}).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).calledWithLiteralAt(2, ColumnList.of(List.of("feature1", "feature2"))).expectSignature("f(TABLE ROW, MODEL MODEL, ARGS DESCRIPTOR)\nf(TABLE ROW, MODEL MODEL, ARGS DESCRIPTOR, CONFIG MAP)").expectArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid ML_PREDICT with table, model, descriptor, and config", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE, MAP_TYPE}).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).calledWithLiteralAt(2, ColumnList.of(List.of("feature1", "feature2"))).expectArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE, MAP_TYPE}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Descriptor column not found in table", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE}).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).calledWithLiteralAt(2, ColumnList.of(List.of("nonexistent_column"))).expectErrorMessage("Descriptor column 'nonexistent_column' not found in table columns. Available columns: id, feature1, feature2."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Descriptor column count mismatch with model input", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE}).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).calledWithLiteralAt(2, ColumnList.of(List.of("feature1"))).expectErrorMessage("Number of descriptor columns (1) does not match model input size (2)."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Descriptor column type incompatible with model input", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE}).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).calledWithLiteralAt(2, ColumnList.of(List.of("id", "feature1"))).expectErrorMessage("Descriptor column 'id' type STRING cannot be assigned to model input type DOUBLE at position 0."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Too few arguments", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE}).expectErrorMessage("Invalid number of arguments. At least 3 arguments expected but 2 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Too many arguments", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DESCRIPTOR_TYPE, MAP_TYPE, DataTypes.STRING()}).expectErrorMessage("Invalid number of arguments. At most 4 arguments expected but 5 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("First argument not a table", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), MODEL_INPUT_TYPE, DESCRIPTOR_TYPE}).expectErrorMessage("First argument must be a table for ML_PREDICT function."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Second argument not a model", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, DataTypes.STRING(), DESCRIPTOR_TYPE}).expectErrorMessage("Second argument must be a model for ML_PREDICT function."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Third argument not a descriptor", SpecificInputTypeStrategies.ML_PREDICT_INPUT_TYPE_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{TABLE_TYPE, MODEL_INPUT_TYPE, DataTypes.STRING()}).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).expectErrorMessage("Third argument must be a descriptor with simple column names for ML_PREDICT function."));
    }
}

