/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;

@PublicEvolving
public abstract class AsyncVectorSearchFunction
extends AsyncTableFunction<RowData> {
    public abstract CompletableFuture<Collection<RowData>> asyncVectorSearch(int var1, RowData var2);

    public void eval(CompletableFuture<Collection<RowData>> future, Object ... args) {
        int topK = (Integer)args[0];
        GenericRowData argsData = new GenericRowData(args.length - 1);
        for (int i = 1; i < args.length; ++i) {
            argsData.setField(i, args[i]);
        }
        this.asyncVectorSearch(topK, argsData).whenComplete((result, exception) -> {
            if (exception != null) {
                future.completeExceptionally(new TableException(String.format("Failed to execute asynchronously search with input row %s.", argsData), (Throwable)exception));
                return;
            }
            future.complete((Collection<RowData>)result);
        });
    }
}

