/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;

class SubQueryInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    SubQueryInputTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.SMALLINT(), DataTypes.INT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set, binary", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set, string", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set, multiset(timestamp)", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP())}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP())}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set, arrays", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.SMALLINT())}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.ARRAY((DataType)DataTypes.BIGINT())}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set of ROWs", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())})}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())})}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a subquery", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT())})}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT())})}), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a set not comparable", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}).expectErrorMessage("Types on the right side of IN operator (STRING) are not comparable with INT."), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a subquery not comparable", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING())})}).expectErrorMessage("Types on the right side of IN operator (ROW<`f0` STRING>) are not comparable with INT"), InputTypeStrategiesTestBase.TestSpec.forStrategy("IN a subquery of ROWs", SpecificInputTypeStrategies.IN).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}))})}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}))})}));
    }
}

