/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificTypeStrategies;
import org.apache.flink.table.types.inference.utils.ModelSemanticsMock;
import org.apache.flink.table.types.inference.utils.TableSemanticsMock;

class MLPredictOutputTypeStrategyTest
extends TypeStrategiesTestBase {
    private static final DataType TABLE_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE())});
    private static final DataType MODEL_INPUT_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE())});
    private static final DataType MODEL_OUTPUT_TYPE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"prediction", (DataType)DataTypes.DOUBLE())});
    private static final DataType MODEL_OUTPUT_TYPE_CONFLICTING = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.STRING())});
    private static final DataType MODEL_OUTPUT_TYPE_MULTIPLE = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"prediction", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"confidence", (DataType)DataTypes.DOUBLE())});

    MLPredictOutputTypeStrategyTest() {
    }

    @Override
    protected Stream<TypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(TypeStrategiesTestBase.TestSpec.forStrategy("Basic output type inference with no field conflicts", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(TABLE_TYPE, MODEL_INPUT_TYPE).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).expectDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"prediction", (DataType)DataTypes.DOUBLE())})), TypeStrategiesTestBase.TestSpec.forStrategy("Output type inference with field name conflict", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(TABLE_TYPE, MODEL_INPUT_TYPE).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE_CONFLICTING)).expectDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"id0", (DataType)DataTypes.STRING())})), TypeStrategiesTestBase.TestSpec.forStrategy("Output type inference with multiple model fields", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(TABLE_TYPE, MODEL_INPUT_TYPE).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE_MULTIPLE)).expectDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"feature1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"feature2", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"prediction", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"confidence", (DataType)DataTypes.DOUBLE())})), TypeStrategiesTestBase.TestSpec.forStrategy("Error when table semantics missing", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(TABLE_TYPE, MODEL_INPUT_TYPE).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).expectErrorMessage("First argument must be a table for ML_PREDICT function."), TypeStrategiesTestBase.TestSpec.forStrategy("Error when model semantics missing", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(TABLE_TYPE, MODEL_INPUT_TYPE).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).expectErrorMessage("Second argument must be a model for ML_PREDICT function."), TypeStrategiesTestBase.TestSpec.forStrategy("Error when table type is not a row", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(DataTypes.STRING(), MODEL_INPUT_TYPE).calledWithTableSemanticsAt(0, new TableSemanticsMock(DataTypes.STRING())).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, MODEL_OUTPUT_TYPE)).expectErrorMessage("Both table and model output types must be row types for ML_PREDICT function."), TypeStrategiesTestBase.TestSpec.forStrategy("Error when model output type is not a row", SpecificTypeStrategies.ML_PREDICT_OUTPUT_TYPE_STRATEGY).inputTypes(TABLE_TYPE, MODEL_INPUT_TYPE).calledWithTableSemanticsAt(0, new TableSemanticsMock(TABLE_TYPE)).calledWithModelSemanticsAt(1, new ModelSemanticsMock(MODEL_INPUT_TYPE, DataTypes.STRING())).expectErrorMessage("Both table and model output types must be row types for ML_PREDICT function."));
    }
}

