/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModelProviderFactory;
import org.apache.flink.table.ml.ModelProvider;

public final class TestNonPredictModelProviderFactory
implements ModelProviderFactory {
    public static final String IDENTIFIER = "non-predict-model";
    public static final ConfigOption<String> TASK = ConfigOptions.key((String)"task").stringType().noDefaultValue().withDescription("Task of the test model.");
    public static final ConfigOption<String> ENDPOINT = ConfigOptions.key((String)"endpoint").stringType().noDefaultValue().withDescription("Endpoint of the test model.");
    public static final ConfigOption<Integer> MODEL_VERSION = ConfigOptions.key((String)"version").intType().defaultValue((Object)1).withDescription("Version of the test model.");

    public ModelProvider createModelProvider(ModelProviderFactory.Context context) {
        FactoryUtil.ModelProviderFactoryHelper helper = FactoryUtil.createModelProviderFactoryHelper((ModelProviderFactory)this, (ModelProviderFactory.Context)context);
        helper.validate();
        return new TestModelProviderMock(context.getCatalogModel());
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(TASK);
        options.add(ENDPOINT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MODEL_VERSION);
        return options;
    }

    public static class TestModelProviderMock
    implements ModelProvider {
        private final ResolvedCatalogModel catalogModel;

        public TestModelProviderMock(ResolvedCatalogModel catalogModel) {
            this.catalogModel = catalogModel;
        }

        public ModelProvider copy() {
            return new TestModelProviderMock(this.catalogModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.catalogModel.equals(((TestModelProviderMock)o).catalogModel);
        }
    }
}

