/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.TestSchemaResolver;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionMock;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class SchemaTest {
    private static final String COMPUTED_SQL = "orig_ts - INTERVAL '60' MINUTE";
    private static final ResolvedExpression COMPUTED_COLUMN_RESOLVED = new ResolvedExpressionMock(DataTypes.TIMESTAMP((int)3), () -> "orig_ts - INTERVAL '60' MINUTE");

    SchemaTest() {
    }

    @Nested
    class Builder {
        Builder() {
        }

        @Test
        void testFromResolvedSchema() {
            ResolvedSchema originalSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"event_timestamp", (DataType)((DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull())).withComment("The timestamp when the event occurred."), Column.computed((String)"rowtime", (ResolvedExpression)COMPUTED_COLUMN_RESOLVED).withComment("The rowtime derived from the event timestamp."), Column.metadata((String)"topic", (DataType)DataTypes.STRING(), null, (boolean)true).withComment("kafka topic")});
            Schema newSchema = Schema.newBuilder().fromResolvedSchema(originalSchema).build();
            Assertions.assertThat((Object)newSchema.resolve((SchemaResolver)new TestSchemaResolver())).isEqualTo((Object)originalSchema);
        }
    }
}

