/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.types.Row;

public class ModelTestStep
implements TestStep {
    public final String name;
    public final List<String> inputSchema;
    public final List<String> outputSchema;
    public final Map<String, String> options;
    public final Map<Row, List<Row>> data;

    public ModelTestStep(String name, List<String> inputSchemaComponents, List<String> outputSchemaComponents, Map<String, String> options, Map<Row, List<Row>> data) {
        this.name = name;
        this.inputSchema = inputSchemaComponents;
        this.outputSchema = outputSchemaComponents;
        this.options = options;
        this.data = data;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    @Override
    public TestStep.TestKind getKind() {
        return TestStep.TestKind.MODEL;
    }

    public TableResult apply(TableEnvironment env, Map<String, String> extraOptions) {
        HashMap<String, String> allOptions = new HashMap<String, String>(this.options);
        allOptions.putAll(extraOptions);
        String createModel = String.format("CREATE MODEL `%s`\nINPUT (%s)\nOUTPUT (%s)\nWITH (\n%s)", this.name, String.join((CharSequence)",", this.inputSchema), String.join((CharSequence)",", this.outputSchema), allOptions.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(",\n")));
        return env.executeSql(createModel);
    }

    public static class Builder {
        final String name;
        final List<String> inputSchemaComponents = new ArrayList<String>();
        final List<String> outputSchemaComponents = new ArrayList<String>();
        final Map<String, String> options = new HashMap<String, String>();
        final Map<Row, List<Row>> data = new HashMap<Row, List<Row>>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder addInputSchema(String ... schemaComponents) {
            this.inputSchemaComponents.addAll(Arrays.asList(schemaComponents));
            return this;
        }

        public Builder addInputSchema(List<String> schemaComponents) {
            this.inputSchemaComponents.addAll(schemaComponents);
            return this;
        }

        public Builder addOutputSchema(String ... schemaComponents) {
            this.outputSchemaComponents.addAll(Arrays.asList(schemaComponents));
            return this;
        }

        public Builder addOutputSchema(List<String> schemaComponents) {
            this.outputSchemaComponents.addAll(schemaComponents);
            return this;
        }

        public Builder addOption(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder addOptions(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Builder data(Map<Row, List<Row>> data) {
            this.data.putAll(data);
            return this;
        }

        public ModelTestStep build() {
            return new ModelTestStep(this.name, this.inputSchemaComponents, this.outputSchemaComponents, this.options, this.data);
        }
    }
}

