/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.test.program.TestStep;

public interface TableTestProgramRunner {
    public List<TableTestProgram> programs();

    default public List<TableTestProgram> supportedPrograms() {
        List<TableTestProgram> programs = this.programs();
        List ids = programs.stream().map(p -> p.id).collect(Collectors.toList());
        List duplicates = ids.stream().filter(id -> Collections.frequency(ids, id) > 1).distinct().collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Duplicate test program id found: " + duplicates);
        }
        EnumSet<TestStep.TestKind> setupSteps = this.supportedSetupSteps();
        EnumSet<TestStep.TestKind> runSteps = this.supportedRunSteps();
        programs.forEach(p -> {
            p.setupSteps.stream().map(TestStep::getKind).filter(k -> !setupSteps.contains(k)).findFirst().ifPresent(k -> {
                throw new UnsupportedOperationException("Test runner does not support setup step: " + k);
            });
            p.runSteps.stream().map(TestStep::getKind).filter(k -> !runSteps.contains(k)).findFirst().ifPresent(k -> {
                throw new UnsupportedOperationException("Test runner does not support run step: " + k);
            });
        });
        return programs;
    }

    public EnumSet<TestStep.TestKind> supportedSetupSteps();

    public EnumSet<TestStep.TestKind> supportedRunSteps();
}

