/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;

public final class FunctionLookupMock
implements FunctionLookup {
    private final Map<FunctionIdentifier, FunctionDefinition> functions;

    public FunctionLookupMock(Map<FunctionIdentifier, FunctionDefinition> functions) {
        this.functions = functions;
    }

    public Optional<ContextResolvedFunction> lookupFunction(String stringIdentifier) {
        return this.lookupFunction(UnresolvedIdentifier.of((String[])stringIdentifier.split("\\.")));
    }

    public Optional<ContextResolvedFunction> lookupFunction(UnresolvedIdentifier identifier) {
        FunctionIdentifier functionIdentifier = identifier.getCatalogName().isPresent() && identifier.getDatabaseName().isPresent() ? FunctionIdentifier.of((ObjectIdentifier)ObjectIdentifier.of((String)((String)identifier.getCatalogName().get()), (String)((String)identifier.getDatabaseName().get()), (String)identifier.getObjectName())) : FunctionIdentifier.of((String)identifier.getObjectName());
        return Optional.ofNullable(this.functions.get(functionIdentifier)).map(func -> ContextResolvedFunction.permanent((FunctionIdentifier)functionIdentifier, (FunctionDefinition)func));
    }

    public ContextResolvedFunction lookupBuiltInFunction(BuiltInFunctionDefinition definition) {
        return ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((String)definition.getName()), (FunctionDefinition)definition);
    }
}

