/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTest;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;

public abstract class CatalogTestBase
extends CatalogTest {
    public CatalogDatabase createDb() {
        return new CatalogDatabaseImpl((Map)new HashMap<String, String>(){
            {
                this.put("k1", "v1");
            }
        }, "test comment");
    }

    public CatalogDatabase createAnotherDb() {
        return new CatalogDatabaseImpl((Map)new HashMap<String, String>(){
            {
                this.put("k2", "v2");
            }
        }, "test comment");
    }

    public CatalogTable createTable() {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").options(this.getBatchTableProperties()).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    public CatalogModel createModel() {
        Schema inputSchema = Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).column("b", (AbstractDataType)DataTypes.STRING()).build();
        Schema outputSchema = Schema.newBuilder().column("label", (AbstractDataType)DataTypes.STRING()).build();
        return CatalogModel.of((Schema)inputSchema, (Schema)outputSchema, (Map)new HashMap<String, String>(){
            {
                this.put("task", "clustering");
                this.put("provider", "openai");
            }
        }, null);
    }

    public CatalogTable createAnotherTable() {
        ResolvedSchema resolvedSchema = this.createAnotherSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").options(this.getBatchTableProperties()).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    public CatalogTable createStreamingTable() {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").options(this.getStreamingTableProperties()).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    public CatalogTable createPartitionedTable() {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(this.createPartitionKeys()).options(this.getBatchTableProperties()).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    public CatalogTable createAnotherPartitionedTable() {
        ResolvedSchema resolvedSchema = this.createAnotherSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(this.createPartitionKeys()).options(this.getBatchTableProperties()).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    public CatalogPartition createPartition() {
        return new CatalogPartitionImpl(this.getBatchTableProperties(), "test comment");
    }

    public CatalogView createView() {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogView origin = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"This is a view", (String)String.format("select * from %s", "t1"), (String)String.format("select * from %s.%s", "test-catalog", this.path1.getFullName()), Collections.emptyMap());
        return new ResolvedCatalogView(origin, resolvedSchema);
    }

    public CatalogView createAnotherView() {
        ResolvedSchema resolvedSchema = this.createAnotherSchema();
        CatalogView origin = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"This is a another view", (String)String.format("select * from %s", "t2"), (String)String.format("select * from %s.%s", "test-catalog", this.path2.getFullName()), Collections.emptyMap());
        return new ResolvedCatalogView(origin, resolvedSchema);
    }

    protected Map<String, String> getBatchTableProperties() {
        return new HashMap<String, String>(){
            {
                this.put("is_streaming", "false");
                this.putAll(CatalogTestBase.this.getGenericFlag(CatalogTestBase.this.isGeneric()));
            }
        };
    }

    protected Map<String, String> getStreamingTableProperties() {
        return new HashMap<String, String>(){
            {
                this.put("is_streaming", "true");
                this.putAll(CatalogTestBase.this.getGenericFlag(CatalogTestBase.this.isGeneric()));
            }
        };
    }

    private Map<String, String> getGenericFlag(final boolean isGeneric) {
        return new HashMap<String, String>(){
            {
                String connector = isGeneric ? "COLLECTION" : "hive";
                this.put(FactoryUtil.CONNECTOR.key(), connector);
            }
        };
    }

    protected abstract boolean isGeneric();
}

