/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.runtime.operators.sink.TestSinkV2;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DataStreamSinkTest {
    DataStreamSinkTest() {
    }

    @Test
    void testGettingTransformationWithNewSinkAPI() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Transformation transformation = env.fromData((Object[])new Integer[]{1, 2}).sinkTo(TestSinkV2.newBuilder().build()).getTransformation();
        Assertions.assertThat((Object)transformation).isInstanceOf(SinkTransformation.class);
    }

    @Test
    void throwExceptionWhenSetUidWithNewSinkAPI() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Assertions.assertThatThrownBy(() -> env.fromData((Object[])new Integer[]{1, 2}).sinkTo(TestSinkV2.newBuilder().build()).setUidHash("Test")).isInstanceOf(UnsupportedOperationException.class);
    }
}

