/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackendParametersImpl;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.state.rocksdb.EmbeddedRocksDBStateBackend;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackend;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackendBuilder;
import org.apache.flink.state.rocksdb.RocksDBPriorityQueueConfig;
import org.apache.flink.state.rocksdb.RocksDBResourceContainer;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.RocksDB;

public final class RocksDBTestUtils {
    public static <K> RocksDBKeyedStateBackendBuilder<K> builderForTestDefaults(File instanceBasePath, TypeSerializer<K> keySerializer) {
        return RocksDBTestUtils.builderForTestDefaults(instanceBasePath, keySerializer, 2, new KeyGroupRange(0, 1), Collections.emptyList());
    }

    public static <K> RocksDBKeyedStateBackendBuilder<K> builderForTestDefaults(File instanceBasePath, TypeSerializer<K> keySerializer, int numKeyGroups, KeyGroupRange keyGroupRange, @Nonnull Collection<KeyedStateHandle> stateHandles) {
        return RocksDBTestUtils.builderForTestDefaults(instanceBasePath, keySerializer, EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB, numKeyGroups, keyGroupRange, stateHandles);
    }

    public static <K> RocksDBKeyedStateBackendBuilder<K> builderForTestDefaults(File instanceBasePath, TypeSerializer<K> keySerializer, EmbeddedRocksDBStateBackend.PriorityQueueStateType queueStateType, int numKeyGroups, KeyGroupRange keyGroupRange, @Nonnull Collection<KeyedStateHandle> stateHandles) {
        RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer();
        return new RocksDBKeyedStateBackendBuilder("no-op", ClassLoader.getSystemClassLoader(), instanceBasePath, optionsContainer, stateName -> optionsContainer.getColumnOptions(), new KvStateRegistry().createTaskRegistry(new JobID(), new JobVertexID()), keySerializer, numKeyGroups, keyGroupRange, new ExecutionConfig(), TestLocalRecoveryConfig.disabled(), RocksDBPriorityQueueConfig.buildWithPriorityQueueType((EmbeddedRocksDBStateBackend.PriorityQueueStateType)queueStateType), TtlTimeProvider.DEFAULT, LatencyTrackingStateConfig.disabled(), SizeTrackingStateConfig.disabled(), (MetricGroup)new UnregisteredMetricsGroup(), (key, value) -> {}, stateHandles, UncompressedStreamCompressionDecorator.INSTANCE, new CloseableRegistry());
    }

    public static <K> RocksDBKeyedStateBackendBuilder<K> builderForTestDB(File instanceBasePath, TypeSerializer<K> keySerializer, RocksDB db, ColumnFamilyHandle defaultCFHandle, ColumnFamilyOptions columnFamilyOptions) {
        RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer();
        return new RocksDBKeyedStateBackendBuilder("no-op", ClassLoader.getSystemClassLoader(), instanceBasePath, optionsContainer, stateName -> columnFamilyOptions, new KvStateRegistry().createTaskRegistry(new JobID(), new JobVertexID()), keySerializer, 2, new KeyGroupRange(0, 1), new ExecutionConfig(), TestLocalRecoveryConfig.disabled(), RocksDBPriorityQueueConfig.buildWithPriorityQueueType((EmbeddedRocksDBStateBackend.PriorityQueueStateType)EmbeddedRocksDBStateBackend.PriorityQueueStateType.HEAP), TtlTimeProvider.DEFAULT, LatencyTrackingStateConfig.disabled(), SizeTrackingStateConfig.disabled(), (MetricGroup)new UnregisteredMetricsGroup(), Collections.emptyList(), UncompressedStreamCompressionDecorator.INSTANCE, db, defaultCFHandle, new CloseableRegistry());
    }

    public static <K> RocksDBKeyedStateBackend<K> createKeyedStateBackend(EmbeddedRocksDBStateBackend rocksDbBackend, Environment env, TypeSerializer<K> keySerializer) throws IOException {
        return (RocksDBKeyedStateBackend)rocksDbBackend.createKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl(env, env.getJobID(), "test_op", keySerializer, 1, new KeyGroupRange(0, 0), env.getTaskKvStateRegistry(), TtlTimeProvider.DEFAULT, (MetricGroup)new UnregisteredMetricsGroup(), (name, value) -> {}, Collections.emptyList(), new CloseableRegistry(), 1.0));
    }
}

