/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.fs.cache.FileBasedCache;
import org.apache.flink.state.forst.fs.cache.FileCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDataOutputStream
extends FSDataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CachedDataOutputStream.class);
    private final Path originalPath;
    private final Path cachePath;
    @Nullable
    private FSDataOutputStream cacheOutputStream;
    private FSDataOutputStream originOutputStream;
    private final FileBasedCache fileBasedCache;

    public CachedDataOutputStream(Path originalPath, Path cachePath, FSDataOutputStream originalOutputStream, @Nullable FSDataOutputStream cacheOutputStream, FileBasedCache cache) {
        this.originOutputStream = originalOutputStream;
        this.originalPath = originalPath;
        this.cachePath = cachePath;
        this.cacheOutputStream = cacheOutputStream;
        this.fileBasedCache = cache;
        LOG.trace("Create CachedDataOutputStream for {} and {}", (Object)originalPath, (Object)cachePath);
    }

    public long getPos() throws IOException {
        if (this.cacheOutputStream == null) {
            return this.originOutputStream.getPos();
        }
        return this.cacheOutputStream.getPos();
    }

    public void write(int b) throws IOException {
        if (this.cacheOutputStream != null) {
            this.cacheOutputStream.write(b);
        }
        this.originOutputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (this.cacheOutputStream != null) {
            this.cacheOutputStream.write(b);
        }
        this.originOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.cacheOutputStream != null) {
            this.cacheOutputStream.write(b, off, len);
        }
        this.originOutputStream.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.cacheOutputStream != null) {
            this.cacheOutputStream.flush();
        }
        this.originOutputStream.flush();
    }

    public void sync() throws IOException {
        if (this.cacheOutputStream != null) {
            this.cacheOutputStream.sync();
        }
        this.originOutputStream.sync();
    }

    public void close() throws IOException {
        long size = this.getPos();
        if (this.originOutputStream != null) {
            this.originOutputStream.close();
            this.originOutputStream = null;
        }
        if (this.cacheOutputStream != null) {
            this.putIntoCache(size);
            this.cacheOutputStream.close();
            this.cacheOutputStream = null;
        } else {
            this.registerIntoCache(size);
        }
    }

    private void putIntoCache(long size) {
        FileCacheEntry fileCacheEntry = new FileCacheEntry(this.fileBasedCache, this.originalPath, this.cachePath, size);
        fileCacheEntry.switchStatus(FileCacheEntry.EntryStatus.REMOVED, FileCacheEntry.EntryStatus.LOADED);
        fileCacheEntry.loaded();
        this.fileBasedCache.addFirst(this.cachePath.toString(), fileCacheEntry);
    }

    private void registerIntoCache(long size) {
        FileCacheEntry fileCacheEntry = new FileCacheEntry(this.fileBasedCache, this.originalPath, this.cachePath, size);
        this.fileBasedCache.addSecond(this.cachePath.toString(), fileCacheEntry);
    }
}

