/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactory;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactoryUtils;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpointFactory;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestEndpointTestUtils;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestOptions;
import org.apache.flink.util.ConfigurationException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SqlGatewayRestEndpointTest {
    private static final String ADDRESS1 = "123.123.123.123";
    private static final String ADDRESS2 = "123.123.123.144";
    private static final String BIND_ADDRESS1 = "023.023.023.023";
    private static final String BIND_ADDRESS2 = "023.023.023.333";
    private static final String BIND_PORT1 = "7282";
    private static final String BIND_PORT2 = "7444";
    private static final String PORT1 = "7661";
    private static final String PORT2 = "7662";
    public static final String SQL_GATEWAY_ADDRESS = SqlGatewayRestEndpointTestUtils.getSqlGatewayRestOptionFullName(SqlGatewayRestOptions.ADDRESS.key());
    public static final String SQL_GATEWAY_BIND_ADDRESS = SqlGatewayRestEndpointTestUtils.getSqlGatewayRestOptionFullName(SqlGatewayRestOptions.BIND_ADDRESS.key());
    public static final String SQL_GATEWAY_BIND_PORT = SqlGatewayRestEndpointTestUtils.getSqlGatewayRestOptionFullName(SqlGatewayRestOptions.BIND_PORT.key());
    public static final String SQL_GATEWAY_PORT = SqlGatewayRestEndpointTestUtils.getSqlGatewayRestOptionFullName(SqlGatewayRestOptions.PORT.key());

    SqlGatewayRestEndpointTest() {
    }

    @Test
    void testIfSqlGatewayRestEndpointUseOverrideOptions() throws ConfigurationException {
        Configuration flinkConfig = new Configuration();
        flinkConfig.setString(RestOptions.ADDRESS.key(), ADDRESS1);
        flinkConfig.setString(RestOptions.BIND_ADDRESS.key(), BIND_ADDRESS1);
        flinkConfig.setString(RestOptions.BIND_PORT.key(), BIND_PORT1);
        flinkConfig.setString(RestOptions.PORT.key(), PORT1);
        flinkConfig.setString(SQL_GATEWAY_ADDRESS, ADDRESS2);
        flinkConfig.setString(SQL_GATEWAY_BIND_ADDRESS, BIND_ADDRESS2);
        flinkConfig.setString(SQL_GATEWAY_BIND_PORT, BIND_PORT2);
        flinkConfig.setString(SQL_GATEWAY_PORT, PORT2);
        Configuration sqlGatewayRestEndpointConfig = SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig);
        RestServerEndpointConfiguration result = RestServerEndpointConfiguration.fromConfiguration((Configuration)sqlGatewayRestEndpointConfig);
        Assertions.assertThat((String)result.getRestAddress()).isEqualTo(ADDRESS2);
        Assertions.assertThat((String)result.getRestBindAddress()).isEqualTo(BIND_ADDRESS2);
        Assertions.assertThat((String)result.getRestBindPortRange()).isEqualTo(BIND_PORT2);
    }

    @Test
    void testFallbackOptions() throws ConfigurationException {
        Configuration flinkConfig = new Configuration();
        flinkConfig.setString(SQL_GATEWAY_ADDRESS, ADDRESS2);
        RestServerEndpointConfiguration result1 = RestServerEndpointConfiguration.fromConfiguration((Configuration)SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig));
        Assertions.assertThat((String)result1.getRestBindPortRange()).isEqualTo("8083");
        flinkConfig.setString(SQL_GATEWAY_PORT, PORT2);
        result1 = RestServerEndpointConfiguration.fromConfiguration((Configuration)SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig));
        Assertions.assertThat((String)result1.getRestBindPortRange()).isEqualTo(PORT2);
    }

    @Test
    void testRequiredOptions() throws ConfigurationException {
        Configuration flinkConfig1 = new Configuration();
        SqlGatewayEndpointFactoryUtils.DefaultEndpointFactoryContext context = new SqlGatewayEndpointFactoryUtils.DefaultEndpointFactoryContext(null, flinkConfig1, SqlGatewayEndpointFactoryUtils.getEndpointConfig((Configuration)flinkConfig1, (String)"rest"));
        SqlGatewayEndpointFactoryUtils.EndpointFactoryHelper endpointFactoryHelper = SqlGatewayEndpointFactoryUtils.createEndpointFactoryHelper((SqlGatewayEndpointFactory)new SqlGatewayRestEndpointFactory(), (SqlGatewayEndpointFactory.Context)context);
        Assertions.assertThatThrownBy(() -> ((SqlGatewayEndpointFactoryUtils.EndpointFactoryHelper)endpointFactoryHelper).validate()).isInstanceOf(ValidationException.class);
        flinkConfig1.setString(SQL_GATEWAY_ADDRESS, ADDRESS2);
        RestServerEndpointConfiguration result = RestServerEndpointConfiguration.fromConfiguration((Configuration)SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig1));
        Assertions.assertThat((String)result.getRestAddress()).isEqualTo(ADDRESS2);
        Configuration flinkConfig2 = new Configuration();
        flinkConfig2.setString(SQL_GATEWAY_BIND_PORT, BIND_PORT2);
        context = new SqlGatewayEndpointFactoryUtils.DefaultEndpointFactoryContext(null, flinkConfig2, SqlGatewayEndpointFactoryUtils.getEndpointConfig((Configuration)flinkConfig2, (String)"rest"));
        endpointFactoryHelper = SqlGatewayEndpointFactoryUtils.createEndpointFactoryHelper((SqlGatewayEndpointFactory)new SqlGatewayRestEndpointFactory(), (SqlGatewayEndpointFactory.Context)context);
        Assertions.assertThatThrownBy(() -> ((SqlGatewayEndpointFactoryUtils.EndpointFactoryHelper)endpointFactoryHelper).validate()).isInstanceOf(ValidationException.class);
        Configuration flinkConfig3 = new Configuration();
        flinkConfig3.setString(SQL_GATEWAY_PORT, PORT2);
        context = new SqlGatewayEndpointFactoryUtils.DefaultEndpointFactoryContext(null, flinkConfig3, SqlGatewayEndpointFactoryUtils.getEndpointConfig((Configuration)flinkConfig3, (String)"rest"));
        endpointFactoryHelper = SqlGatewayEndpointFactoryUtils.createEndpointFactoryHelper((SqlGatewayEndpointFactory)new SqlGatewayRestEndpointFactory(), (SqlGatewayEndpointFactory.Context)context);
        Assertions.assertThatThrownBy(() -> ((SqlGatewayEndpointFactoryUtils.EndpointFactoryHelper)endpointFactoryHelper).validate()).isInstanceOf(ValidationException.class);
        flinkConfig1.setString(SQL_GATEWAY_PORT, PORT2);
        result = RestServerEndpointConfiguration.fromConfiguration((Configuration)SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig1));
        Assertions.assertThat((String)result.getRestAddress()).isEqualTo(ADDRESS2);
        Assertions.assertThat((String)result.getRestBindPortRange()).isEqualTo(PORT2);
        flinkConfig1.setString(SQL_GATEWAY_BIND_PORT, BIND_PORT2);
        result = RestServerEndpointConfiguration.fromConfiguration((Configuration)SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig1));
        Assertions.assertThat((String)result.getRestAddress()).isEqualTo(ADDRESS2);
        Assertions.assertThat((String)result.getRestBindPortRange()).isEqualTo(BIND_PORT2);
        Configuration flinkConfig4 = new Configuration();
        flinkConfig4.setString(SQL_GATEWAY_ADDRESS, ADDRESS2);
        flinkConfig4.setString(SQL_GATEWAY_BIND_PORT, BIND_PORT2);
        result = RestServerEndpointConfiguration.fromConfiguration((Configuration)SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig1));
        Assertions.assertThat((String)result.getRestAddress()).isEqualTo(ADDRESS2);
        Assertions.assertThat((String)result.getRestBindPortRange()).isEqualTo(BIND_PORT2);
    }
}

