/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.application;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.flink.table.gateway.service.application.Printer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrinterTest {
    private OutputStream outputStream;
    private Printer printer;

    PrinterTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.outputStream = new ByteArrayOutputStream(1024);
        this.printer = new Printer(this.outputStream);
    }

    @AfterEach
    void afterEach() throws Exception {
        this.outputStream.close();
    }

    @Test
    void testPrintSingleInput() {
        this.printer.print("This is a sentence.\n");
        Assertions.assertThat((String)this.outputStream.toString()).isEqualTo("Flink SQL> This is a sentence.\n");
    }

    @Test
    void testPrintMultipleLineInputs() {
        this.printer.print("This is a sentence.\n\nThis is another sentence.\n");
        Assertions.assertThat((String)this.outputStream.toString()).isEqualTo("Flink SQL> This is a sentence.\n> \n> This is another sentence.\n");
    }
}

