/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.shaded.guava33.com.google.common.cache.CacheStats;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.AbstractSqlGatewayStatementITCase;
import org.apache.flink.table.gateway.AbstractSqlGatewayStatementITCaseBase;
import org.apache.flink.table.gateway.api.config.SqlGatewayServiceConfigOptions;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.MockedEndpointVersion;
import org.apache.flink.table.gateway.service.SqlGatewayServiceImpl;
import org.apache.flink.table.gateway.service.utils.SqlGatewayServiceTestUtil;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.RowDataToStringConverterImpl;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SqlGatewayServiceStatementITCase
extends AbstractSqlGatewayStatementITCase {
    private static final SessionEnvironment DEFAULT_SESSION_ENVIRONMENT = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build();
    private static final SessionEnvironment SESSION_ENVIRONMENT_WITH_PLAN_CACHE_ENABLED = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).addSessionConfig(Collections.singletonMap(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_PLAN_CACHE_ENABLED.key(), "true")).build();
    private SessionHandle sessionHandle;

    @Parameters(name="parameters={0}")
    public static List<AbstractSqlGatewayStatementITCaseBase.TestParameters> parameters() throws Exception {
        return SqlGatewayServiceStatementITCase.listFlinkSqlTests().stream().map(path -> new StatementTestParameters((String)path, path.endsWith("repeated_dql.q"))).collect(Collectors.toList());
    }

    @Override
    @BeforeEach
    public void before(@TempDir Path temporaryFolder) throws Exception {
        super.before(temporaryFolder);
        SessionEnvironment sessionEnvironment = this.isPlanCacheEnabled() ? SESSION_ENVIRONMENT_WITH_PLAN_CACHE_ENABLED : DEFAULT_SESSION_ENVIRONMENT;
        this.sessionHandle = service.openSession(sessionEnvironment);
    }

    @AfterEach
    public void after() {
        if (this.isPlanCacheEnabled()) {
            CacheStats cacheStats = ((SqlGatewayServiceImpl)service).getSession(this.sessionHandle).getPlanCacheManager().getCacheStats();
            Assertions.assertThat((Object)cacheStats).isEqualTo((Object)new CacheStats(4L, 14L, 0L, 0L, 0L, 0L));
        }
    }

    @Override
    protected String runSingleStatement(String statement) throws Exception {
        OperationHandle operationHandle = service.executeStatement(this.sessionHandle, statement, -1L, new Configuration());
        CommonTestUtils.waitUtil(() -> service.getOperationInfo(this.sessionHandle, operationHandle).getStatus().isTerminalStatus(), (Duration)Duration.ofSeconds(100L), (String)"Failed to wait operation finish.");
        ResultSet resultSet = service.fetchResults(this.sessionHandle, operationHandle, 0L, Integer.MAX_VALUE);
        return this.toString(AbstractSqlGatewayStatementITCaseBase.StatementType.match(statement), resultSet.getResultSchema(), (RowDataToStringConverter)new RowDataToStringConverterImpl(resultSet.getResultSchema().toPhysicalRowDataType(), DateTimeUtils.UTC_ZONE.toZoneId(), SqlGatewayServiceStatementITCase.class.getClassLoader(), false, new CodeGeneratorContext((ReadableConfig)new Configuration(), SqlGatewayServiceStatementITCase.class.getClassLoader())), new RowDataIterator(this.sessionHandle, operationHandle));
    }

    private boolean isPlanCacheEnabled() {
        return this.parameters != null && ((StatementTestParameters)this.parameters).isPlanCacheEnabled();
    }

    @Override
    protected String stringifyException(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null && root.getCause().getMessage() != null && !root.getCause().getMessage().isEmpty()) {
            root = root.getCause();
        }
        return root.getClass().getName() + ": " + root.getMessage();
    }

    @Override
    protected boolean isStreaming() {
        return ((RuntimeExecutionMode)Configuration.fromMap((Map)service.getSessionConfig(this.sessionHandle)).get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING);
    }

    @Test
    void testIsQueryResult() throws Exception {
        SessionHandle sessionHandle = SqlGatewayServiceTestUtil.createInitializedSession(service);
        BiFunction<SessionHandle, OperationHandle, Boolean> isQueryResultGetter = (sessionHandle1, operationHandle) -> SqlGatewayServiceTestUtil.fetchResults(service, sessionHandle1, operationHandle).isQueryResult();
        this.validateResultSetField(sessionHandle, "SELECT * FROM cat1.db1.tbl1;", isQueryResultGetter, true);
        this.validateResultSetField(sessionHandle, "WITH hub AS (SELECT * FROM cat1.db1.tbl1)\nSELECT * FROM hub;", isQueryResultGetter, true);
        this.validateResultSetField(sessionHandle, "INSERT INTO cat1.db1.tbl1 SELECT * FROM cat1.db1.tbl2;", isQueryResultGetter, false);
    }

    @Test
    void testHasJobID() throws Exception {
        SessionHandle sessionHandle = SqlGatewayServiceTestUtil.createInitializedSession(service);
        BiFunction<SessionHandle, OperationHandle, Boolean> hasJobIDGetter = (sessionHandle1, operationHandle) -> SqlGatewayServiceTestUtil.fetchResults(service, sessionHandle1, operationHandle).getJobID() != null;
        this.validateResultSetField(sessionHandle, "SELECT * FROM cat1.db1.tbl1;", hasJobIDGetter, true);
        this.validateResultSetField(sessionHandle, "INSERT INTO cat1.db1.tbl1 SELECT * FROM cat1.db1.tbl2;", hasJobIDGetter, true);
        this.validateResultSetField(sessionHandle, "CREATE TABLE test (f0 INT) WITH ('connector' = 'values');", hasJobIDGetter, false);
    }

    @Test
    void testResultKind() throws Exception {
        SessionHandle sessionHandle = SqlGatewayServiceTestUtil.createInitializedSession(service);
        BiFunction<SessionHandle, OperationHandle, ResultKind> resultKindGetter = (sessionHandle1, operationHandle) -> SqlGatewayServiceTestUtil.fetchResults(service, sessionHandle1, operationHandle).getResultKind();
        this.validateResultSetField(sessionHandle, "SELECT * FROM cat1.db1.tbl1;", resultKindGetter, ResultKind.SUCCESS_WITH_CONTENT);
        this.validateResultSetField(sessionHandle, "INSERT INTO cat1.db1.tbl1 SELECT * FROM cat1.db1.tbl2;", resultKindGetter, ResultKind.SUCCESS_WITH_CONTENT);
        this.validateResultSetField(sessionHandle, "CREATE TABLE test (f0 INT) WITH ('connector' = 'values');", resultKindGetter, ResultKind.SUCCESS);
        this.validateResultSetField(sessionHandle, "SET 'key' = 'value';", resultKindGetter, ResultKind.SUCCESS);
        this.validateResultSetField(sessionHandle, "SET;", resultKindGetter, ResultKind.SUCCESS_WITH_CONTENT);
    }

    private <T> void validateResultSetField(SessionHandle sessionHandle, String statement, BiFunction<SessionHandle, OperationHandle, T> resultGetter, T expected) throws Exception {
        OperationHandle operationHandle = service.executeStatement(sessionHandle, statement, -1L, new Configuration());
        SqlGatewayServiceTestUtil.awaitOperationTermination(service, sessionHandle, operationHandle);
        Assertions.assertThat(resultGetter.apply(sessionHandle, operationHandle)).isEqualTo(expected);
    }

    private static class StatementTestParameters
    extends AbstractSqlGatewayStatementITCaseBase.TestParameters {
        private final boolean planCacheEnabled;

        public StatementTestParameters(String sqlPath, boolean planCacheEnabled) {
            super(sqlPath);
            this.planCacheEnabled = planCacheEnabled;
        }

        public boolean isPlanCacheEnabled() {
            return this.planCacheEnabled;
        }

        @Override
        public String toString() {
            return "StatementTestParameters{planCacheEnabled=" + this.planCacheEnabled + ", sqlPath='" + this.sqlPath + "'}";
        }
    }

    private static class RowDataIterator
    implements Iterator<RowData> {
        private final SessionHandle sessionHandle;
        private final OperationHandle operationHandle;
        private Long token = 0L;
        private Iterator<RowData> fetchedRows = Collections.emptyIterator();

        public RowDataIterator(SessionHandle sessionHandle, OperationHandle operationHandle) {
            this.sessionHandle = sessionHandle;
            this.operationHandle = operationHandle;
            this.fetch();
        }

        @Override
        public boolean hasNext() {
            while (this.token != null && !this.fetchedRows.hasNext()) {
                this.fetch();
            }
            return this.token != null;
        }

        @Override
        public RowData next() {
            return this.fetchedRows.next();
        }

        private void fetch() {
            ResultSet resultSet = service.fetchResults(this.sessionHandle, this.operationHandle, this.token.longValue(), Integer.MAX_VALUE);
            this.token = resultSet.getNextToken();
            this.fetchedRows = resultSet.getData().iterator();
        }
    }
}

