/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.RestAPIITCaseBase;
import org.apache.flink.table.gateway.rest.header.session.OpenSessionHeaders;
import org.apache.flink.table.gateway.rest.header.statement.CompleteStatementHeaders;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionRequestBody;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionResponseBody;
import org.apache.flink.table.gateway.rest.message.session.SessionMessageParameters;
import org.apache.flink.table.gateway.rest.message.statement.CompleteStatementRequestBody;
import org.apache.flink.table.gateway.rest.message.statement.CompleteStatementResponseBody;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StatementRelatedITCase
extends RestAPIITCaseBase {
    private SessionHandle sessionHandle;
    private SessionMessageParameters sessionMessageParameters;

    StatementRelatedITCase() {
    }

    @BeforeEach
    void setUp() throws Exception {
        CompletableFuture response = this.sendRequest(OpenSessionHeaders.getInstance(), EmptyMessageParameters.getInstance(), new OpenSessionRequestBody(null, null));
        this.sessionHandle = new SessionHandle(UUID.fromString(((OpenSessionResponseBody)response.get()).getSessionHandle()));
        this.sessionMessageParameters = new SessionMessageParameters(this.sessionHandle);
    }

    @Test
    void testCompleteStatement() throws Exception {
        CompletableFuture completeStatementResponse = this.sendRequest(CompleteStatementHeaders.getInstance(), this.sessionMessageParameters, new CompleteStatementRequestBody("CREATE TA", 9));
        Assertions.assertThat((List)((CompleteStatementResponseBody)completeStatementResponse.get()).getCandidates()).isEqualTo(Collections.singletonList("TABLE"));
    }
}

