/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.table.gateway.AbstractSqlGatewayStatementITCaseBase;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.service.utils.SqlGatewayServiceExtension;
import org.apache.flink.table.gateway.utils.TestSqlStatement;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class AbstractSqlGatewayStatementITCase
extends AbstractSqlGatewayStatementITCaseBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSqlGatewayStatementITCase.class);
    @RegisterExtension
    @Order(value=1)
    public static final MiniClusterExtension MINI_CLUSTER = new MiniClusterExtension();
    @RegisterExtension
    @Order(value=2)
    public static final SqlGatewayServiceExtension SQL_GATEWAY_SERVICE_EXTENSION = new SqlGatewayServiceExtension(() -> ((MiniClusterExtension)MINI_CLUSTER).getClientConfiguration());
    protected static SqlGatewayService service;

    @BeforeAll
    static void setUp() {
        service = SQL_GATEWAY_SERVICE_EXTENSION.getService();
    }

    @Override
    @BeforeEach
    public void before(@TempDir Path temporaryFolder) throws Exception {
        super.before(temporaryFolder);
        this.replaceVars.put("$VAR_REST_PORT", ((Integer)MINI_CLUSTER.getClientConfiguration().get(RestOptions.PORT)).toString());
    }

    @Override
    protected String runStatements(List<TestSqlStatement> statements) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        for (TestSqlStatement statement : statements) {
            StringBuilder builder = new StringBuilder();
            builder.append(statement.getComment());
            builder.append(statement.getSql());
            String trimmedSql = statement.getSql().trim();
            if (trimmedSql.endsWith(";")) {
                trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
            }
            try {
                builder.append(this.runSingleStatement(trimmedSql));
            }
            catch (Throwable t) {
                LOG.error("Failed to execute statements.", t);
                builder.append(AbstractSqlGatewayStatementITCaseBase.Tag.ERROR.addTag(this.removeRowNumber(this.stringifyException(t).trim()) + "\n"));
            }
            output.add(builder.toString());
        }
        return String.join((CharSequence)"", output);
    }

    protected abstract String runSingleStatement(String var1) throws Exception;

    protected abstract String stringifyException(Throwable var1);
}

