/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.checkpoints.AbstractCheckpointHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointMessageParameters;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatistics;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;

public class CheckpointStatisticDetailsHandler
extends AbstractCheckpointHandler<CheckpointStatistics, CheckpointMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    public CheckpointStatisticDetailsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, CheckpointStatistics, CheckpointMessageParameters> messageHeaders, Executor executor, Cache<JobID, CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotCache, CheckpointStatsCache checkpointStatsCache) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executor, checkpointStatsSnapshotCache, checkpointStatsCache);
    }

    @Override
    protected CheckpointStatistics handleCheckpointRequest(HandlerRequest<EmptyRequestBody> ignored, AbstractCheckpointStats checkpointStats) {
        return CheckpointStatistics.generateCheckpointStatistics(checkpointStats, true);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        CheckpointStatsSnapshot stats = graph.getCheckpointStatsSnapshot();
        if (stats == null) {
            return Collections.emptyList();
        }
        CheckpointStatsHistory history = stats.getHistory();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(history.getCheckpoints().size());
        for (AbstractCheckpointStats checkpoint : history.getCheckpoints()) {
            CheckpointStatistics json = CheckpointStatistics.generateCheckpointStatistics(checkpoint, true);
            String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":checkpointid", String.valueOf(checkpoint.getCheckpointId()));
            archive.add(new ArchivedJson(path, json));
        }
        return archive;
    }
}

