/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class SlotAllocationTest {
    private static final FilterFunction<Long> DUMMY_FILTER = (FilterFunction & Serializable)value -> false;

    SlotAllocationTest() {
    }

    @Test
    void testTwoPipelines() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromSequence(1L, 10L).filter(DUMMY_FILTER).slotSharingGroup("isolated").filter(DUMMY_FILTER).slotSharingGroup("default").disableChaining().filter(DUMMY_FILTER).slotSharingGroup("group 1").filter(DUMMY_FILTER).startNewChain().print().disableChaining();
        env.fromSequence(1L, 10L).filter(DUMMY_FILTER).slotSharingGroup("isolated-2").filter(DUMMY_FILTER).slotSharingGroup("default").disableChaining().filter(DUMMY_FILTER).slotSharingGroup("group 2").filter(DUMMY_FILTER).startNewChain().print().disableChaining();
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup())).isNotEqualTo((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup()).isNotEqualTo((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(6)).getSlotSharingGroup());
        int pipelineStart = 6;
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(pipelineStart + 2)).getSlotSharingGroup())).isNotEqualTo((Object)((JobVertex)vertices.get(pipelineStart + 1)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(pipelineStart + 2)).getSlotSharingGroup()).isNotEqualTo((Object)((JobVertex)vertices.get(pipelineStart + 3)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(pipelineStart + 3)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(pipelineStart + 4)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(pipelineStart + 4)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(pipelineStart + 5)).getSlotSharingGroup());
    }

    @Test
    void testUnion() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src1 = env.fromSequence(1L, 10L);
        SingleOutputStreamOperator src2 = env.fromSequence(1L, 10L).slotSharingGroup("src-1");
        src1.union(new DataStream[]{src2}).filter(DUMMY_FILTER);
        SingleOutputStreamOperator src3 = env.fromSequence(1L, 10L).slotSharingGroup("group-1");
        SingleOutputStreamOperator src4 = env.fromSequence(1L, 10L).slotSharingGroup("group-1");
        src3.union(new DataStream[]{src4}).filter(DUMMY_FILTER);
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup())).isNotEqualTo((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup()).isNotEqualTo((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup())).isEqualTo((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
    }

    @Test
    void testInheritOverride() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator src1 = env.fromSequence(1L, 10L).slotSharingGroup("group-1");
        SingleOutputStreamOperator src2 = env.fromSequence(1L, 10L).slotSharingGroup("group-1");
        src1.union(new DataStream[]{src2}).filter(DUMMY_FILTER).slotSharingGroup("default");
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup())).isNotEqualTo((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup()).isNotEqualTo((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup());
    }

    @Test
    void testCoOperation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        CoMapFunction<Long, Long, Long> dummyCoMap = new CoMapFunction<Long, Long, Long>(){

            public Long map1(Long value) throws Exception {
                return null;
            }

            public Long map2(Long value) throws Exception {
                return null;
            }
        };
        DataStreamSource src1 = env.fromSequence(1L, 10L);
        SingleOutputStreamOperator src2 = env.fromSequence(1L, 10L).slotSharingGroup("src-1");
        src1.connect((DataStream)src2).map((CoMapFunction)dummyCoMap);
        SingleOutputStreamOperator src3 = env.fromSequence(1L, 10L).slotSharingGroup("group-1");
        SingleOutputStreamOperator src4 = env.fromSequence(1L, 10L).slotSharingGroup("group-1");
        src3.connect((DataStream)src4).map((CoMapFunction)dummyCoMap);
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup())).isNotEqualTo((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup()).isNotEqualTo((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        ((ObjectAssert)Assertions.assertThat((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup())).isEqualTo((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
        Assertions.assertThat((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup()).isEqualTo((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
    }
}

