/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotMatchingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TestingSlot;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class AbstractSlotMatchingResolverTest {
    public static final SlotSharingGroup SLOT_SHARING_GROUP = new SlotSharingGroup();
    protected final TaskManagerLocation tml1 = new LocalTaskManagerLocation();
    protected final TestingSlot slot1OfTml1 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml1);
    protected final TestingSlot slot2OfTml1 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml1);
    protected final TestingSlot slot3OfTml1 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml1);
    protected final TaskManagerLocation tml2 = new LocalTaskManagerLocation();
    protected final TestingSlot slot1OfTml2 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml2);
    protected final TestingSlot slot2OfTml2 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml2);
    protected final TestingSlot slot3OfTml2 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml2);
    protected final TaskManagerLocation tml3 = new LocalTaskManagerLocation();
    protected final TestingSlot slot1OfTml3 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml3);
    protected final TestingSlot slot2OfTml3 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml3);
    protected final TestingSlot slot3OfTml3 = AbstractSlotMatchingResolverTest.createAnySlotOf(this.tml3);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup1 = AbstractSlotMatchingResolverTest.createGroup(1);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup2 = AbstractSlotMatchingResolverTest.createGroup(2);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup3 = AbstractSlotMatchingResolverTest.createGroup(3);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup4 = AbstractSlotMatchingResolverTest.createGroup(4);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup5 = AbstractSlotMatchingResolverTest.createGroup(5);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup6 = AbstractSlotMatchingResolverTest.createGroup(6);
    protected final SlotSharingSlotAllocator.ExecutionSlotSharingGroup requestGroup7 = AbstractSlotMatchingResolverTest.createGroup(7);
    protected final List<PhysicalSlot> freeSlots = Arrays.asList(this.slot1OfTml1, this.slot2OfTml1, this.slot3OfTml1, this.slot1OfTml2, this.slot2OfTml2, this.slot3OfTml2, this.slot1OfTml3, this.slot2OfTml3, this.slot3OfTml3);
    protected final List<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> requestedGroups = Arrays.asList(this.requestGroup1, this.requestGroup2, this.requestGroup3, this.requestGroup4, this.requestGroup5, this.requestGroup6, this.requestGroup7);
    protected SlotMatchingResolver slotMatchingResolver;

    AbstractSlotMatchingResolverTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.slotMatchingResolver = this.createSlotMatchingResolver();
    }

    protected abstract SlotMatchingResolver createSlotMatchingResolver();

    protected abstract void assertAssignments(Collection<JobSchedulingPlan.SlotAssignment> var1);

    @Test
    void testMatchSlotSharingGroupWithSlots() {
        Collection slotAssignments = this.slotMatchingResolver.matchSlotSharingGroupWithSlots(this.requestedGroups, this.freeSlots);
        this.assertAssignments(slotAssignments);
    }

    @Nonnull
    protected static Map<TaskManagerLocation, Set<JobSchedulingPlan.SlotAssignment>> getAssignmentsPerTaskManager(Collection<JobSchedulingPlan.SlotAssignment> assignments) {
        return assignments.stream().collect(Collectors.groupingBy(assignment -> assignment.getSlotInfo().getTaskManagerLocation(), Collectors.toSet()));
    }

    private static TestingSlot createAnySlotOf(TaskManagerLocation tml) {
        return new TestingSlot(new AllocationID(), ResourceProfile.ANY, tml);
    }

    private static SlotSharingSlotAllocator.ExecutionSlotSharingGroup createGroup(int executionVertices) {
        return new SlotSharingSlotAllocator.ExecutionSlotSharingGroup(SLOT_SHARING_GROUP, IntStream.range(0, executionVertices).mapToObj(ignored -> new ExecutionVertexID(new JobVertexID(), 0)).collect(Collectors.toSet()));
    }
}

