/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.compatibility;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.runtime.rest.compatibility.CompatibilityCheckResult;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.util.Preconditions;

final class CompatibilityRoutine<C> {
    private final String key;
    private final Class<C> containerClass;
    private final Function<MessageHeaders<?, ?, ?>, C> extractor;
    private final BiConsumer<C, C> assertion;

    CompatibilityRoutine(String key, Class<C> containerClass, Function<MessageHeaders<?, ?, ?>, C> extractor, BiConsumer<C, C> assertion) {
        this.key = key;
        this.containerClass = containerClass;
        this.extractor = extractor;
        this.assertion = assertion;
    }

    String getKey() {
        return this.key;
    }

    Class<C> getContainerClass() {
        return this.containerClass;
    }

    C getContainer(MessageHeaders<?, ?, ?> header) {
        C container = this.extractor.apply(header);
        Preconditions.checkNotNull(container, (String)"Implementation error: Extractor returned null.");
        return container;
    }

    CompatibilityCheckResult checkCompatibility(Optional<C> old, Optional<C> cur) {
        Preconditions.checkArgument((old.isPresent() || cur.isPresent() ? 1 : 0) != 0, (String)"Implementation error: Compatibility check container for routine %s for both old and new version is null.", (Object[])new Object[]{this.key});
        if (!old.isPresent()) {
            return CompatibilityCheckResult.compatible();
        }
        if (!cur.isPresent()) {
            return CompatibilityCheckResult.incompatible(new AssertionError((Object)String.format("Compatibility check container for routine %s not found in current version.", this.key)));
        }
        try {
            this.assertion.accept(old.get(), cur.get());
        }
        catch (AssertionError e) {
            AssertionError backwardIncompatibilityCause = new AssertionError((Object)(this.key + ": " + ((Throwable)((Object)e)).getMessage()));
            return CompatibilityCheckResult.incompatible(backwardIncompatibilityCause);
        }
        try {
            this.assertion.accept(cur.get(), old.get());
            return CompatibilityCheckResult.identical();
        }
        catch (AssertionError e) {
            return CompatibilityCheckResult.compatible();
        }
    }
}

