/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.operators.AbstractOuterJoinDriver;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.testutils.BinaryOperatorTestBase;
import org.apache.flink.runtime.operators.testutils.DelayingIterator;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.runtime.operators.testutils.InfiniteIntTupleIterator;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;
import org.apache.flink.util.Collector;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.TestTemplate;

abstract class AbstractOuterJoinTaskTest
extends BinaryOperatorTestBase<FlatJoinFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
    private static final long HASH_MEM = 0x600000L;
    private static final long SORT_MEM = 0x300000L;
    private static final int NUM_SORTER = 2;
    private static final long BNLJN_MEM = 327680L;
    private final double bnljn_frac;
    protected final TypeComparator<Tuple2<Integer, Integer>> comparator1 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
    protected final TypeComparator<Tuple2<Integer, Integer>> comparator2 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
    protected final List<Tuple2<Integer, Integer>> outList = new ArrayList<Tuple2<Integer, Integer>>();
    protected final TypeSerializer<Tuple2<Integer, Integer>> serializer = new TupleSerializer(Tuple2.class, new TypeSerializer[]{IntSerializer.INSTANCE, IntSerializer.INSTANCE});

    AbstractOuterJoinTaskTest(ExecutionConfig config) {
        super(config, 0x600000L, 2, 0x300000L);
        this.bnljn_frac = 327680.0 / (double)this.getMemoryManager().getMemorySize();
    }

    @TestTemplate
    void testSortBoth1OuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        boolean valCnt1 = true;
        int keyCnt2 = 10;
        int valCnt2 = 2;
        this.testSortBothOuterJoinTask(20, 1, 10, 2);
    }

    @TestTemplate
    void testSortBoth2OuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        boolean valCnt1 = true;
        int keyCnt2 = 20;
        boolean valCnt2 = true;
        this.testSortBothOuterJoinTask(20, 1, 20, 1);
    }

    @TestTemplate
    void testSortBoth3OuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 1;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.testSortBothOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @TestTemplate
    void testSortBoth4OuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 1;
        this.testSortBothOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @TestTemplate
    void testSortBoth5OuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.testSortBothOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @TestTemplate
    void testSortBoth6OuterJoinTask() throws Exception {
        int keyCnt1 = 10;
        int valCnt1 = 1;
        int keyCnt2 = 20;
        int valCnt2 = 2;
        this.testSortBothOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    private void testSortBothOuterJoinTask(int keyCnt1, int valCnt1, int keyCnt2, int valCnt2) throws Exception {
        this.setOutput(this.outList, this.serializer);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInputSorted(new UniformIntTupleGenerator(keyCnt1, valCnt1, false), this.serializer, this.comparator1.duplicate());
        this.addInputSorted(new UniformIntTupleGenerator(keyCnt2, valCnt2, false), this.serializer, this.comparator2.duplicate());
        this.testDriver((Driver)testTask, MockJoinStub.class);
        int expCnt = this.calculateExpectedCount(keyCnt1, valCnt1, keyCnt2, valCnt2);
        ((ListAssert)Assertions.assertThat(this.outList).withFailMessage("Result set size was %d. Expected was %d", new Object[]{this.outList.size(), expCnt})).hasSize(expCnt);
        this.outList.clear();
    }

    @TestTemplate
    void testSortFirstOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.setOutput(this.outList, this.serializer);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInputSorted(new UniformIntTupleGenerator(keyCnt1, valCnt1, false), this.serializer, this.comparator1.duplicate());
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, true), this.serializer);
        this.testDriver((Driver)testTask, MockJoinStub.class);
        int expCnt = this.calculateExpectedCount(keyCnt1, valCnt1, keyCnt2, valCnt2);
        ((ListAssert)Assertions.assertThat(this.outList).withFailMessage("Result set size was %d. Expected was %d", new Object[]{this.outList.size(), expCnt})).hasSize(expCnt);
        this.outList.clear();
    }

    @TestTemplate
    void testSortSecondOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.setOutput(this.outList, this.serializer);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, true), this.serializer);
        this.addInputSorted(new UniformIntTupleGenerator(keyCnt2, valCnt2, false), this.serializer, this.comparator2.duplicate());
        this.testDriver((Driver)testTask, MockJoinStub.class);
        int expCnt = this.calculateExpectedCount(keyCnt1, valCnt1, keyCnt2, valCnt2);
        ((ListAssert)Assertions.assertThat(this.outList).withFailMessage("Result set size was %d. Expected was %d", new Object[]{this.outList.size(), expCnt})).hasSize(expCnt);
        this.outList.clear();
    }

    @TestTemplate
    void testMergeOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.setOutput(this.outList, this.serializer);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, true), this.serializer);
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, true), this.serializer);
        this.testDriver((Driver)testTask, MockJoinStub.class);
        int expCnt = this.calculateExpectedCount(keyCnt1, valCnt1, keyCnt2, valCnt2);
        ((ListAssert)Assertions.assertThat(this.outList).withFailMessage("Result set size was %d. Expected was %d", new Object[]{this.outList.size(), expCnt})).hasSize(expCnt);
        this.outList.clear();
    }

    @TestTemplate
    void testFailingOuterJoinTask() {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, true), this.serializer);
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, true), this.serializer);
        Assertions.assertThatThrownBy(() -> this.testDriver((Driver)testTask, MockFailingJoinStub.class)).isInstanceOf(ExpectedTestException.class);
    }

    @TestTemplate
    void testCancelOuterJoinTaskWhileSort1() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInputSorted(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer, this.comparator1.duplicate());
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileSort1()"){

            @Override
            public void run() {
                try {
                    AbstractOuterJoinTaskTest.this.testDriver((Driver)testTask, MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.interrupt();
        taskRunner.join(60000L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)taskRunner.isAlive()).withFailMessage("Task thread did not finish within 60 seconds", new Object[0])).isFalse();
        Assertions.assertThat((Throwable)((Throwable)error.get())).isNull();
    }

    @TestTemplate
    void testCancelOuterJoinTaskWhileSort2() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 1), this.serializer);
        this.addInputSorted(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 1), this.serializer, this.comparator2.duplicate());
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileSort2()"){

            @Override
            public void run() {
                try {
                    AbstractOuterJoinTaskTest.this.testDriver((Driver)testTask, MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.interrupt();
        taskRunner.join(60000L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)taskRunner.isAlive()).withFailMessage("Task thread did not finish within 60 seconds", new Object[0])).isFalse();
        Assertions.assertThat((Throwable)((Throwable)error.get())).isNull();
    }

    @TestTemplate
    void testCancelOuterJoinTaskWhileRunning() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortDriverStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileRunning()"){

            @Override
            public void run() {
                try {
                    AbstractOuterJoinTaskTest.this.testDriver((Driver)testTask, MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.interrupt();
        taskRunner.join(60000L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)taskRunner.isAlive()).withFailMessage("Task thread did not finish within 60 seconds", new Object[0])).isFalse();
        Assertions.assertThat((Throwable)((Throwable)error.get())).isNull();
    }

    protected abstract AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> getOuterJoinDriver();

    protected abstract int calculateExpectedCount(int var1, int var2, int var3, int var4);

    protected abstract DriverStrategy getSortDriverStrategy();

    public static final class MockFailingJoinStub
    implements FlatJoinFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        private int cnt = 0;

        public void join(Tuple2<Integer, Integer> first, Tuple2<Integer, Integer> second, Collector<Tuple2<Integer, Integer>> out) throws Exception {
            if (++this.cnt >= 10) {
                throw new ExpectedTestException();
            }
            out.collect(first != null ? first : second);
        }
    }

    public static final class MockJoinStub
    implements FlatJoinFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        public void join(Tuple2<Integer, Integer> first, Tuple2<Integer, Integer> second, Collector<Tuple2<Integer, Integer>> out) throws Exception {
            out.collect(first != null ? first : second);
        }
    }
}

