/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.EventOptions;
import org.apache.flink.events.reporter.EventReporter;
import org.apache.flink.events.reporter.EventReporterFactory;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.runtime.metrics.EventReporterSetup;
import org.apache.flink.runtime.metrics.ReporterSetupBuilder;
import org.apache.flink.runtime.metrics.filter.DefaultReporterFilters;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.TestEventReporter;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.apache.flink.util.TestLoggerExtension;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={TestLoggerExtension.class})
class EventSetupTest {
    @RegisterExtension
    static final ContextClassLoaderExtension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(EventReporterFactory.class, new String[]{TestEventReporter1.class.getName(), TestEventReporter2.class.getName(), TestEventReporter11.class.getName(), TestEventReporter12.class.getName(), TestEventReporter13.class.getName(), TestEventReporterFactory.class.getName(), FailingFactory.class.getName(), ConfigExposingReporterFactory.class.getName()}).build();

    EventSetupTest() {
    }

    @Test
    void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        EventSetupTest.configureReporter1(config);
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        EventReporterSetup reporterSetup = (EventReporterSetup)reporterSetups.get(0);
        EventSetupTest.assertEventReporter1Configured(reporterSetup);
    }

    @Test
    void testSeveralReportersWithArgumentForwarding() {
        Configuration config = new Configuration();
        EventSetupTest.configureReporter1(config);
        EventSetupTest.configureReporter2(config);
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)2L, (long)reporterSetups.size());
        Optional<EventReporterSetup> reporter1Config = reporterSetups.stream().filter(c -> "reporter1".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter1Config.isPresent());
        EventSetupTest.assertEventReporter1Configured(reporter1Config.get());
        Optional<EventReporterSetup> reporter2Config = reporterSetups.stream().filter(c -> "reporter2".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter2Config.isPresent());
        EventSetupTest.assertReporter2Configured(reporter2Config.get());
    }

    @Test
    void testActivateOneReporterAmongTwoDeclared() {
        Configuration config = new Configuration();
        EventSetupTest.configureReporter1(config);
        EventSetupTest.configureReporter2(config);
        config.set(EventOptions.REPORTERS_LIST, (Object)"reporter2");
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        EventReporterSetup setup = (EventReporterSetup)reporterSetups.get(0);
        EventSetupTest.assertReporter2Configured(setup);
    }

    @Test
    void testReporterSetupSupplier() throws Exception {
        Configuration config = new Configuration();
        EventOptions.forReporter((Configuration)config, (String)"reporter1").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporter1.class.getName());
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        EventReporterSetup reporterSetup = (EventReporterSetup)reporterSetups.get(0);
        Assert.assertThat((Object)((EventReporter)reporterSetup.getReporter()), (Matcher)IsInstanceOf.instanceOf(TestEventReporter1.class));
    }

    @Test
    void testMultipleReporterInstantiation() throws Exception {
        Configuration config = new Configuration();
        EventOptions.forReporter((Configuration)config, (String)"test1").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporter11.class.getName());
        EventOptions.forReporter((Configuration)config, (String)"test2").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporter12.class.getName());
        EventOptions.forReporter((Configuration)config, (String)"test3").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporter13.class.getName());
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)3L, (long)reporterSetups.size());
        Assert.assertTrue((boolean)TestEventReporter11.wasOpened);
        Assert.assertTrue((boolean)TestEventReporter12.wasOpened);
        Assert.assertTrue((boolean)TestEventReporter13.wasOpened);
    }

    private static void configureReporter1(Configuration config) {
        Configuration reporterConfig = EventOptions.forReporter((Configuration)config, (String)"reporter1").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporter1.class.getName());
        reporterConfig.setString("arg1", "value1");
        reporterConfig.setString("arg2", "value2");
    }

    private static void assertEventReporter1Configured(EventReporterSetup setup) {
        Assert.assertEquals((Object)"reporter1", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", ""));
        Assert.assertEquals((Object)"value2", (Object)setup.getConfiguration().getString("arg2", ""));
        Assert.assertEquals((Object)TestEventReporter1.class.getName(), (Object)setup.getConfiguration().getString(EventOptions.REPORTER_FACTORY_CLASS.key(), null));
    }

    private static void configureReporter2(Configuration config) {
        Configuration reporterConfig = EventOptions.forReporter((Configuration)config, (String)"reporter2").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporter2.class.getName());
        reporterConfig.setString("arg1", "value1");
        reporterConfig.setString("arg3", "value3");
    }

    private static void assertReporter2Configured(EventReporterSetup setup) {
        Assert.assertEquals((Object)"reporter2", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", null));
        Assert.assertEquals((Object)"value3", (Object)setup.getConfiguration().getString("arg3", null));
        Assert.assertEquals((Object)TestEventReporter2.class.getName(), (Object)setup.getConfiguration().getString(EventOptions.REPORTER_FACTORY_CLASS.key(), null));
    }

    @Test
    void testVariableExclusionParsing() throws Exception {
        String excludedVariable1 = "foo";
        String excludedVariable2 = "foo";
        Configuration config = new Configuration();
        EventOptions.forReporter((Configuration)config, (String)"test").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporterFactory.class.getName()).set(EventOptions.REPORTER_EXCLUDED_VARIABLES, (Object)"foo;foo");
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        EventReporterSetup reporterSetup = (EventReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getExcludedVariables(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{ScopeFormat.asVariable((String)"foo"), ScopeFormat.asVariable((String)"foo")}));
    }

    @Test
    void testFactoryParsing() throws Exception {
        Configuration config = new Configuration();
        EventOptions.forReporter((Configuration)config, (String)"test").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporterFactory.class.getName());
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        EventReporterSetup reporterSetup = (EventReporterSetup)reporterSetups.get(0);
        Assert.assertEquals((Object)TestEventReporterFactory.REPORTER, (Object)reporterSetup.getReporter());
    }

    @Test
    void testFactoryFailureIsolation() throws Exception {
        Configuration config = new Configuration();
        config.setString("events.reporter.test." + EventOptions.REPORTER_FACTORY_CLASS.key(), TestEventReporterFactory.class.getName());
        config.setString("events.reporter.fail." + EventOptions.REPORTER_FACTORY_CLASS.key(), FailingFactory.class.getName());
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
    }

    @Test
    void testFactoryArgumentForwarding() throws Exception {
        Configuration config = new Configuration();
        config.setString("events.reporter.test." + EventOptions.REPORTER_FACTORY_CLASS.key(), ConfigExposingReporterFactory.class.getName());
        config.setString("events.reporter.test.arg", "hello");
        ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Properties passedConfig = ConfigExposingReporterFactory.lastConfig;
        Assert.assertEquals((Object)"hello", (Object)passedConfig.getProperty("arg"));
    }

    @Test
    void testAdditionalVariablesParsing() {
        String tag1 = "foo";
        String tagValue1 = "bar";
        String tag2 = "fizz";
        String tagValue2 = "buzz";
        Configuration config = new Configuration();
        EventOptions.forReporter((Configuration)config, (String)"test").set(EventOptions.REPORTER_FACTORY_CLASS, (Object)TestEventReporterFactory.class.getName()).setString(EventOptions.REPORTER_ADDITIONAL_VARIABLES.key(), String.join((CharSequence)",", "foo:bar", "fizz:buzz"));
        List reporterSetups = ReporterSetupBuilder.EVENT_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::eventsFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        EventReporterSetup reporterSetup = (EventReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getAdditionalVariables(), (Matcher)IsMapContaining.hasEntry((Object)ScopeFormat.asVariable((String)"foo"), (Object)"bar"));
        MatcherAssert.assertThat((Object)reporterSetup.getAdditionalVariables(), (Matcher)IsMapContaining.hasEntry((Object)ScopeFormat.asVariable((String)"fizz"), (Object)"buzz"));
    }

    public static class FailingFactory
    implements EventReporterFactory {
        public EventReporter createEventReporter(Properties config) {
            throw new RuntimeException();
        }
    }

    public static class TestEventReporterFactory
    implements EventReporterFactory {
        static final EventReporter REPORTER = new TestEventReporter();

        public EventReporter createEventReporter(Properties config) {
            return REPORTER;
        }
    }

    public static class ConfigExposingReporterFactory
    implements EventReporterFactory {
        static Properties lastConfig = null;

        public EventReporter createEventReporter(Properties config) {
            lastConfig = config;
            return new TestEventReporter();
        }
    }

    public static class TestEventReporter13
    extends TestEventReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestEventReporter12
    extends TestEventReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestEventReporter11
    extends TestEventReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestEventReporter2
    extends TestEventReporter {
    }

    public static class TestEventReporter1
    extends TestEventReporter {
    }
}

